/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.nodes.java;

import java.lang.ref.Reference;
import java.util.Collections;
import jdk.graal.compiler.core.common.type.StampFactory;
import jdk.graal.compiler.core.common.type.TypeReference;
import jdk.graal.compiler.debug.GraalError;
import jdk.graal.compiler.graph.NodeClass;
import jdk.graal.compiler.nodeinfo.NodeInfo;
import jdk.graal.compiler.nodes.ConstantNode;
import jdk.graal.compiler.nodes.FrameState;
import jdk.graal.compiler.nodes.ValueNode;
import jdk.graal.compiler.nodes.java.AbstractNewObjectNode;
import jdk.graal.compiler.nodes.spi.VirtualizableAllocation;
import jdk.graal.compiler.nodes.spi.VirtualizerTool;
import jdk.graal.compiler.nodes.virtual.VirtualInstanceNode;
import jdk.vm.ci.meta.ResolvedJavaField;
import jdk.vm.ci.meta.ResolvedJavaType;

@NodeInfo(nameTemplate="New {p#instanceClass/s}")
public class NewInstanceNode
extends AbstractNewObjectNode
implements VirtualizableAllocation {
    public static final NodeClass<NewInstanceNode> TYPE = NodeClass.create(NewInstanceNode.class);
    protected final ResolvedJavaType instanceClass;

    public NewInstanceNode(ResolvedJavaType type, boolean fillContents) {
        this(TYPE, type, fillContents, null);
    }

    public NewInstanceNode(ResolvedJavaType type, boolean fillContents, FrameState stateBefore) {
        this(TYPE, type, fillContents, stateBefore);
    }

    protected NewInstanceNode(NodeClass<? extends NewInstanceNode> c, ResolvedJavaType type, boolean fillContents, FrameState stateBefore) {
        super(c, StampFactory.objectNonNull(TypeReference.createExactTrusted(type)), fillContents, stateBefore);
        GraalError.guarantee(!type.isArray() && !type.isInterface() && !type.isPrimitive() && !type.isAbstract(), "Cannot instantiate type %s", (Object)type);
        this.instanceClass = type;
    }

    public ResolvedJavaType instanceClass() {
        return this.instanceClass;
    }

    @Override
    public void virtualize(VirtualizerTool tool) {
        if (!tool.getMetaAccess().lookupJavaType(Reference.class).isAssignableFrom(this.instanceClass) && tool.getMetaAccessExtensionProvider().canVirtualize(this.instanceClass)) {
            VirtualInstanceNode virtualObject = new VirtualInstanceNode(this.instanceClass(), true);
            ResolvedJavaField[] fields = virtualObject.getFields();
            ValueNode[] state = new ValueNode[fields.length];
            for (int i = 0; i < state.length; ++i) {
                state[i] = ConstantNode.defaultForKind(tool.getMetaAccessExtensionProvider().getStorageKind(fields[i].getType()), this.graph());
            }
            tool.createVirtualObject(virtualObject, state, Collections.emptyList(), this.getNodeSourcePosition(), false);
            tool.replaceWithVirtual(virtualObject);
        }
    }
}

