/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.nodes.java;

import jdk.graal.compiler.core.common.type.Stamp;
import jdk.graal.compiler.core.common.type.StampFactory;
import jdk.graal.compiler.core.common.type.TypeReference;
import jdk.graal.compiler.graph.Node;
import jdk.graal.compiler.graph.NodeClass;
import jdk.graal.compiler.nodeinfo.NodeCycles;
import jdk.graal.compiler.nodeinfo.NodeInfo;
import jdk.graal.compiler.nodeinfo.NodeSize;
import jdk.graal.compiler.nodes.FixedNode;
import jdk.graal.compiler.nodes.FrameState;
import jdk.graal.compiler.nodes.ValueNode;
import jdk.graal.compiler.nodes.java.AllocateWithExceptionNode;
import jdk.graal.compiler.nodes.java.NewArrayNode;
import jdk.vm.ci.meta.ResolvedJavaType;

@NodeInfo(cycles=NodeCycles.CYCLES_8, cyclesRationale="tlab alloc + header init", size=NodeSize.SIZE_8)
public class NewArrayWithExceptionNode
extends AllocateWithExceptionNode {
    public static final NodeClass<NewArrayWithExceptionNode> TYPE = NodeClass.create(NewArrayWithExceptionNode.class);
    private final ResolvedJavaType elementType;
    final boolean fillContents;
    @Node.Input
    protected ValueNode length;

    public NewArrayWithExceptionNode(ResolvedJavaType elementType, ValueNode length, boolean fillContents) {
        super((NodeClass<? extends AllocateWithExceptionNode>)TYPE, (Stamp)StampFactory.objectNonNull(TypeReference.createExactTrusted(elementType.getArrayClass())));
        this.elementType = elementType;
        this.length = length;
        this.fillContents = fillContents;
    }

    public NewArrayWithExceptionNode(ResolvedJavaType elementType, ValueNode length, boolean fillContents, FrameState stateBefore, FrameState stateAfter) {
        super((NodeClass<? extends AllocateWithExceptionNode>)TYPE, (Stamp)StampFactory.objectNonNull(TypeReference.createExactTrusted(elementType.getArrayClass())));
        this.elementType = elementType;
        this.length = length;
        this.fillContents = fillContents;
        this.stateBefore = stateBefore;
        this.stateAfter = stateAfter;
    }

    public ValueNode length() {
        return this.length;
    }

    public ResolvedJavaType elementType() {
        return this.elementType;
    }

    public boolean fillContents() {
        return this.fillContents;
    }

    @Override
    public FixedNode replaceWithNonThrowing() {
        this.killExceptionEdge();
        NewArrayNode newArray = this.graph().add(new NewArrayNode(this.elementType, this.length, this.fillContents, this.stateBefore));
        this.graph().replaceSplitWithFixed(this, newArray, this.next());
        newArray.setNodeSourcePosition(this.getNodeSourcePosition());
        return newArray;
    }
}

