/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.nodes.java;

import jdk.graal.compiler.core.common.LIRKind;
import jdk.graal.compiler.core.common.memory.BarrierType;
import jdk.graal.compiler.core.common.memory.MemoryOrderMode;
import jdk.graal.compiler.core.common.type.StampFactory;
import jdk.graal.compiler.graph.NodeClass;
import jdk.graal.compiler.lir.Variable;
import jdk.graal.compiler.lir.gen.LIRGeneratorTool;
import jdk.graal.compiler.nodeinfo.NodeCycles;
import jdk.graal.compiler.nodeinfo.NodeInfo;
import jdk.graal.compiler.nodeinfo.NodeSize;
import jdk.graal.compiler.nodes.NodeView;
import jdk.graal.compiler.nodes.ValueNode;
import jdk.graal.compiler.nodes.java.AbstractCompareAndSwapNode;
import jdk.graal.compiler.nodes.memory.address.AddressNode;
import jdk.graal.compiler.nodes.spi.NodeLIRBuilderTool;
import jdk.vm.ci.meta.Constant;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.Value;
import org.graalvm.word.LocationIdentity;

@NodeInfo(cycles=NodeCycles.CYCLES_8, size=NodeSize.SIZE_8)
public final class LogicCompareAndSwapNode
extends AbstractCompareAndSwapNode {
    public static final NodeClass<LogicCompareAndSwapNode> TYPE = NodeClass.create(LogicCompareAndSwapNode.class);

    public LogicCompareAndSwapNode(AddressNode address, ValueNode expectedValue, ValueNode newValue, LocationIdentity location, BarrierType barrierType, MemoryOrderMode memoryOrder) {
        super(TYPE, address, location, expectedValue, newValue, barrierType, StampFactory.forInteger(JavaKind.Int, 0L, 1L), memoryOrder);
    }

    @Override
    public void generate(NodeLIRBuilderTool gen) {
        assert (this.getNewValue().stamp(NodeView.DEFAULT).isCompatible(this.getExpectedValue().stamp(NodeView.DEFAULT)));
        assert (!this.canDeoptimize());
        LIRGeneratorTool tool = gen.getLIRGeneratorTool();
        LIRKind resultKind = tool.getLIRKind(this.stamp(NodeView.DEFAULT));
        Value trueResult = tool.emitConstant(resultKind, (Constant)JavaConstant.TRUE);
        Value falseResult = tool.emitConstant(resultKind, (Constant)JavaConstant.FALSE);
        Variable result = tool.emitLogicCompareAndSwap(tool.getLIRKind(this.getAccessStamp(NodeView.DEFAULT)), gen.operand(this.getAddress()), gen.operand(this.getExpectedValue()), gen.operand(this.getNewValue()), trueResult, falseResult, this.memoryOrder, this.getBarrierType());
        gen.setResult(this, (Value)result);
    }
}

