/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.nodes.java;

import jdk.graal.compiler.core.common.type.StampFactory;
import jdk.graal.compiler.graph.Node;
import jdk.graal.compiler.graph.NodeClass;
import jdk.graal.compiler.nodeinfo.NodeCycles;
import jdk.graal.compiler.nodeinfo.NodeInfo;
import jdk.graal.compiler.nodeinfo.NodeSize;
import jdk.graal.compiler.nodes.FixedNode;
import jdk.graal.compiler.nodes.ValueNode;
import jdk.graal.compiler.nodes.java.AllocateWithExceptionNode;
import jdk.graal.compiler.nodes.java.DynamicNewInstanceNode;
import jdk.graal.compiler.nodes.java.NewInstanceWithExceptionNode;
import jdk.graal.compiler.nodes.spi.Canonicalizable;
import jdk.graal.compiler.nodes.spi.CanonicalizerTool;
import jdk.vm.ci.meta.ResolvedJavaType;

@NodeInfo(cycles=NodeCycles.CYCLES_8, cyclesRationale="tlab alloc + header init", size=NodeSize.SIZE_8)
public class DynamicNewInstanceWithExceptionNode
extends AllocateWithExceptionNode
implements Canonicalizable {
    public static final NodeClass<DynamicNewInstanceWithExceptionNode> TYPE = NodeClass.create(DynamicNewInstanceWithExceptionNode.class);
    @Node.Input
    ValueNode clazz;
    protected boolean fillContents;

    public DynamicNewInstanceWithExceptionNode(ValueNode clazz, boolean fillContents) {
        super((NodeClass<? extends AllocateWithExceptionNode>)TYPE, StampFactory.objectNonNull());
        this.fillContents = fillContents;
        this.clazz = clazz;
    }

    public ValueNode getInstanceType() {
        return this.clazz;
    }

    @Override
    public Node canonical(CanonicalizerTool tool) {
        ResolvedJavaType type = DynamicNewInstanceNode.tryConvertToNonDynamic(this.clazz, tool);
        if (type != null) {
            return new NewInstanceWithExceptionNode(type, this.fillContents, this.stateBefore, this.stateAfter);
        }
        return this;
    }

    @Override
    public FixedNode replaceWithNonThrowing() {
        this.killExceptionEdge();
        DynamicNewInstanceNode newInstance = this.graph().add(new DynamicNewInstanceNode(this.clazz, this.fillContents));
        newInstance.setStateBefore(this.stateBefore);
        this.graph().replaceSplitWithFixed(this, newInstance, this.next());
        newInstance.setNodeSourcePosition(this.getNodeSourcePosition());
        return newInstance;
    }
}

