/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.nodes.java;

import jdk.graal.compiler.core.common.type.StampFactory;
import jdk.graal.compiler.graph.Node;
import jdk.graal.compiler.graph.NodeClass;
import jdk.graal.compiler.nodeinfo.InputType;
import jdk.graal.compiler.nodeinfo.NodeCycles;
import jdk.graal.compiler.nodeinfo.NodeInfo;
import jdk.graal.compiler.nodeinfo.NodeSize;
import jdk.graal.compiler.nodes.ValueNode;
import jdk.graal.compiler.nodes.memory.AbstractMemoryCheckpoint;
import jdk.graal.compiler.nodes.memory.SingleMemoryKill;
import jdk.graal.compiler.nodes.spi.Lowerable;
import jdk.graal.compiler.nodes.spi.TrackedUnsafeAccess;
import jdk.vm.ci.meta.JavaKind;
import org.graalvm.word.LocationIdentity;

@NodeInfo(allowedUsageTypes={InputType.Memory}, cycles=NodeCycles.CYCLES_8, size=NodeSize.SIZE_2)
public final class AtomicReadAndAddNode
extends AbstractMemoryCheckpoint
implements Lowerable,
SingleMemoryKill,
TrackedUnsafeAccess {
    public static final NodeClass<AtomicReadAndAddNode> TYPE = NodeClass.create(AtomicReadAndAddNode.class);
    @Node.Input
    ValueNode object;
    @Node.Input
    ValueNode offset;
    @Node.Input
    ValueNode delta;
    private JavaKind valueKind;
    protected final LocationIdentity locationIdentity;

    public AtomicReadAndAddNode(ValueNode object, ValueNode offset, ValueNode delta, JavaKind valueKind, LocationIdentity locationIdentity) {
        super((NodeClass<? extends AbstractMemoryCheckpoint>)TYPE, StampFactory.forKind(valueKind));
        this.object = object;
        this.offset = offset;
        this.delta = delta;
        this.valueKind = valueKind;
        this.locationIdentity = locationIdentity;
    }

    public ValueNode object() {
        return this.object;
    }

    public ValueNode offset() {
        return this.offset;
    }

    public ValueNode delta() {
        return this.delta;
    }

    public JavaKind getValueKind() {
        return this.valueKind;
    }

    @Override
    public LocationIdentity getKilledLocationIdentity() {
        return this.locationIdentity;
    }
}

