/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.nodes.java;

import jdk.graal.compiler.core.common.type.StampFactory;
import jdk.graal.compiler.graph.Node;
import jdk.graal.compiler.graph.NodeClass;
import jdk.graal.compiler.nodeinfo.InputType;
import jdk.graal.compiler.nodeinfo.NodeInfo;
import jdk.graal.compiler.nodes.DeoptimizingNode;
import jdk.graal.compiler.nodes.FrameState;
import jdk.graal.compiler.nodes.ValueNode;
import jdk.graal.compiler.nodes.java.MonitorIdNode;
import jdk.graal.compiler.nodes.memory.AbstractMemoryCheckpoint;
import jdk.graal.compiler.nodes.memory.SingleMemoryKill;

@NodeInfo(allowedUsageTypes={InputType.Memory})
public abstract class AccessMonitorNode
extends AbstractMemoryCheckpoint
implements SingleMemoryKill,
DeoptimizingNode.DeoptBefore,
DeoptimizingNode.DeoptAfter {
    public static final NodeClass<AccessMonitorNode> TYPE = NodeClass.create(AccessMonitorNode.class);
    @Node.OptionalInput(value=InputType.State)
    FrameState stateBefore;
    @Node.Input
    ValueNode object;
    @Node.Input(value=InputType.Association)
    MonitorIdNode monitorId;
    @Node.OptionalInput
    private ValueNode objectData;
    protected boolean biasable = true;

    protected AccessMonitorNode(NodeClass<? extends AccessMonitorNode> c, ValueNode object, MonitorIdNode monitorId, boolean biasable) {
        super((NodeClass<? extends AbstractMemoryCheckpoint>)c, StampFactory.forVoid());
        this.object = object;
        this.monitorId = monitorId;
        this.biasable = biasable;
    }

    protected AccessMonitorNode(NodeClass<? extends AccessMonitorNode> c, ValueNode object, MonitorIdNode monitorId) {
        this(c, object, monitorId, true);
    }

    @Override
    public boolean canDeoptimize() {
        return true;
    }

    @Override
    public FrameState stateBefore() {
        return this.stateBefore;
    }

    @Override
    public void setStateBefore(FrameState f) {
        this.updateUsages(this.stateBefore, f);
        this.stateBefore = f;
    }

    public ValueNode object() {
        return this.object;
    }

    public void setObject(ValueNode lockedObject) {
        this.updateUsages(this.object, lockedObject);
        this.object = lockedObject;
    }

    public ValueNode getObjectData() {
        return this.objectData;
    }

    public void setObjectData(ValueNode objectData) {
        this.updateUsages(this.objectData, objectData);
        this.objectData = objectData;
    }

    public MonitorIdNode getMonitorId() {
        return this.monitorId;
    }
}

