/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.nodes.java;

import jdk.graal.compiler.core.common.memory.MemoryOrderMode;
import jdk.graal.compiler.core.common.type.Stamp;
import jdk.graal.compiler.graph.Node;
import jdk.graal.compiler.graph.NodeClass;
import jdk.graal.compiler.nodeinfo.NodeCycles;
import jdk.graal.compiler.nodeinfo.NodeInfo;
import jdk.graal.compiler.nodeinfo.NodeSize;
import jdk.graal.compiler.nodeinfo.Verbosity;
import jdk.graal.compiler.nodes.FieldLocationIdentity;
import jdk.graal.compiler.nodes.FixedWithNextNode;
import jdk.graal.compiler.nodes.ValueNode;
import jdk.graal.compiler.nodes.memory.MemoryAccess;
import jdk.graal.compiler.nodes.memory.OrderedMemoryAccess;
import jdk.graal.compiler.nodes.spi.Lowerable;
import jdk.vm.ci.meta.ResolvedJavaField;

@NodeInfo(cycles=NodeCycles.CYCLES_2, size=NodeSize.SIZE_1)
public abstract class AccessFieldNode
extends FixedWithNextNode
implements Lowerable,
OrderedMemoryAccess,
MemoryAccess {
    public static final NodeClass<AccessFieldNode> TYPE = NodeClass.create(AccessFieldNode.class);
    @Node.OptionalInput
    ValueNode object;
    protected final FieldLocationIdentity location;
    protected final ResolvedJavaField field;
    protected final MemoryOrderMode memoryOrder;

    public ValueNode object() {
        return this.object;
    }

    public void setObject(ValueNode otherObject) {
        this.updateUsages(this.object, otherObject);
        this.object = otherObject;
    }

    public AccessFieldNode(NodeClass<? extends AccessFieldNode> c, Stamp stamp, ValueNode object, ResolvedJavaField field, MemoryOrderMode memoryOrder, boolean immutable) {
        super((NodeClass<? extends FixedWithNextNode>)c, stamp);
        assert (!immutable || field.isFinal()) : "immutable fields must also be final";
        assert (!immutable || !field.isStatic()) : "immutable fields must also be non-static";
        this.object = object;
        this.field = field;
        this.memoryOrder = memoryOrder;
        this.location = new FieldLocationIdentity(field, immutable);
    }

    public AccessFieldNode(NodeClass<? extends AccessFieldNode> c, Stamp stamp, ValueNode object, ResolvedJavaField field) {
        this(c, stamp, object, field, MemoryOrderMode.getMemoryOrder(field), false);
    }

    @Override
    public FieldLocationIdentity getLocationIdentity() {
        return this.location;
    }

    public ResolvedJavaField field() {
        return this.field;
    }

    public boolean isStatic() {
        return this.field.isStatic();
    }

    @Override
    public MemoryOrderMode getMemoryOrder() {
        return this.memoryOrder;
    }

    @Override
    public String toString(Verbosity verbosity) {
        if (verbosity == Verbosity.Name && this.field != null) {
            return super.toString(verbosity) + "#" + this.field.getName();
        }
        return super.toString(verbosity);
    }

    @Override
    public boolean verifyNode() {
        this.assertTrue(this.object == null == this.isStatic(), "static field must not have object, instance field must have object", new Object[0]);
        return super.verifyNode();
    }

    @Override
    protected NodeSize dynamicNodeSizeEstimate() {
        if (this.ordersMemoryAccesses()) {
            return NodeSize.SIZE_2;
        }
        return super.dynamicNodeSizeEstimate();
    }
}

