/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.nodes.graphbuilderconf;

import jdk.graal.compiler.bytecode.BytecodeProvider;
import jdk.graal.compiler.debug.Assertions;
import jdk.graal.compiler.graph.NodeSourcePosition;
import jdk.graal.compiler.nodes.AbstractMergeNode;
import jdk.graal.compiler.nodes.FrameState;
import jdk.graal.compiler.nodes.LoopExitNode;
import jdk.graal.compiler.nodes.StateSplit;
import jdk.graal.compiler.nodes.StructuredGraph;
import jdk.graal.compiler.nodes.java.ExceptionObjectNode;
import jdk.vm.ci.meta.ResolvedJavaMethod;

public class IntrinsicContext {
    final ResolvedJavaMethod originalMethod;
    final ResolvedJavaMethod intrinsicMethod;
    final BytecodeProvider bytecodeProvider;
    final CompilationContext compilationContext;
    final boolean allowPartialIntrinsicArgumentMismatch;

    public IntrinsicContext(ResolvedJavaMethod method, ResolvedJavaMethod intrinsic, BytecodeProvider bytecodeProvider, CompilationContext compilationContext) {
        this(method, intrinsic, bytecodeProvider, compilationContext, false);
    }

    public IntrinsicContext(ResolvedJavaMethod method, ResolvedJavaMethod intrinsic, BytecodeProvider bytecodeProvider, CompilationContext compilationContext, boolean allowPartialIntrinsicArgumentMismatch) {
        this.originalMethod = method;
        this.intrinsicMethod = intrinsic;
        this.bytecodeProvider = bytecodeProvider;
        assert (bytecodeProvider != null);
        this.compilationContext = compilationContext;
        this.allowPartialIntrinsicArgumentMismatch = allowPartialIntrinsicArgumentMismatch;
    }

    public boolean allowPartialIntrinsicArgumentMismatch() {
        return this.allowPartialIntrinsicArgumentMismatch;
    }

    public ResolvedJavaMethod getOriginalMethod() {
        return this.originalMethod;
    }

    public ResolvedJavaMethod getIntrinsicMethod() {
        return this.intrinsicMethod;
    }

    public BytecodeProvider getBytecodeProvider() {
        return this.bytecodeProvider;
    }

    public boolean isCallToOriginal(ResolvedJavaMethod targetMethod) {
        return this.originalMethod.equals((Object)targetMethod) || this.intrinsicMethod.equals((Object)targetMethod);
    }

    public boolean isPostParseInlined() {
        return this.compilationContext.equals((Object)CompilationContext.INLINE_AFTER_PARSING);
    }

    public boolean isDeferredInvoke(StateSplit stateSplit) {
        return false;
    }

    public FrameState createFrameState(StructuredGraph graph, SideEffectsState sideEffects, StateSplit forStateSplit, NodeSourcePosition sourcePosition) {
        assert (forStateSplit != graph.start()) : Assertions.errorMessageContext("forStateSplit", forStateSplit, "graph.start", graph.start());
        if (forStateSplit.hasSideEffect()) {
            FrameState frameState;
            if (sideEffects.isAfterSideEffect()) {
                FrameState invalid = graph.add(new FrameState(-6));
                if (graph.trackNodeSourcePosition()) {
                    invalid.setNodeSourcePosition(sourcePosition);
                }
                for (StateSplit lastSideEffect : sideEffects.sideEffects()) {
                    lastSideEffect.setStateAfter(invalid);
                }
            }
            if (this.isDeferredInvoke(forStateSplit)) {
                frameState = graph.add(new FrameState(-6));
            } else {
                sideEffects.addSideEffect(forStateSplit);
                frameState = forStateSplit instanceof ExceptionObjectNode ? graph.add(new FrameState(-4, (ExceptionObjectNode)forStateSplit)) : graph.add(new FrameState(-3));
            }
            if (graph.trackNodeSourcePosition()) {
                frameState.setNodeSourcePosition(sourcePosition);
            }
            return frameState;
        }
        if (forStateSplit instanceof AbstractMergeNode || forStateSplit instanceof LoopExitNode) {
            if (sideEffects.isAfterSideEffect()) {
                FrameState frameState = graph.add(new FrameState(-3));
                if (graph.trackNodeSourcePosition()) {
                    frameState.setNodeSourcePosition(sourcePosition);
                }
                return frameState;
            }
            FrameState frameState = graph.add(new FrameState(-2));
            if (graph.trackNodeSourcePosition()) {
                frameState.setNodeSourcePosition(sourcePosition);
            }
            return frameState;
        }
        return null;
    }

    public String toString() {
        return "Intrinsic{original: " + this.originalMethod.format("%H.%n(%p)") + ", intrinsic: " + (this.intrinsicMethod != null ? this.intrinsicMethod.format("%H.%n(%p)") : "null") + ", context: " + String.valueOf((Object)this.compilationContext) + "}";
    }

    public static enum CompilationContext {
        INLINE_DURING_PARSING,
        INLINE_AFTER_PARSING;

    }

    public static interface SideEffectsState {
        public boolean isAfterSideEffect();

        public Iterable<StateSplit> sideEffects();

        public void addSideEffect(StateSplit var1);
    }
}

