/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.nodes.graphbuilderconf;

import java.lang.annotation.Annotation;
import java.lang.reflect.Executable;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.List;
import jdk.graal.compiler.api.replacements.Fold;
import jdk.graal.compiler.debug.GraalError;
import jdk.graal.compiler.graph.Node;
import jdk.graal.compiler.nodes.PluginReplacementNode;
import jdk.graal.compiler.nodes.ValueNode;
import jdk.graal.compiler.nodes.graphbuilderconf.GeneratedFoldInvocationPlugin;
import jdk.graal.compiler.nodes.graphbuilderconf.GraphBuilderContext;
import jdk.graal.compiler.nodes.graphbuilderconf.InvocationPlugin;
import jdk.vm.ci.meta.MetaAccessProvider;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import jdk.vm.ci.meta.ResolvedJavaType;
import org.graalvm.nativeimage.ImageInfo;

public abstract class GeneratedInvocationPlugin
extends InvocationPlugin.RequiredInlineOnlyInvocationPlugin {
    private static List<Class<?>> foldNodePluginClasses = List.of(GeneratedFoldInvocationPlugin.class, PluginReplacementNode.ReplacementFunction.class);
    private ResolvedJavaMethod executeMethod;

    public static void setFoldNodePluginClasses(List<Class<?>> customFoldNodePluginClasses) {
        foldNodePluginClasses = customFoldNodePluginClasses;
    }

    public static List<Class<?>> getFoldNodePluginClasses() {
        return foldNodePluginClasses;
    }

    public GeneratedInvocationPlugin(String name, Type ... argumentTypes) {
        super(name, argumentTypes);
    }

    public abstract Class<? extends Annotation> getSource();

    @Override
    public abstract boolean execute(GraphBuilderContext var1, ResolvedJavaMethod var2, InvocationPlugin.Receiver var3, ValueNode[] var4);

    @Override
    public String getSourceLocation() {
        Class<?> c = this.getClass();
        for (Method m : c.getDeclaredMethods()) {
            if (!m.getName().equals("execute")) continue;
            return String.format("%s.%s()", m.getDeclaringClass().getName(), m.getName());
        }
        throw new GraalError("could not find method named \"execute\" in " + c.getName());
    }

    protected boolean checkInjectedArgument(GraphBuilderContext b, ValueNode arg, ResolvedJavaMethod foldAnnotatedMethod) {
        if (arg.isNullConstant()) {
            return true;
        }
        if (ImageInfo.inImageRuntimeCode()) {
            return true;
        }
        if (b.getMethod().equals((Object)foldAnnotatedMethod)) {
            return false;
        }
        if (ImageInfo.inImageBuildtimeCode()) {
            for (Class<?> foldNodePluginClass : foldNodePluginClasses) {
                ResolvedJavaType foldNodeClass = b.getMetaAccess().lookupJavaType(foldNodePluginClass);
                if (!foldNodeClass.isAssignableFrom(b.getMethod().getDeclaringClass())) continue;
                return false;
            }
        }
        ResolvedJavaMethod thisExecuteMethod = this.getExecutedMethod(b);
        if (b.getMethod().equals((Object)thisExecuteMethod)) {
            return true;
        }
        throw new AssertionError((Object)("must pass null to injected argument of " + foldAnnotatedMethod.format("%H.%n(%p)") + ", not " + String.valueOf(arg) + " in " + b.getMethod().format("%H.%n(%p)")));
    }

    private ResolvedJavaMethod getExecutedMethod(GraphBuilderContext b) {
        if (this.executeMethod == null) {
            MetaAccessProvider metaAccess = b.getMetaAccess();
            ResolvedJavaMethod baseMethod = metaAccess.lookupJavaMethod((Executable)GeneratedInvocationPlugin.getExecuteMethod());
            ResolvedJavaType thisClass = metaAccess.lookupJavaType(this.getClass());
            this.executeMethod = thisClass.resolveConcreteMethod(baseMethod, thisClass);
        }
        return this.executeMethod;
    }

    private static Method getExecuteMethod() {
        try {
            return GeneratedInvocationPlugin.class.getMethod("execute", GraphBuilderContext.class, ResolvedJavaMethod.class, InvocationPlugin.Receiver.class, ValueNode[].class);
        }
        catch (NoSuchMethodException | SecurityException e) {
            throw new GraalError(e);
        }
    }

    public final boolean isGeneratedFromFoldOrNodeIntrinsic() {
        return this.getSource().equals(Fold.class) || this.getSource().equals(Node.NodeIntrinsic.class);
    }
}

