/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.nodes.gc;

import jdk.graal.compiler.graph.NodeClass;
import jdk.graal.compiler.lir.gen.G1WriteBarrierSetLIRGeneratorTool;
import jdk.graal.compiler.lir.gen.LIRGeneratorTool;
import jdk.graal.compiler.nodeinfo.NodeCycles;
import jdk.graal.compiler.nodeinfo.NodeInfo;
import jdk.graal.compiler.nodeinfo.NodeSize;
import jdk.graal.compiler.nodes.ValueNode;
import jdk.graal.compiler.nodes.gc.ObjectWriteBarrierNode;
import jdk.graal.compiler.nodes.gc.WriteBarrierNode;
import jdk.graal.compiler.nodes.memory.address.AddressNode;
import jdk.graal.compiler.nodes.spi.LIRLowerable;
import jdk.graal.compiler.nodes.spi.NodeLIRBuilderTool;

@NodeInfo(cycles=NodeCycles.CYCLES_64, size=NodeSize.SIZE_64)
public final class G1ReferentFieldReadBarrierNode
extends ObjectWriteBarrierNode
implements LIRLowerable {
    public static final NodeClass<G1ReferentFieldReadBarrierNode> TYPE = NodeClass.create(G1ReferentFieldReadBarrierNode.class);

    public G1ReferentFieldReadBarrierNode(AddressNode address, ValueNode expectedObject) {
        super(TYPE, address, expectedObject, true);
    }

    public ValueNode getExpectedObject() {
        return this.getValue();
    }

    @Override
    public WriteBarrierNode.Kind getKind() {
        return WriteBarrierNode.Kind.PRE_BARRIER;
    }

    @Override
    public void generate(NodeLIRBuilderTool generator) {
        LIRGeneratorTool lirGen = generator.getLIRGeneratorTool();
        G1WriteBarrierSetLIRGeneratorTool g1BarrierSet = (G1WriteBarrierSetLIRGeneratorTool)generator.getLIRGeneratorTool().getWriteBarrierSet();
        g1BarrierSet.emitPreWriteBarrier(lirGen, generator.operand(this.address), lirGen.asAllocatable(generator.operand(this.getExpectedObject())), false);
    }
}

