/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.nodes.gc;

import jdk.graal.compiler.core.common.type.StampFactory;
import jdk.graal.compiler.graph.Node;
import jdk.graal.compiler.graph.NodeClass;
import jdk.graal.compiler.nodeinfo.NodeInfo;
import jdk.graal.compiler.nodes.NodeView;
import jdk.graal.compiler.nodes.ValueNode;
import jdk.graal.compiler.nodes.calc.IntegerConvertNode;
import jdk.graal.compiler.nodes.gc.WriteBarrierNode;
import jdk.graal.compiler.nodes.memory.address.AddressNode;
import jdk.graal.compiler.nodes.spi.Lowerable;
import jdk.vm.ci.meta.JavaKind;

@NodeInfo
public abstract class ArrayRangeWriteBarrierNode
extends WriteBarrierNode
implements Lowerable {
    public static final NodeClass<ArrayRangeWriteBarrierNode> TYPE = NodeClass.create(ArrayRangeWriteBarrierNode.class);
    @Node.Input
    ValueNode length;
    private final int elementStride;

    protected ArrayRangeWriteBarrierNode(NodeClass<? extends ArrayRangeWriteBarrierNode> c, AddressNode address, ValueNode length, int elementStride) {
        super(c, address);
        this.length = length;
        this.elementStride = elementStride;
    }

    public ValueNode getLength() {
        return this.length;
    }

    public int getElementStride() {
        return this.elementStride;
    }

    public ValueNode getLengthAsLong() {
        return IntegerConvertNode.convert(this.length, StampFactory.forKind(JavaKind.Long), this.graph(), NodeView.DEFAULT);
    }
}

