/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.nodes.extended;

import jdk.graal.compiler.core.common.type.StampFactory;
import jdk.graal.compiler.graph.NodeClass;
import jdk.graal.compiler.nodeinfo.InputType;
import jdk.graal.compiler.nodeinfo.NodeCycles;
import jdk.graal.compiler.nodeinfo.NodeInfo;
import jdk.graal.compiler.nodeinfo.NodeSize;
import jdk.graal.compiler.nodes.ConstantNode;
import jdk.graal.compiler.nodes.FieldLocationIdentity;
import jdk.graal.compiler.nodes.ValueNode;
import jdk.graal.compiler.nodes.extended.AbstractBoxingNode;
import jdk.graal.compiler.nodes.extended.BoxNode;
import jdk.graal.compiler.nodes.spi.Canonicalizable;
import jdk.graal.compiler.nodes.spi.CanonicalizerTool;
import jdk.graal.compiler.nodes.spi.Lowerable;
import jdk.graal.compiler.nodes.spi.Virtualizable;
import jdk.graal.compiler.nodes.spi.VirtualizerTool;
import jdk.graal.compiler.nodes.type.StampTool;
import jdk.graal.compiler.nodes.util.GraphUtil;
import jdk.graal.compiler.nodes.virtual.VirtualObjectNode;
import jdk.vm.ci.meta.ConstantReflectionProvider;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.MetaAccessProvider;
import jdk.vm.ci.meta.ResolvedJavaType;

@NodeInfo(cycles=NodeCycles.CYCLES_2, size=NodeSize.SIZE_16, allowedUsageTypes={InputType.Value})
public final class UnboxNode
extends AbstractBoxingNode
implements Virtualizable,
Lowerable,
Canonicalizable.Unary<ValueNode> {
    public static final NodeClass<UnboxNode> TYPE = NodeClass.create(UnboxNode.class);

    public UnboxNode(ValueNode value, JavaKind boxingKind, MetaAccessProvider metaAccess) {
        super(TYPE, value, boxingKind, StampFactory.forKind(boxingKind.getStackKind()), new FieldLocationIdentity(UnboxNode.getValueField(UnboxNode.getResultType(metaAccess, boxingKind))));
    }

    private static ResolvedJavaType getResultType(MetaAccessProvider metaAccess, JavaKind boxingKind) {
        return metaAccess.lookupJavaType(boxingKind.toBoxedJavaClass());
    }

    public static ValueNode create(MetaAccessProvider metaAccess, ConstantReflectionProvider constantReflection, ValueNode value, JavaKind boxingKind) {
        ValueNode synonym = UnboxNode.findSynonym(metaAccess, constantReflection, value, boxingKind);
        if (synonym != null) {
            return synonym;
        }
        return new UnboxNode(value, boxingKind, metaAccess);
    }

    @Override
    public ValueNode getValue() {
        return this.value;
    }

    @Override
    public void virtualize(VirtualizerTool tool) {
        ResolvedJavaType expectedType;
        VirtualObjectNode virtual;
        ResolvedJavaType objectType;
        ValueNode alias = tool.getAlias(this.getValue());
        if (alias instanceof VirtualObjectNode && (objectType = (virtual = (VirtualObjectNode)alias).type()).equals((Object)(expectedType = tool.getMetaAccess().lookupJavaType(this.boxingKind.toBoxedJavaClass())))) {
            tool.replaceWithValue(tool.getEntry(virtual, 0));
        }
    }

    public ValueNode canonical(CanonicalizerTool tool, ValueNode forValue) {
        if (tool.allUsagesAvailable() && this.hasNoUsages() && StampTool.isPointerNonNull(forValue)) {
            return null;
        }
        ValueNode synonym = UnboxNode.findSynonym(tool.getMetaAccess(), tool.getConstantReflection(), forValue, this.boxingKind);
        if (synonym != null) {
            return synonym;
        }
        return this;
    }

    private static ValueNode findSynonym(MetaAccessProvider metaAccess, ConstantReflectionProvider constantReflection, ValueNode forValue, JavaKind boxingKind) {
        if (forValue.isConstant()) {
            JavaConstant constant = forValue.asJavaConstant();
            JavaConstant unboxed = constantReflection.unboxPrimitive(constant);
            if (unboxed != null && unboxed.getJavaKind() == boxingKind) {
                return ConstantNode.forConstant(unboxed, metaAccess);
            }
        } else {
            BoxNode box;
            BoxNode box2;
            ValueNode inputUnPi = GraphUtil.skipPi(forValue);
            if (inputUnPi instanceof BoxNode && boxingKind == (box2 = (BoxNode)inputUnPi).getBoxingKind()) {
                return box2.getValue();
            }
            ValueNode inputUnProxyify = GraphUtil.unproxify(forValue);
            if (inputUnProxyify instanceof BoxNode && ((BoxNode)inputUnProxyify).getValue().isConstant() && boxingKind == (box = (BoxNode)inputUnProxyify).getBoxingKind()) {
                return box.getValue();
            }
        }
        return null;
    }
}

