/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.nodes.extended;

import jdk.graal.compiler.core.common.memory.MemoryOrderMode;
import jdk.graal.compiler.core.common.type.ObjectStamp;
import jdk.graal.compiler.core.common.type.PrimitiveStamp;
import jdk.graal.compiler.core.common.type.Stamp;
import jdk.graal.compiler.core.common.type.StampFactory;
import jdk.graal.compiler.core.common.type.TypeReference;
import jdk.graal.compiler.debug.Assertions;
import jdk.graal.compiler.graph.Node;
import jdk.graal.compiler.graph.NodeClass;
import jdk.graal.compiler.nodeinfo.NodeCycles;
import jdk.graal.compiler.nodeinfo.NodeInfo;
import jdk.graal.compiler.nodeinfo.NodeSize;
import jdk.graal.compiler.nodes.GraphState;
import jdk.graal.compiler.nodes.NodeView;
import jdk.graal.compiler.nodes.ValueNode;
import jdk.graal.compiler.nodes.calc.ReinterpretNode;
import jdk.graal.compiler.nodes.extended.UnsafeAccessNode;
import jdk.graal.compiler.nodes.java.LoadFieldNode;
import jdk.graal.compiler.nodes.memory.MemoryKill;
import jdk.graal.compiler.nodes.memory.ReadNode;
import jdk.graal.compiler.nodes.memory.SingleMemoryKill;
import jdk.graal.compiler.nodes.spi.Canonicalizable;
import jdk.graal.compiler.nodes.spi.CanonicalizerTool;
import jdk.graal.compiler.nodes.spi.Lowerable;
import jdk.graal.compiler.nodes.spi.Virtualizable;
import jdk.graal.compiler.nodes.spi.VirtualizerTool;
import jdk.graal.compiler.nodes.type.StampTool;
import jdk.graal.compiler.nodes.virtual.VirtualArrayNode;
import jdk.graal.compiler.nodes.virtual.VirtualObjectNode;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.ResolvedJavaField;
import org.graalvm.word.LocationIdentity;

@NodeInfo(cycles=NodeCycles.CYCLES_2, size=NodeSize.SIZE_1)
public class RawLoadNode
extends UnsafeAccessNode
implements Lowerable,
Virtualizable,
Canonicalizable,
SingleMemoryKill {
    public static final NodeClass<RawLoadNode> TYPE = NodeClass.create(RawLoadNode.class);

    public RawLoadNode(ValueNode object, ValueNode offset, JavaKind accessKind, LocationIdentity locationIdentity) {
        this(object, offset, accessKind, locationIdentity, false, MemoryOrderMode.PLAIN);
    }

    public RawLoadNode(ValueNode object, ValueNode offset, JavaKind accessKind, LocationIdentity locationIdentity, MemoryOrderMode memoryOrder) {
        this(object, offset, accessKind, locationIdentity, false, memoryOrder);
    }

    public RawLoadNode(ValueNode object, ValueNode offset, JavaKind accessKind, LocationIdentity locationIdentity, boolean forceLocation, MemoryOrderMode memoryOrder) {
        super(TYPE, StampFactory.forKind(accessKind.getStackKind()), object, offset, accessKind, locationIdentity, forceLocation, memoryOrder);
    }

    public RawLoadNode(@Node.InjectedNodeParameter Stamp stamp, ValueNode object, ValueNode offset, LocationIdentity locationIdentity, JavaKind accessKind) {
        super(TYPE, stamp, object, offset, accessKind, locationIdentity, false, MemoryOrderMode.PLAIN);
    }

    static Stamp computeStampForArrayAccess(ValueNode object, JavaKind accessKind, Stamp oldStamp) {
        TypeReference type = StampTool.typeReferenceOrNull(object);
        if (accessKind.isObject() && type != null && type.getType().isArray() && type.getType().getComponentType().getJavaKind().isObject()) {
            TypeReference componentType = TypeReference.create(object.graph().getAssumptions(), type.getType().getComponentType());
            ObjectStamp newStamp = StampFactory.object(componentType);
            return oldStamp == null ? newStamp : oldStamp.improveWith(newStamp);
        }
        if (oldStamp != null) {
            return oldStamp;
        }
        return StampFactory.forKind(accessKind);
    }

    protected RawLoadNode(NodeClass<? extends RawLoadNode> c, ValueNode object, ValueNode offset, JavaKind accessKind, LocationIdentity locationIdentity) {
        this(c, object, offset, accessKind, locationIdentity, false, MemoryOrderMode.PLAIN);
    }

    protected RawLoadNode(NodeClass<? extends RawLoadNode> c, ValueNode object, ValueNode offset, JavaKind accessKind, LocationIdentity locationIdentity, boolean forceLocation) {
        this(c, object, offset, accessKind, locationIdentity, forceLocation, MemoryOrderMode.PLAIN);
    }

    protected RawLoadNode(NodeClass<? extends RawLoadNode> c, ValueNode object, ValueNode offset, JavaKind accessKind, LocationIdentity locationIdentity, boolean forceLocation, MemoryOrderMode memoryOrder) {
        super(c, RawLoadNode.computeStampForArrayAccess(object, accessKind, null), object, offset, accessKind, locationIdentity, forceLocation, memoryOrder);
    }

    @Override
    public LocationIdentity getKilledLocationIdentity() {
        if (this.ordersMemoryAccesses()) {
            return LocationIdentity.any();
        }
        return MemoryKill.NO_LOCATION;
    }

    @Override
    public boolean inferStamp() {
        if (this.accessKind.isObject()) {
            return this.updateStamp(RawLoadNode.computeStampForArrayAccess(this.object, this.accessKind, this.stamp));
        }
        return false;
    }

    @Override
    public void virtualize(VirtualizerTool tool) {
        ValueNode alias = tool.getAlias(this.object());
        if (alias instanceof VirtualObjectNode) {
            VirtualObjectNode virtual = (VirtualObjectNode)alias;
            ValueNode offsetValue = tool.getAlias(this.offset());
            if (offsetValue.isConstant()) {
                long off = offsetValue.asJavaConstant().asLong();
                int entryIndex = virtual.entryIndexForOffset(tool.getMetaAccess(), off, this.accessKind());
                if (entryIndex != -1) {
                    ValueNode entry = tool.getEntry(virtual, entryIndex);
                    JavaKind entryKind = virtual.entryKind(tool.getMetaAccessExtensionProvider(), entryIndex);
                    if (virtual.isVirtualByteArrayAccess(tool.getMetaAccessExtensionProvider(), this.accessKind())) {
                        if (virtual.canVirtualizeLargeByteArrayUnsafeRead(entry, entryIndex, this.accessKind(), tool)) {
                            tool.replaceWith(VirtualArrayNode.virtualizeByteArrayRead(entry, this.accessKind(), this.stamp));
                        }
                    } else if (entry.getStackKind() == this.getStackKind() || entryKind == this.accessKind()) {
                        if (!entry.stamp(NodeView.DEFAULT).isCompatible(this.stamp(NodeView.DEFAULT))) {
                            if (entry.stamp(NodeView.DEFAULT) instanceof PrimitiveStamp && this.stamp instanceof PrimitiveStamp) {
                                int width2;
                                PrimitiveStamp p1 = (PrimitiveStamp)this.stamp;
                                PrimitiveStamp p2 = (PrimitiveStamp)entry.stamp(NodeView.DEFAULT);
                                int width1 = p1.getBits();
                                if (width1 == (width2 = p2.getBits())) {
                                    ValueNode replacement = ReinterpretNode.create(p2, entry, NodeView.DEFAULT);
                                    tool.replaceWith(replacement);
                                    return;
                                }
                                return;
                            }
                            return;
                        }
                        tool.replaceWith(entry);
                    }
                }
            }
        }
    }

    @Override
    public Node canonical(CanonicalizerTool tool) {
        Node canonical = super.canonical(tool);
        if (canonical != this) {
            return canonical;
        }
        if (!this.isLocationForced()) {
            return ReadNode.canonicalizeRead(this, tool, this.accessKind, this.object, this.offset, this.locationIdentity);
        }
        return this;
    }

    @Override
    public ValueNode cloneAsFieldAccess(ResolvedJavaField field) {
        assert (field.getJavaKind() == this.accessKind()) : Assertions.errorMessageContext("field", field, "accessKind", this.accessKind);
        assert (!field.isInternal()) : field;
        assert (this.graph().isBeforeStage(GraphState.StageFlag.FLOATING_READS)) : "cannot add more precise memory location after floating read phase";
        return LoadFieldNode.create(this.graph().getAssumptions(), field.isStatic() ? null : this.object(), field, this.getMemoryOrder());
    }

    @Override
    protected ValueNode cloneAsArrayAccess(ValueNode location, LocationIdentity identity, MemoryOrderMode memoryOrder) {
        return new RawLoadNode(this.object(), location, this.accessKind(), identity, memoryOrder);
    }

    @Node.NodeIntrinsic
    public static native Object load(Object var0, long var1, @Node.ConstantNodeParameter JavaKind var3, @Node.ConstantNodeParameter LocationIdentity var4);

    @Node.NodeIntrinsic
    public static native int loadInt(Object var0, long var1, @Node.ConstantNodeParameter JavaKind var3, @Node.ConstantNodeParameter LocationIdentity var4);
}

