/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.nodes.extended;

import jdk.graal.compiler.graph.Node;
import jdk.graal.compiler.graph.NodeClass;
import jdk.graal.compiler.graph.iterators.FilteredNodeIterable;
import jdk.graal.compiler.nodeinfo.InputType;
import jdk.graal.compiler.nodeinfo.NodeCycles;
import jdk.graal.compiler.nodeinfo.NodeInfo;
import jdk.graal.compiler.nodeinfo.NodeSize;
import jdk.graal.compiler.nodes.FixedWithNextNode;
import jdk.graal.compiler.nodes.NodeView;
import jdk.graal.compiler.nodes.ValueNode;
import jdk.graal.compiler.nodes.extended.AnchoringNode;
import jdk.graal.compiler.nodes.extended.GuardingNode;
import jdk.graal.compiler.nodes.memory.MemoryAccess;
import jdk.graal.compiler.nodes.memory.MemoryKill;
import jdk.graal.compiler.nodes.memory.address.AddressNode;
import jdk.graal.compiler.nodes.spi.Canonicalizable;
import jdk.graal.compiler.nodes.spi.CanonicalizerTool;
import jdk.graal.compiler.nodes.spi.LIRLowerable;
import jdk.graal.compiler.nodes.spi.NodeLIRBuilderTool;
import jdk.graal.compiler.nodes.spi.ValueProxy;

@NodeInfo(cycles=NodeCycles.CYCLES_0, size=NodeSize.SIZE_0, allowedUsageTypes={InputType.Anchor, InputType.Value})
public class PublishWritesNode
extends FixedWithNextNode
implements LIRLowerable,
Canonicalizable,
ValueProxy,
GuardingNode,
AnchoringNode {
    public static final NodeClass<PublishWritesNode> TYPE = NodeClass.create(PublishWritesNode.class);
    @Node.Input
    ValueNode allocation;

    public ValueNode allocation() {
        return this.allocation;
    }

    public PublishWritesNode(ValueNode newObject) {
        super((NodeClass<? extends FixedWithNextNode>)TYPE, newObject.stamp(NodeView.DEFAULT));
        this.allocation = newObject;
    }

    @Override
    public boolean inferStamp() {
        return this.updateStamp(this.stamp.join(this.allocation.stamp(NodeView.DEFAULT)));
    }

    @Override
    public boolean verifyNode() {
        for (AddressNode address : this.allocation.usages().filter(AddressNode.class)) {
            FilteredNodeIterable<Node> readUsages = address.usages().filter(n -> {
                MemoryAccess access;
                return n instanceof MemoryAccess && (access = (MemoryAccess)((Object)n)).getLocationIdentity().isInit() && !MemoryKill.isMemoryKill(n);
            });
            this.assertTrue(readUsages.isEmpty(), "%s has unpublished reads", this.allocation);
        }
        return true;
    }

    @Node.NodeIntrinsic
    public static native Object publishWrites(Object var0);

    @Override
    public void generate(NodeLIRBuilderTool generator) {
        generator.setResult(this, generator.operand(this.allocation));
    }

    @Override
    public ValueNode getOriginalNode() {
        return this.allocation;
    }

    @Override
    public Node canonical(CanonicalizerTool tool) {
        if (!tool.allUsagesAvailable()) {
            return this;
        }
        if (this.allocation instanceof PublishWritesNode && this.predecessor() == this.allocation) {
            return this.allocation;
        }
        return this;
    }

    @Override
    public GuardingNode getGuard() {
        return this;
    }
}

