/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.nodes.extended;

import jdk.graal.compiler.core.common.type.AbstractPointerStamp;
import jdk.graal.compiler.core.common.type.Stamp;
import jdk.graal.compiler.core.common.type.StampFactory;
import jdk.graal.compiler.debug.Assertions;
import jdk.graal.compiler.graph.Node;
import jdk.graal.compiler.graph.NodeClass;
import jdk.graal.compiler.nodeinfo.InputType;
import jdk.graal.compiler.nodeinfo.NodeCycles;
import jdk.graal.compiler.nodeinfo.NodeInfo;
import jdk.graal.compiler.nodeinfo.NodeSize;
import jdk.graal.compiler.nodes.CompressionNode;
import jdk.graal.compiler.nodes.ImplicitNullCheckNode;
import jdk.graal.compiler.nodes.NodeView;
import jdk.graal.compiler.nodes.StructuredGraph;
import jdk.graal.compiler.nodes.ValueNode;
import jdk.graal.compiler.nodes.calc.UnaryNode;
import jdk.graal.compiler.nodes.extended.GuardingNode;
import jdk.graal.compiler.nodes.memory.address.OffsetAddressNode;
import jdk.graal.compiler.nodes.spi.LIRLowerable;
import jdk.graal.compiler.nodes.spi.NodeLIRBuilderTool;
import jdk.vm.ci.meta.JavaConstant;

@NodeInfo(allowedUsageTypes={InputType.Guard}, cycles=NodeCycles.CYCLES_2, size=NodeSize.SIZE_2)
public final class NullCheckNode
extends ImplicitNullCheckNode
implements LIRLowerable,
GuardingNode {
    public static final NodeClass<NullCheckNode> TYPE = NodeClass.create(NullCheckNode.class);
    @Node.Input
    ValueNode object;

    public NullCheckNode(ValueNode object) {
        this(object, null, null);
    }

    public NullCheckNode(ValueNode object, JavaConstant deoptReasonAndAction, JavaConstant deoptSpeculation) {
        super((NodeClass<? extends ImplicitNullCheckNode>)TYPE, StampFactory.forVoid());
        this.object = object;
        assert (deoptReasonAndAction == null == (deoptSpeculation == null)) : Assertions.errorMessageContext("object", object, "deoptReasonAction", deoptReasonAndAction, "deoptSpeculation", deoptSpeculation);
        this.deoptReasonAndAction = deoptReasonAndAction;
        this.deoptSpeculation = deoptSpeculation;
    }

    public static NullCheckNode create(ValueNode object, JavaConstant deoptReasonAndAction, JavaConstant deoptSpeculation) {
        NullCheckNode nullCheck = NullCheckNode.tryUseUncompressedNullCheck(object);
        if (nullCheck != null) {
            return nullCheck;
        }
        return new NullCheckNode(object, deoptReasonAndAction, deoptSpeculation);
    }

    private static NullCheckNode tryUseUncompressedNullCheck(ValueNode value) {
        Stamp stamp = value.stamp(NodeView.DEFAULT);
        if (!(stamp instanceof AbstractPointerStamp) || !((AbstractPointerStamp)stamp).isCompressed()) {
            return null;
        }
        UnaryNode uncompressed = null;
        for (Node usage : value.usages()) {
            if (!(usage instanceof CompressionNode) || ((CompressionNode)usage).getOp() != CompressionNode.CompressionOp.Uncompress) continue;
            uncompressed = (CompressionNode)usage;
            break;
        }
        if (uncompressed == null) {
            return null;
        }
        assert (uncompressed.getValue().equals(value));
        StructuredGraph graph = value.graph();
        CompressionNode compression = (CompressionNode)uncompressed.copyWithInputs(false);
        compression = graph.addOrUniqueWithInputs(compression);
        OffsetAddressNode address = graph.addOrUniqueWithInputs(OffsetAddressNode.create(compression));
        return new NullCheckNode(address);
    }

    @Override
    public void generate(NodeLIRBuilderTool generator) {
        generator.getLIRGeneratorTool().emitNullCheck(generator.operand(this.object), generator.state(this));
    }

    @Override
    public boolean canDeoptimize() {
        return true;
    }

    @Node.NodeIntrinsic
    public static native void nullCheck(Object var0);
}

