/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.nodes.extended;

import java.util.ArrayList;
import jdk.graal.compiler.core.common.type.StampFactory;
import jdk.graal.compiler.graph.Node;
import jdk.graal.compiler.graph.NodeBitMap;
import jdk.graal.compiler.graph.NodeClass;
import jdk.graal.compiler.graph.NodeInputList;
import jdk.graal.compiler.nodeinfo.InputType;
import jdk.graal.compiler.nodeinfo.NodeCycles;
import jdk.graal.compiler.nodeinfo.NodeInfo;
import jdk.graal.compiler.nodeinfo.NodeSize;
import jdk.graal.compiler.nodes.StructuredGraph;
import jdk.graal.compiler.nodes.ValueNode;
import jdk.graal.compiler.nodes.calc.FloatingNode;
import jdk.graal.compiler.nodes.extended.GuardingNode;
import jdk.graal.compiler.nodes.extended.ValueAnchorNode;
import jdk.graal.compiler.nodes.spi.Canonicalizable;
import jdk.graal.compiler.nodes.spi.CanonicalizerTool;
import jdk.graal.compiler.nodes.spi.LIRLowerable;
import jdk.graal.compiler.nodes.spi.NodeLIRBuilderTool;
import jdk.graal.compiler.nodes.spi.Simplifiable;
import jdk.graal.compiler.nodes.spi.SimplifierTool;
import jdk.graal.compiler.nodes.util.GraphUtil;
import org.graalvm.collections.EconomicSet;

@NodeInfo(allowedUsageTypes={InputType.Guard}, cycles=NodeCycles.CYCLES_0, size=NodeSize.SIZE_0)
public final class MultiGuardNode
extends FloatingNode
implements GuardingNode,
LIRLowerable,
Simplifiable,
Canonicalizable,
Node.ValueNumberable {
    public static final NodeClass<MultiGuardNode> TYPE = NodeClass.create(MultiGuardNode.class);
    @Node.OptionalInput(value=InputType.Guard)
    NodeInputList<ValueNode> guards;

    public MultiGuardNode(ValueNode ... guards) {
        super((NodeClass<? extends FloatingNode>)TYPE, StampFactory.forVoid());
        this.guards = new NodeInputList((Node)this, (Node[])guards);
    }

    @Override
    public void generate(NodeLIRBuilderTool generator) {
    }

    @Override
    public Node canonical(CanonicalizerTool tool) {
        this.guards.trim();
        if (this.guards.size() == 0) {
            return null;
        }
        if (this.guards.size() == 1) {
            return this.guards.get(0);
        }
        if (this.guards.filter(MultiGuardNode.class).isNotEmpty()) {
            ArrayList<ValueNode> list = new ArrayList<ValueNode>();
            for (ValueNode guard : this.guards) {
                if (guard instanceof MultiGuardNode) {
                    list.addAll(((MultiGuardNode)guard).guards);
                    continue;
                }
                list.add(guard);
            }
            return new MultiGuardNode(list.toArray(ValueNode.EMPTY_ARRAY));
        }
        NodeBitMap guardsSeen = new NodeBitMap(this.graph());
        boolean duplicatesFound = false;
        for (ValueNode guard : this.guards) {
            if (guardsSeen.isMarked(guard)) {
                duplicatesFound = true;
                break;
            }
            guardsSeen.mark(guard);
        }
        if (duplicatesFound) {
            EconomicSet uniqueGuards = EconomicSet.create();
            for (ValueNode guard : this.guards) {
                uniqueGuards.add((Object)guard);
            }
            if (uniqueGuards.size() == 1) {
                return (Node)uniqueGuards.iterator().next();
            }
            return new MultiGuardNode((ValueNode[])uniqueGuards.toArray((Object[])new ValueNode[uniqueGuards.size()]));
        }
        return this;
    }

    @Override
    public void simplify(SimplifierTool tool) {
        if (this.usages().filter(node -> node instanceof ValueAnchorNode).isNotEmpty()) {
            ValueNode singleFloatingGuard = null;
            for (ValueNode guard : this.guards) {
                if (!GraphUtil.isFloatingNode(guard)) continue;
                if (singleFloatingGuard == null) {
                    singleFloatingGuard = guard;
                    continue;
                }
                if (singleFloatingGuard == guard) continue;
                return;
            }
            for (Node usage : this.usages().snapshot()) {
                if (!(usage instanceof ValueAnchorNode)) continue;
                usage.replaceFirstInput(this, singleFloatingGuard);
                tool.addToWorkList(usage);
            }
            if (this.usages().isEmpty()) {
                GraphUtil.killWithUnusedFloatingInputs(this);
            }
        }
    }

    public void addGuard(GuardingNode g) {
        this.guards.add((Object)g.asNode());
    }

    public static GuardingNode combine(GuardingNode first, GuardingNode second) {
        if (first == null) {
            return second;
        }
        if (second == null) {
            return first;
        }
        StructuredGraph graph = first.asNode().graph();
        return graph.unique(new MultiGuardNode(first.asNode(), second.asNode()));
    }

    public static GuardingNode addGuard(GuardingNode first, GuardingNode second) {
        if (first instanceof MultiGuardNode && second != null) {
            MultiGuardNode multi = (MultiGuardNode)first;
            multi.addGuard(second);
            return multi;
        }
        return MultiGuardNode.combine(first, second);
    }
}

