/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.nodes.extended;

import jdk.graal.compiler.core.common.type.AbstractPointerStamp;
import jdk.graal.compiler.core.common.type.Stamp;
import jdk.graal.compiler.graph.Node;
import jdk.graal.compiler.graph.NodeClass;
import jdk.graal.compiler.nodeinfo.NodeCycles;
import jdk.graal.compiler.nodeinfo.NodeInfo;
import jdk.graal.compiler.nodeinfo.NodeSize;
import jdk.graal.compiler.nodes.ConstantNode;
import jdk.graal.compiler.nodes.FixedWithNextNode;
import jdk.graal.compiler.nodes.ValueNode;
import jdk.graal.compiler.nodes.spi.Canonicalizable;
import jdk.graal.compiler.nodes.spi.CanonicalizerTool;
import jdk.graal.compiler.nodes.spi.Lowerable;
import jdk.graal.compiler.nodes.spi.StampProvider;
import jdk.vm.ci.meta.ConstantReflectionProvider;
import jdk.vm.ci.meta.MetaAccessProvider;
import jdk.vm.ci.meta.ResolvedJavaType;

@NodeInfo(cycles=NodeCycles.CYCLES_2, size=NodeSize.SIZE_1)
public final class LoadArrayComponentHubNode
extends FixedWithNextNode
implements Lowerable,
Canonicalizable.Unary<ValueNode> {
    public static final NodeClass<LoadArrayComponentHubNode> TYPE = NodeClass.create(LoadArrayComponentHubNode.class);
    @Node.Input
    private ValueNode value;

    public static ValueNode create(ValueNode value, StampProvider stampProvider, MetaAccessProvider metaAccess, ConstantReflectionProvider constantReflection) {
        AbstractPointerStamp stamp = stampProvider.createHubStamp(null);
        return LoadArrayComponentHubNode.findSynonym(null, value, stamp, metaAccess, constantReflection);
    }

    protected LoadArrayComponentHubNode(Stamp stamp, ValueNode value) {
        super((NodeClass<? extends FixedWithNextNode>)TYPE, stamp);
        this.value = value;
    }

    @Override
    public ValueNode getValue() {
        return this.value;
    }

    @Override
    public Node canonical(CanonicalizerTool tool, ValueNode forValue) {
        return LoadArrayComponentHubNode.findSynonym(this, forValue, this.stamp, tool.getMetaAccess(), tool.getConstantReflection());
    }

    private static ValueNode findSynonym(LoadArrayComponentHubNode self, ValueNode forValue, Stamp stamp, MetaAccessProvider metaAccess, ConstantReflectionProvider constantReflection) {
        ResolvedJavaType type;
        if (forValue.isConstant() && (type = constantReflection.asJavaType(forValue.asConstant())) != null) {
            return ConstantNode.forConstant(stamp, constantReflection.asObjectHub(type.getComponentType()), metaAccess);
        }
        return self != null ? self : new LoadArrayComponentHubNode(stamp, forValue);
    }
}

