/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.nodes.extended;

import jdk.graal.compiler.core.common.memory.BarrierType;
import jdk.graal.compiler.core.common.memory.MemoryOrderMode;
import jdk.graal.compiler.core.common.type.AbstractObjectStamp;
import jdk.graal.compiler.core.common.type.Stamp;
import jdk.graal.compiler.core.common.type.StampFactory;
import jdk.graal.compiler.graph.Node;
import jdk.graal.compiler.graph.NodeClass;
import jdk.graal.compiler.nodeinfo.NodeCycles;
import jdk.graal.compiler.nodeinfo.NodeInfo;
import jdk.graal.compiler.nodeinfo.NodeSize;
import jdk.graal.compiler.nodes.extended.GuardingNode;
import jdk.graal.compiler.nodes.memory.FixedAccessNode;
import jdk.graal.compiler.nodes.memory.MemoryKill;
import jdk.graal.compiler.nodes.memory.OrderedMemoryAccess;
import jdk.graal.compiler.nodes.memory.ReadNode;
import jdk.graal.compiler.nodes.memory.SingleMemoryKill;
import jdk.graal.compiler.nodes.memory.address.AddressNode;
import jdk.graal.compiler.nodes.memory.address.OffsetAddressNode;
import jdk.graal.compiler.nodes.spi.Canonicalizable;
import jdk.graal.compiler.nodes.spi.CanonicalizerTool;
import jdk.graal.compiler.nodes.spi.Lowerable;
import jdk.vm.ci.meta.JavaKind;
import org.graalvm.word.LocationIdentity;

@NodeInfo(nameTemplate="JavaRead#{p#location/s}", cycles=NodeCycles.CYCLES_2, size=NodeSize.SIZE_1)
public class JavaReadNode
extends FixedAccessNode
implements Lowerable,
GuardingNode,
Canonicalizable,
OrderedMemoryAccess,
SingleMemoryKill {
    public static final NodeClass<JavaReadNode> TYPE = NodeClass.create(JavaReadNode.class);
    protected final JavaKind readKind;
    protected final boolean compressible;
    private final MemoryOrderMode memoryOrder;

    public JavaReadNode(JavaKind readKind, AddressNode address, LocationIdentity location, BarrierType barrierType, MemoryOrderMode memoryOrder, boolean compressible) {
        this(StampFactory.forKind(readKind), readKind, address, location, barrierType, memoryOrder, compressible);
    }

    public JavaReadNode(Stamp stamp, JavaKind readKind, AddressNode address, LocationIdentity location, BarrierType barrierType, MemoryOrderMode memoryOrder, boolean compressible) {
        this(TYPE, stamp, readKind, address, location, barrierType, memoryOrder, compressible);
    }

    protected JavaReadNode(NodeClass<? extends JavaReadNode> c, Stamp stamp, JavaKind readKind, AddressNode address, LocationIdentity location, BarrierType barrierType, MemoryOrderMode memoryOrder, boolean compressible) {
        super(c, address, location, stamp, barrierType);
        this.readKind = readKind;
        this.compressible = compressible;
        this.memoryOrder = memoryOrder;
        assert (barrierType == BarrierType.NONE || stamp instanceof AbstractObjectStamp) : "incorrect barrier on non-object type: " + String.valueOf(location);
    }

    @Override
    public boolean canNullCheck() {
        return true;
    }

    public JavaKind getReadKind() {
        return this.readKind;
    }

    public boolean isCompressible() {
        return this.compressible;
    }

    @Override
    public Node canonical(CanonicalizerTool tool) {
        if (this.getAddress() instanceof OffsetAddressNode) {
            OffsetAddressNode objAddress = (OffsetAddressNode)this.getAddress();
            return ReadNode.canonicalizeRead(this, tool, this.readKind, objAddress.getBase(), objAddress.getOffset(), this.getLocationIdentity());
        }
        return this;
    }

    @Override
    public LocationIdentity getKilledLocationIdentity() {
        if (this.ordersMemoryAccesses()) {
            return LocationIdentity.any();
        }
        return MemoryKill.NO_LOCATION;
    }

    @Override
    public MemoryOrderMode getMemoryOrder() {
        return this.memoryOrder;
    }
}

