/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.nodes.extended;

import jdk.graal.compiler.core.common.type.ObjectStamp;
import jdk.graal.compiler.core.common.type.Stamp;
import jdk.graal.compiler.core.common.type.TypeReference;
import jdk.graal.compiler.graph.Node;
import jdk.graal.compiler.graph.NodeClass;
import jdk.graal.compiler.nodeinfo.NodeCycles;
import jdk.graal.compiler.nodeinfo.NodeInfo;
import jdk.graal.compiler.nodeinfo.NodeSize;
import jdk.graal.compiler.nodes.ConstantNode;
import jdk.graal.compiler.nodes.NodeView;
import jdk.graal.compiler.nodes.ValueNode;
import jdk.graal.compiler.nodes.calc.FloatingNode;
import jdk.graal.compiler.nodes.spi.Canonicalizable;
import jdk.graal.compiler.nodes.spi.CanonicalizerTool;
import jdk.graal.compiler.nodes.spi.Lowerable;
import jdk.graal.compiler.nodes.spi.Virtualizable;
import jdk.graal.compiler.nodes.spi.VirtualizerTool;
import jdk.graal.compiler.nodes.virtual.VirtualObjectNode;
import jdk.vm.ci.meta.Assumptions;
import jdk.vm.ci.meta.Constant;
import jdk.vm.ci.meta.ConstantReflectionProvider;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.MetaAccessProvider;

@NodeInfo(cycles=NodeCycles.CYCLES_2, size=NodeSize.SIZE_1)
public final class GetClassNode
extends FloatingNode
implements Lowerable,
Canonicalizable,
Virtualizable {
    public static final NodeClass<GetClassNode> TYPE = NodeClass.create(GetClassNode.class);
    @Node.Input
    ValueNode object;

    public ValueNode getObject() {
        return this.object;
    }

    public GetClassNode(Stamp stamp, ValueNode object) {
        super((NodeClass<? extends FloatingNode>)TYPE, stamp);
        this.object = object;
        assert (((ObjectStamp)object.stamp(NodeView.DEFAULT)).nonNull());
    }

    public static ValueNode tryFold(Assumptions assumptions, MetaAccessProvider metaAccess, ConstantReflectionProvider constantReflection, NodeView view, ValueNode object) {
        if (metaAccess != null && object != null && object.stamp(view) instanceof ObjectStamp) {
            ObjectStamp objectStamp = (ObjectStamp)object.stamp(view);
            if (objectStamp.isExactType()) {
                return ConstantNode.forConstant(constantReflection.asJavaClass(objectStamp.type()), metaAccess);
            }
            TypeReference maybeExactType = TypeReference.createTrusted(assumptions, objectStamp.type());
            if (maybeExactType != null && maybeExactType.isExact()) {
                return ConstantNode.forConstant(constantReflection.asJavaClass(maybeExactType.getType()), metaAccess);
            }
        }
        return null;
    }

    @Override
    public ValueNode canonical(CanonicalizerTool tool) {
        NodeView view = NodeView.from(tool);
        ValueNode folded = GetClassNode.tryFold(tool.getAssumptions(), tool.getMetaAccess(), tool.getConstantReflection(), view, this.getObject());
        return folded == null ? this : folded;
    }

    @Override
    public void virtualize(VirtualizerTool tool) {
        ValueNode alias = tool.getAlias(this.getObject());
        if (alias instanceof VirtualObjectNode) {
            VirtualObjectNode virtual = (VirtualObjectNode)alias;
            JavaConstant javaClass = tool.getConstantReflection().asJavaClass(virtual.type());
            tool.replaceWithValue(ConstantNode.forConstant(this.stamp(NodeView.DEFAULT), (Constant)javaClass, tool.getMetaAccess(), this.graph()));
        }
    }
}

