/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.nodes.extended;

import jdk.graal.compiler.graph.Node;
import jdk.graal.compiler.graph.NodeClass;
import jdk.graal.compiler.nodeinfo.NodeCycles;
import jdk.graal.compiler.nodeinfo.NodeInfo;
import jdk.graal.compiler.nodeinfo.NodeSize;
import jdk.graal.compiler.nodes.LogicConstantNode;
import jdk.graal.compiler.nodes.LogicNode;
import jdk.graal.compiler.nodes.ValueNode;
import jdk.graal.compiler.nodes.extended.GetClassNode;
import jdk.graal.compiler.nodes.extended.ObjectIsArrayNode;
import jdk.graal.compiler.nodes.spi.Canonicalizable;
import jdk.graal.compiler.nodes.spi.CanonicalizerTool;
import jdk.graal.compiler.nodes.spi.Lowerable;
import jdk.vm.ci.meta.ConstantReflectionProvider;
import jdk.vm.ci.meta.ResolvedJavaType;

@NodeInfo(cycles=NodeCycles.CYCLES_4, size=NodeSize.SIZE_4)
public final class ClassIsArrayNode
extends LogicNode
implements Canonicalizable.Unary<ValueNode>,
Lowerable {
    public static final NodeClass<ClassIsArrayNode> TYPE = NodeClass.create(ClassIsArrayNode.class);
    @Node.Input
    protected ValueNode value;

    protected ClassIsArrayNode(ValueNode value) {
        super((NodeClass<? extends LogicNode>)TYPE);
        this.value = value;
    }

    public static LogicNode create(ConstantReflectionProvider constantReflection, ValueNode forValue) {
        return ClassIsArrayNode.canonicalized(null, forValue, constantReflection);
    }

    @Override
    public ValueNode getValue() {
        return this.value;
    }

    public ValueNode canonical(CanonicalizerTool tool, ValueNode forValue) {
        return ClassIsArrayNode.canonicalized(this, forValue, tool.getConstantReflection());
    }

    private static LogicNode canonicalized(ClassIsArrayNode node, ValueNode forValue, ConstantReflectionProvider constantReflection) {
        if (forValue.isConstant()) {
            ResolvedJavaType type = constantReflection.asJavaType(forValue.asConstant());
            if (type != null) {
                return LogicConstantNode.forBoolean(type.isArray());
            }
        } else if (forValue instanceof GetClassNode) {
            return ObjectIsArrayNode.create(((GetClassNode)forValue).getObject());
        }
        return node != null ? node : new ClassIsArrayNode(forValue);
    }
}

