/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.nodes.extended;

import jdk.graal.compiler.core.common.calc.CanonicalCondition;
import jdk.graal.compiler.core.common.type.IntegerStamp;
import jdk.graal.compiler.core.common.type.StampFactory;
import jdk.graal.compiler.debug.Assertions;
import jdk.graal.compiler.debug.GraalError;
import jdk.graal.compiler.graph.Node;
import jdk.graal.compiler.graph.NodeClass;
import jdk.graal.compiler.graph.iterators.NodePredicates;
import jdk.graal.compiler.nodeinfo.NodeCycles;
import jdk.graal.compiler.nodeinfo.NodeInfo;
import jdk.graal.compiler.nodeinfo.NodeSize;
import jdk.graal.compiler.nodes.ConstantNode;
import jdk.graal.compiler.nodes.FixedGuardNode;
import jdk.graal.compiler.nodes.FrameState;
import jdk.graal.compiler.nodes.IfNode;
import jdk.graal.compiler.nodes.NodeView;
import jdk.graal.compiler.nodes.ProfileData;
import jdk.graal.compiler.nodes.ReturnNode;
import jdk.graal.compiler.nodes.ShortCircuitOrNode;
import jdk.graal.compiler.nodes.ValueNode;
import jdk.graal.compiler.nodes.ValuePhiNode;
import jdk.graal.compiler.nodes.calc.ConditionalNode;
import jdk.graal.compiler.nodes.calc.FloatingNode;
import jdk.graal.compiler.nodes.calc.IntegerEqualsNode;
import jdk.graal.compiler.nodes.calc.NarrowNode;
import jdk.graal.compiler.nodes.calc.ZeroExtendNode;
import jdk.graal.compiler.nodes.spi.Canonicalizable;
import jdk.graal.compiler.nodes.spi.CanonicalizerTool;
import jdk.graal.compiler.nodes.spi.Lowerable;
import jdk.graal.compiler.nodes.spi.LoweringTool;
import jdk.graal.compiler.nodes.spi.Simplifiable;
import jdk.graal.compiler.nodes.spi.SimplifierTool;
import jdk.graal.compiler.nodes.util.GraphUtil;
import jdk.vm.ci.meta.JavaKind;

@NodeInfo(cycles=NodeCycles.CYCLES_0, cyclesRationale="Artificial Node", size=NodeSize.SIZE_0)
public final class BranchProbabilityNode
extends FloatingNode
implements Simplifiable,
Lowerable,
Canonicalizable {
    public static final NodeClass<BranchProbabilityNode> TYPE = NodeClass.create(BranchProbabilityNode.class);
    public static final double LIKELY_PROBABILITY = 0.6;
    public static final double NOT_LIKELY_PROBABILITY = 0.4;
    public static final ProfileData.BranchProbabilityData LIKELY_PROFILE = ProfileData.BranchProbabilityData.injected(0.6);
    public static final ProfileData.BranchProbabilityData NOT_LIKELY_PROFILE = ProfileData.BranchProbabilityData.injected(0.4);
    public static final double FREQUENT_PROBABILITY = 0.9;
    public static final double NOT_FREQUENT_PROBABILITY = 0.09999999999999998;
    public static final ProfileData.BranchProbabilityData FREQUENT_PROFILE = ProfileData.BranchProbabilityData.injected(0.9);
    public static final ProfileData.BranchProbabilityData NOT_FREQUENT_PROFILE = ProfileData.BranchProbabilityData.injected(0.09999999999999998);
    public static final double FAST_PATH_PROBABILITY = 0.99;
    public static final double SLOW_PATH_PROBABILITY = 0.010000000000000009;
    public static final ProfileData.BranchProbabilityData FAST_PATH_PROFILE = ProfileData.BranchProbabilityData.injected(0.99);
    public static final ProfileData.BranchProbabilityData SLOW_PATH_PROFILE = ProfileData.BranchProbabilityData.injected(0.010000000000000009);
    public static final double VERY_FAST_PATH_PROBABILITY = 0.999;
    public static final double VERY_SLOW_PATH_PROBABILITY = 0.0010000000000000009;
    public static final ProfileData.BranchProbabilityData VERY_FAST_PATH_PROFILE = ProfileData.BranchProbabilityData.injected(0.999);
    public static final ProfileData.BranchProbabilityData VERY_SLOW_PATH_PROFILE = ProfileData.BranchProbabilityData.injected(0.0010000000000000009);
    public static final double EXTREMELY_FAST_PATH_PROBABILITY = 0.999999;
    public static final double EXTREMELY_SLOW_PATH_PROBABILITY = 1.0000000000287557E-6;
    public static final ProfileData.BranchProbabilityData EXTREMELY_FAST_PATH_PROFILE = ProfileData.BranchProbabilityData.injected(0.999999);
    public static final ProfileData.BranchProbabilityData EXTREMELY_SLOW_PATH_PROFILE = ProfileData.BranchProbabilityData.injected(1.0000000000287557E-6);
    public static final double DEOPT_PROBABILITY = 0.0;
    public static final ProfileData.BranchProbabilityData DEOPT_PROFILE = ProfileData.BranchProbabilityData.injected(0.0);
    public static final double ALWAYS_TAKEN_PROBABILITY = 1.0;
    public static final double NEVER_TAKEN_PROBABILITY = 0.0;
    public static final ProfileData.BranchProbabilityData ALWAYS_TAKEN_PROFILE = ProfileData.BranchProbabilityData.injected(1.0);
    public static final ProfileData.BranchProbabilityData NEVER_TAKEN_PROFILE = ProfileData.BranchProbabilityData.injected(0.0);
    @Node.Input
    ValueNode probability;
    @Node.Input
    ValueNode condition;

    public BranchProbabilityNode(ValueNode probability, ValueNode condition) {
        super((NodeClass<? extends FloatingNode>)TYPE, StampFactory.forKind(JavaKind.Boolean));
        this.probability = probability;
        this.condition = condition;
        GraalError.guarantee(!(condition instanceof ShortCircuitOrNode), "Branch probabilities must be injected on simple conditions, not short-circuiting && or ||: %s", (Object)condition);
    }

    public BranchProbabilityNode(ValueNode condition) {
        this(ConstantNode.forDouble(0.5), condition);
    }

    public ValueNode getProbability() {
        return this.probability;
    }

    public void setProbability(ValueNode probability) {
        this.updateUsages(this.probability, probability);
        this.probability = probability;
    }

    @Override
    public Node canonical(CanonicalizerTool tool) {
        if (this.condition.isConstant()) {
            return this.condition;
        }
        return this;
    }

    @Override
    public void simplify(SimplifierTool tool) {
        if (!this.hasUsages()) {
            return;
        }
        if (this.probability.isConstant()) {
            double probabilityValue = this.probability.asJavaConstant().asDouble();
            if (probabilityValue < 0.0) {
                throw new GraalError("A negative probability of " + probabilityValue + " is not allowed!");
            }
            if (probabilityValue > 1.0) {
                throw new GraalError("A probability of more than 1.0 (" + probabilityValue + ") is not allowed!");
            }
            if (Double.isNaN(probabilityValue)) {
                return;
            }
            boolean usageFound = false;
            for (IntegerEqualsNode node : this.usages().filter(IntegerEqualsNode.class)) {
                assert (node.condition() == CanonicalCondition.EQ) : Assertions.errorMessage(new Object[]{node, node.condition()});
                ValueNode other = node.getX();
                if (node.getX() == this) {
                    other = node.getY();
                }
                if (!other.isConstant()) continue;
                double probabilityToSet = probabilityValue;
                if (other.asJavaConstant().asInt() == 0) {
                    probabilityToSet = 1.0 - probabilityToSet;
                }
                for (IfNode ifNodeUsages : node.usages().filter(IfNode.class)) {
                    usageFound = true;
                    ifNodeUsages.setTrueSuccessorProbability(ProfileData.BranchProbabilityData.injected(probabilityToSet));
                }
                if (usageFound) continue;
                usageFound = node.usages().filter(NodePredicates.isA(FixedGuardNode.class).or(ConditionalNode.class)).isNotEmpty();
            }
            if (!usageFound) {
                usageFound = this.hasValidPhiUsage();
            }
            if (usageFound) {
                ValueNode currentCondition = this.condition;
                IntegerStamp currentStamp = (IntegerStamp)currentCondition.stamp(NodeView.DEFAULT);
                if (currentStamp.lowerBound() < 0L || 1L < currentStamp.upperBound()) {
                    ValueNode narrow = this.graph().addOrUnique(NarrowNode.create(currentCondition, 1, NodeView.DEFAULT));
                    currentCondition = this.graph().addOrUnique(ZeroExtendNode.create(narrow, 32, NodeView.DEFAULT));
                }
                this.replaceAndDelete(currentCondition);
                if (tool != null) {
                    if (currentCondition instanceof ConditionalNode && ((ConditionalNode)currentCondition).trueValue().isConstant() && ((ConditionalNode)currentCondition).falseValue().isConstant()) {
                        for (IntegerEqualsNode eq : currentCondition.usages().filter(IntegerEqualsNode.class).snapshot()) {
                            ValueNode canonical;
                            if (!eq.getY().isConstant() && !eq.getX().isConstant() || (canonical = (ValueNode)eq.canonical(tool)) == eq || canonical == null) continue;
                            tool.addToWorkList(eq.usages());
                            eq.replaceAtUsages(this.graph().addOrUnique(canonical));
                            GraphUtil.killWithUnusedFloatingInputs(eq);
                        }
                    }
                    if (currentCondition.hasUsages()) {
                        tool.addToWorkList(currentCondition.usages());
                    }
                }
            } else if (!this.isSubstitutionGraph()) {
                throw new GraalError("Wrong usage of branch probability injection " + String.valueOf(this));
            }
        }
    }

    private boolean isSubstitutionGraph() {
        return this.hasExactlyOneUsage() && this.usages().first() instanceof ReturnNode;
    }

    private boolean hasValidPhiUsage() {
        for (Node usage : this.usages()) {
            if (!(usage instanceof ValuePhiNode) || ((ValuePhiNode)usage).isLoopPhi()) continue;
            Node phi = usage;
            Node uniquePhiUsage = null;
            for (Node phiUsage : phi.usages()) {
                if (phiUsage instanceof FrameState) continue;
                if (uniquePhiUsage == null) {
                    uniquePhiUsage = phiUsage;
                    continue;
                }
                if (phiUsage == uniquePhiUsage) continue;
                uniquePhiUsage = null;
                break;
            }
            if (!(uniquePhiUsage instanceof BranchProbabilityNode)) continue;
            return true;
        }
        return false;
    }

    @Node.NodeIntrinsic
    public static native boolean probability(double var0, boolean var2);

    @Node.NodeIntrinsic
    public static native boolean unknownProbability(boolean var0);

    @Override
    public void lower(LoweringTool tool) {
        throw new GraalError("Branch probability could not be injected, because the probability value did not reduce to a constant value.");
    }
}

