/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.nodes.debug;

import jdk.graal.compiler.core.common.type.StampFactory;
import jdk.graal.compiler.debug.GraalError;
import jdk.graal.compiler.graph.Node;
import jdk.graal.compiler.graph.NodeClass;
import jdk.graal.compiler.lir.LIRInstruction;
import jdk.graal.compiler.lir.gen.LIRGeneratorTool;
import jdk.graal.compiler.nodeinfo.NodeCycles;
import jdk.graal.compiler.nodeinfo.NodeInfo;
import jdk.graal.compiler.nodeinfo.NodeSize;
import jdk.graal.compiler.nodes.ConstantNode;
import jdk.graal.compiler.nodes.FixedNode;
import jdk.graal.compiler.nodes.FixedWithNextNode;
import jdk.graal.compiler.nodes.StructuredGraph;
import jdk.graal.compiler.nodes.ValueNode;
import jdk.graal.compiler.nodes.spi.LIRLowerable;
import jdk.graal.compiler.nodes.spi.NodeLIRBuilderTool;

@NodeInfo(size=NodeSize.SIZE_IGNORED, sizeRationale="Node is a debugging node that should not be used in production.", cycles=NodeCycles.CYCLES_IGNORED, cyclesRationale="Node is a debugging node that should not be used in production.")
public class DynamicCounterNode
extends FixedWithNextNode
implements LIRLowerable {
    public static final NodeClass<DynamicCounterNode> TYPE = NodeClass.create(DynamicCounterNode.class);
    @Node.Input
    ValueNode increment;
    protected final String group;
    protected final String name;
    protected final boolean withContext;
    public static final long MIN_INCREMENT = 0L;
    public static final long MAX_INCREMENT = 10000L;

    public DynamicCounterNode(String group, String name, ValueNode increment, boolean withContext) {
        this(TYPE, group, name, increment, withContext);
    }

    public static long clampIncrement(long value) {
        return Math.min(Math.max(value, 0L), 10000L);
    }

    private boolean checkIncrement() {
        long incValue;
        if (this.increment.isJavaConstant() && ((incValue = this.increment.asJavaConstant().asLong()) < 0L || incValue > 10000L)) {
            String message = String.format("Benchmark counter %s:%s has increment out of range [%d .. %d]: %d", this.group, this.getNameWithContext(), 0L, 10000L, incValue);
            assert (false) : message;
        }
        return true;
    }

    protected DynamicCounterNode(NodeClass<? extends DynamicCounterNode> c, String group, String name, ValueNode increment, boolean withContext) {
        super((NodeClass<? extends FixedWithNextNode>)c, StampFactory.forVoid());
        this.group = group;
        this.name = name;
        this.increment = increment;
        this.withContext = withContext;
        assert (this.checkIncrement());
    }

    public String getName() {
        return this.name;
    }

    public String getGroup() {
        return this.group;
    }

    public boolean isWithContext() {
        return this.withContext;
    }

    public static void addCounterBefore(String group, String name, long increment, boolean withContext, FixedNode position) {
        StructuredGraph graph = position.graph();
        graph.addBeforeFixed(position, position.graph().add(new DynamicCounterNode(group, name, ConstantNode.forLong(increment, position.graph()), withContext)));
    }

    public static void addCounterBefore(String group, String name, ValueNode increment, boolean withContext, FixedNode position) {
        StructuredGraph graph = position.graph();
        graph.addBeforeFixed(position, position.graph().add(new DynamicCounterNode(group, name, increment, withContext)));
    }

    @Node.NodeIntrinsic
    public static native void counter(@Node.ConstantNodeParameter String var0, @Node.ConstantNodeParameter String var1, long var2, @Node.ConstantNodeParameter boolean var4);

    @Override
    public void generate(NodeLIRBuilderTool generator) {
        String nameWithContext;
        LIRGeneratorTool lirGen = generator.getLIRGeneratorTool();
        LIRInstruction counterOp = lirGen.createBenchmarkCounter(nameWithContext = this.getNameWithContext(), this.getGroup(), generator.operand(this.increment));
        if (counterOp == null) {
            throw GraalError.unimplemented("Benchmark counters not enabled or not implemented by the back end.");
        }
        lirGen.append(counterOp);
    }

    private String getNameWithContext() {
        Object nameWithContext;
        if (this.isWithContext()) {
            nameWithContext = this.getName() + " @ ";
            if (this.graph().method() != null) {
                StackTraceElement stackTraceElement = this.graph().method().asStackTraceElement(0);
                nameWithContext = stackTraceElement != null ? (String)nameWithContext + " " + stackTraceElement.toString() : (String)nameWithContext + this.graph().method().format("%h.%n");
            }
            if (this.graph().name != null) {
                nameWithContext = (String)nameWithContext + " (" + this.graph().name + ")";
            }
        } else {
            nameWithContext = this.getName();
        }
        return nameWithContext;
    }
}

