/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.nodes.cfg;

import jdk.graal.compiler.nodes.StructuredGraph;
import jdk.graal.compiler.nodes.cfg.ControlFlowGraph;

public class ControlFlowGraphBuilder {
    private final StructuredGraph structuredGraph;
    private boolean backendBlocks;
    private boolean connectBlocks;
    private boolean computeFrequency;
    private boolean computeLoops;
    private boolean computeDominators;
    private boolean computePostdominators;

    public ControlFlowGraphBuilder(StructuredGraph structuredGraph) {
        this.structuredGraph = structuredGraph;
    }

    public ControlFlowGraphBuilder backendBlocks(boolean backendBlocksParam) {
        this.backendBlocks = backendBlocksParam;
        return this;
    }

    public ControlFlowGraphBuilder connectBlocks(boolean connectBlocksParam) {
        this.connectBlocks = connectBlocksParam;
        return this;
    }

    public ControlFlowGraphBuilder computeFrequency(boolean computeFrequencyParam) {
        this.computeFrequency = computeFrequencyParam;
        return this;
    }

    public ControlFlowGraphBuilder computeLoops(boolean computeLoopsParam) {
        this.computeLoops = computeLoopsParam;
        return this;
    }

    public ControlFlowGraphBuilder computeDominators(boolean computeDominatorsParam) {
        this.computeDominators = computeDominatorsParam;
        return this;
    }

    public ControlFlowGraphBuilder computePostdominators(boolean computePostdominatorsParam) {
        this.computePostdominators = computePostdominatorsParam;
        return this;
    }

    public ControlFlowGraph build() {
        return ControlFlowGraph.compute(this.structuredGraph, this.backendBlocks, this.connectBlocks, this.computeFrequency, this.computeLoops, this.computeDominators, this.computePostdominators);
    }
}

