/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.nodes.cfg;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import jdk.graal.compiler.core.common.NumUtil;
import jdk.graal.compiler.core.common.RetryableBailoutException;
import jdk.graal.compiler.core.common.cfg.AbstractControlFlowGraph;
import jdk.graal.compiler.core.common.cfg.BasicBlock;
import jdk.graal.compiler.core.common.cfg.BasicBlockSet;
import jdk.graal.compiler.core.common.cfg.CFGLoop;
import jdk.graal.compiler.core.common.util.CompilationAlarm;
import jdk.graal.compiler.debug.Assertions;
import jdk.graal.compiler.debug.DebugCloseable;
import jdk.graal.compiler.debug.DebugContext;
import jdk.graal.compiler.debug.GraalError;
import jdk.graal.compiler.debug.MemUseTrackerKey;
import jdk.graal.compiler.debug.TTY;
import jdk.graal.compiler.graph.Node;
import jdk.graal.compiler.graph.NodeMap;
import jdk.graal.compiler.graph.iterators.NodeIterable;
import jdk.graal.compiler.nodes.AbstractBeginNode;
import jdk.graal.compiler.nodes.AbstractMergeNode;
import jdk.graal.compiler.nodes.ControlSinkNode;
import jdk.graal.compiler.nodes.ControlSplitNode;
import jdk.graal.compiler.nodes.FixedNode;
import jdk.graal.compiler.nodes.FixedWithNextNode;
import jdk.graal.compiler.nodes.GraphState;
import jdk.graal.compiler.nodes.LoopBeginNode;
import jdk.graal.compiler.nodes.LoopEndNode;
import jdk.graal.compiler.nodes.LoopExitNode;
import jdk.graal.compiler.nodes.ProfileData;
import jdk.graal.compiler.nodes.StartNode;
import jdk.graal.compiler.nodes.StructuredGraph;
import jdk.graal.compiler.nodes.cfg.CFGVerifier;
import jdk.graal.compiler.nodes.cfg.ControlFlowGraphBuilder;
import jdk.graal.compiler.nodes.cfg.HIRBlock;
import jdk.graal.compiler.nodes.cfg.HIRLoop;
import jdk.graal.compiler.nodes.cfg.ReversePostOrder;
import jdk.graal.compiler.options.OptionKey;
import jdk.graal.compiler.replacements.nodes.LateLoweredNode;
import org.graalvm.collections.EconomicMap;
import org.graalvm.collections.Equivalence;

public final class ControlFlowGraph
implements AbstractControlFlowGraph<HIRBlock> {
    public static final double MIN_RELATIVE_FREQUENCY = 3.054936363499605E-151;
    public static final double MAX_RELATIVE_FREQUENCY = 3.273390607896142E150;
    public final StructuredGraph graph;
    private BuildConfiguration buildConfig;
    private NodeMap<HIRBlock> nodeToBlock;
    private HIRBlock[] reversePostOrder;
    private List<CFGLoop<HIRBlock>> loops;
    private int maxDominatorDepth;
    private EconomicMap<LoopBeginNode, ProfileData.LoopFrequencyData> localLoopFrequencyData;
    private static final MemUseTrackerKey CFG_MEMORY = DebugContext.memUseTracker("CFGComputation");

    public EconomicMap<HIRBlock, BlockTransplantData> transplantAndRenumber(LateLoweredNode macroInvoke, ControlFlowGraph inlineeCFGBeforeInline, EconomicMap<Node, Node> inlineeToCallerMap) {
        HIRBlock toBeDeletedBlock = this.blockFor(macroInvoke);
        GraalError.guarantee(this.blockFor(macroInvoke).getBeginNode() == macroInvoke, "Macro begin must be the begin node of its own block");
        int toBeDeletedIndex = toBeDeletedBlock.getId();
        HIRBlock[] inlineCFGBeforeInlineReversePostOrder = inlineeCFGBeforeInline.reversePostOrder;
        HIRBlock[] newReversePostOrder = new HIRBlock[this.reversePostOrder.length + inlineCFGBeforeInlineReversePostOrder.length - 1];
        int oldIndex = 0;
        EconomicMap newToOldBlocks = EconomicMap.create((Equivalence)Equivalence.IDENTITY_WITH_SYSTEM_HASHCODE);
        for (int newIndex = 0; newIndex < toBeDeletedIndex; ++newIndex) {
            HIRBlock oldBlock;
            newReversePostOrder[newIndex] = oldBlock = this.reversePostOrder[oldIndex++];
            newToOldBlocks.put((Object)oldBlock, (Object)new BlockTransplantData(oldBlock, BlockTransplantOrigin.CALLER, oldBlock.getId()));
        }
        for (int i = 0; i < inlineCFGBeforeInlineReversePostOrder.length; ++i) {
            HIRBlock oldBlock = inlineCFGBeforeInlineReversePostOrder[i];
            AbstractBeginNode oldBegin = oldBlock.beginNode;
            AbstractBeginNode newBeginInCaller = (AbstractBeginNode)inlineeToCallerMap.get((Object)oldBegin);
            GraalError.guarantee(newBeginInCaller != null, "Must find a copy of the abstract begin in the caller for %s", (Object)oldBegin);
            HIRBlock.ModifiableBlock newBlockCopy = oldBlock.copyWithBegin(newBeginInCaller, this);
            newReversePostOrder[newIndex++] = newBlockCopy;
            newToOldBlocks.put((Object)newBlockCopy, (Object)new BlockTransplantData(oldBlock, BlockTransplantOrigin.CALLEE, oldBlock.getId()));
            if (macroInvoke.getAfterInlineeBasicBlockAction() == null) continue;
            macroInvoke.getAfterInlineeBasicBlockAction().accept(newBlockCopy);
        }
        ++oldIndex;
        while (oldIndex < this.reversePostOrder.length) {
            HIRBlock oldBlock = this.reversePostOrder[oldIndex];
            newReversePostOrder[newIndex++] = oldBlock;
            newToOldBlocks.put((Object)oldBlock, (Object)new BlockTransplantData(oldBlock, BlockTransplantOrigin.CALLER, oldBlock.getId()));
            ++oldIndex;
        }
        this.reversePostOrder = newReversePostOrder;
        this.nodeToBlock = new NodeMap(this.graph);
        this.renumberBlocks();
        HIRBlock.assignPredecessorsAndSuccessors(this.reversePostOrder, this);
        return newToOldBlocks;
    }

    private void renumberBlocks() {
        int newIds = 0;
        block0: for (HIRBlock block : this.reversePostOrder) {
            FixedNode next;
            block.setId(newIds++);
            FixedWithNextNode cur = block.getBeginNode();
            while (true) {
                CompilationAlarm.checkProgress(this.graph);
                assert (cur.isAlive()) : cur;
                assert (this.nodeToBlock.get(cur) == null) : Assertions.errorMessage("Previous mapping found", this.nodeToBlock.get(cur));
                this.nodeToBlock.set(cur, block);
                next = cur.next();
                assert (next != null) : cur;
                if (next instanceof AbstractBeginNode) {
                    block.endNode = cur;
                    continue block0;
                }
                if (!(next instanceof FixedWithNextNode)) break;
                cur = (FixedWithNextNode)next;
            }
            this.nodeToBlock.set(next, block);
            block.endNode = next;
        }
    }

    public void printCFGToStdout() {
        TTY.printf("Control flow graph %s%n", this);
        for (HIRBlock block : this.reversePostOrder) {
            TTY.printf("\t%s %s -> %s, dom %s  %n", block, block.getBeginNode(), block.getEndNode(), block.getDominator());
        }
    }

    public ControlFlowGraph deepCopyReversePostOrderOnly() {
        ControlFlowGraph copy = new ControlFlowGraph(this.graph);
        copy.buildConfig = new BuildConfiguration();
        copy.reversePostOrder = new HIRBlock[this.reversePostOrder.length];
        copy.nodeToBlock = new NodeMap(this.graph);
        EconomicMap old2NewBlock = EconomicMap.create();
        for (int i = 0; i < this.reversePostOrder.length; ++i) {
            HIRBlock original = this.reversePostOrder[i];
            HIRBlock copyBlock = original instanceof HIRBlock.ModifiableBlock ? new HIRBlock.ModifiableBlock(original.getBeginNode(), copy) : new HIRBlock.UnmodifiableBlock(original.getBeginNode(), copy);
            copyBlock.setId(original.getId());
            copy.reversePostOrder[i] = copyBlock;
            old2NewBlock.put((Object)original, (Object)copyBlock);
        }
        for (Node mapped : this.nodeToBlock.getKeys()) {
            copy.nodeToBlock.put(mapped, (HIRBlock)old2NewBlock.get((Object)this.nodeToBlock.get(mapped)));
        }
        return copy;
    }

    public static ControlFlowGraphBuilder newBuilder(StructuredGraph structuredGraph) {
        return new ControlFlowGraphBuilder(structuredGraph);
    }

    public static ControlFlowGraph computeForSchedule(StructuredGraph graph) {
        return ControlFlowGraph.compute(graph, true, true, true, true, true, false);
    }

    static ControlFlowGraph compute(StructuredGraph graph, boolean modifiableBlocks, boolean connectBlocks, boolean computeFrequency, boolean computeLoops, boolean computeDominators, boolean computePostdominators) {
        try (DebugCloseable c = CFG_MEMORY.start(graph.getDebug());){
            ControlFlowGraph cfg = ControlFlowGraph.lookupCached(graph, modifiableBlocks);
            if (cfg != null) {
                if (cfg.buildConfig.notWeakerThan(connectBlocks, computeFrequency, computeLoops, computeDominators, computePostdominators)) {
                    ControlFlowGraph controlFlowGraph = cfg;
                    return controlFlowGraph;
                }
            } else {
                cfg = new ControlFlowGraph(graph);
                cfg.identifyBlocks(modifiableBlocks);
            }
            BuildConfiguration buildConfig = cfg.buildConfig;
            if (CFGOptions.DumpEndVersusExitLoopFrequencies.getValue(graph.getOptions()).booleanValue()) {
                cfg.computeLoopInformation();
                cfg.computeDominators();
            }
            if (computeFrequency) {
                cfg.computeFrequencies();
            }
            if (computeLoops) {
                cfg.computeLoopInformation();
            }
            if (computeDominators) {
                cfg.computeDominators();
                assert (cfg.verifyRPOInnerLoopsFirst());
            }
            if (computePostdominators) {
                cfg.computePostdominators();
            }
            assert (!connectBlocks && !computeLoops && !computeDominators && !computePostdominators || CFGVerifier.verify(cfg));
            buildConfig.connectBlocks |= connectBlocks;
            graph.setLastCFG(cfg);
            ControlFlowGraph controlFlowGraph = cfg;
            return controlFlowGraph;
        }
    }

    private static ControlFlowGraph lookupCached(StructuredGraph graph, boolean modifiableBlocks) {
        if (graph.isLastCFGValid()) {
            ControlFlowGraph lastCFG = graph.getLastCFG();
            assert (lastCFG != null) : "A valid lastCFG must not be null";
            if (lastCFG.buildConfig.modifiableBlocks == modifiableBlocks) {
                return lastCFG;
            }
        }
        if (graph.getLastSchedule() != null && !graph.isAfterStage(GraphState.StageFlag.FINAL_SCHEDULE)) {
            graph.clearLastSchedule();
        }
        return null;
    }

    private void identifyBlocks(boolean makeModifiable) {
        int numBlocks = 0;
        for (AbstractBeginNode begin : this.graph.getNodes(AbstractBeginNode.TYPE)) {
            GraalError.guarantee(begin.predecessor() != null || begin instanceof StartNode || begin instanceof AbstractMergeNode, "Disconnected control flow %s encountered", (Object)begin);
            HIRBlock block = makeModifiable ? new HIRBlock.ModifiableBlock(begin, this) : new HIRBlock.UnmodifiableBlock(begin, this);
            this.identifyBlock(block);
            if (++numBlocks <= 0x7FFFFFFE) continue;
            throw new RetryableBailoutException("Graph too large to safely compile in reasonable time. Graph contains more than %d basic blocks", 0x7FFFFFFE);
        }
        this.reversePostOrder = ReversePostOrder.identifyBlocks(this, numBlocks);
        this.buildConfig.modifiableBlocks = makeModifiable;
    }

    @Override
    public int getNumberOfLoops() {
        return this.loops.size();
    }

    public double localLoopFrequency(LoopBeginNode lb) {
        return ((ProfileData.LoopFrequencyData)this.localLoopFrequencyData.get((Object)lb)).getLoopFrequency();
    }

    public ProfileData.ProfileSource localLoopFrequencySource(LoopBeginNode lb) {
        return ((ProfileData.LoopFrequencyData)this.localLoopFrequencyData.get((Object)lb)).getProfileSource();
    }

    public EconomicMap<LoopBeginNode, ProfileData.LoopFrequencyData> getLocalLoopFrequencyData() {
        return this.localLoopFrequencyData;
    }

    public void updateCachedLocalLoopFrequency(LoopBeginNode lb, Function<ProfileData.LoopFrequencyData, ProfileData.LoopFrequencyData> updater) {
        this.localLoopFrequencyData.put((Object)lb, (Object)updater.apply((ProfileData.LoopFrequencyData)this.localLoopFrequencyData.get((Object)lb)));
    }

    public <V> void visitDominatorTreeDefault(RecursiveVisitor<V> visitor) {
        HIRBlock[] stack = new HIRBlock[this.maxDominatorDepth + 1];
        HIRBlock current = this.getStartBlock();
        int tos = 0;
        Object[] values = null;
        int valuesTOS = 0;
        while (tos >= 0) {
            Object value;
            HIRBlock state = stack[tos];
            if (state == null || state.getDominator() == null || ((HIRBlock)state.getDominator()).getPostdominator() != state) {
                HIRBlock postDom;
                if (state == null) {
                    HIRBlock dominated;
                    value = visitor.enter(current);
                    if (value != null || values != null) {
                        if (values == null) {
                            values = new Object[this.maxDominatorDepth + 1];
                        }
                        values[valuesTOS++] = value;
                    }
                    if ((dominated = ControlFlowGraph.skipPostDom((HIRBlock)current.getFirstDominated())) != null) {
                        stack[tos] = dominated;
                        current = dominated;
                        stack[++tos] = null;
                        continue;
                    }
                } else {
                    HIRBlock next = ControlFlowGraph.skipPostDom((HIRBlock)state.getDominatedSibling());
                    if (next != null) {
                        stack[tos] = next;
                        current = next;
                        stack[++tos] = null;
                        continue;
                    }
                }
                if ((postDom = current.getPostdominator()) != null && postDom.getDominator() == current) {
                    stack[tos] = postDom;
                    current = postDom;
                    stack[++tos] = null;
                    continue;
                }
            }
            value = null;
            if (values != null && valuesTOS > 0) {
                value = values[--valuesTOS];
            }
            visitor.exit(current, value);
            current = (HIRBlock)current.getDominator();
            --tos;
        }
    }

    private static HIRBlock skipPostDom(HIRBlock block) {
        if (block != null && ((HIRBlock)block.getDominator()).getPostdominator() == block) {
            return (HIRBlock)block.getDominatedSibling();
        }
        return block;
    }

    public static void addDeferredExit(DeferredExit[] deferredExits, HIRBlock b) {
        CFGLoop<HIRBlock> outermostExited = ((HIRBlock)b.getDominator()).getLoop();
        CFGLoop<HIRBlock> exitBlockLoop = b.getLoop();
        assert (outermostExited != null) : "Dominator must be in a loop. Possible cause is a missing loop exit node.";
        while (outermostExited.getParent() != null && outermostExited.getParent() != exitBlockLoop) {
            outermostExited = outermostExited.getParent();
        }
        int loopIndex = outermostExited.getIndex();
        deferredExits[loopIndex] = new DeferredExit(b, deferredExits[loopIndex]);
    }

    public <V> void visitDominatorTreeDeferLoopExits(RecursiveVisitor<V> visitor) {
        HIRBlock[] stack = new HIRBlock[this.getBlocks().length];
        int tos = 0;
        BasicBlockSet visited = this.createBasicBlockSet();
        int loopCount = this.getLoops().size();
        DeferredExit[] deferredExits = new DeferredExit[loopCount];
        Object[] values = null;
        int valuesTOS = 0;
        stack[0] = this.getStartBlock();
        ArrayList<HIRBlock> dominated = new ArrayList<HIRBlock>(3);
        while (tos >= 0) {
            HIRBlock b;
            HIRBlock alwaysReached;
            Object value;
            HIRBlock cur = stack[tos];
            if (visited.get(cur)) {
                int loopIndex;
                DeferredExit deferredExit;
                value = null;
                if (values != null && valuesTOS > 0) {
                    value = values[--valuesTOS];
                }
                visitor.exit(cur, value);
                --tos;
                if (!cur.isLoopHeader() || (deferredExit = deferredExits[loopIndex = cur.getLoop().getIndex()]) == null) continue;
                while (deferredExit != null) {
                    stack[++tos] = deferredExit.block;
                    deferredExit = deferredExit.next;
                }
                deferredExits[loopIndex] = null;
                continue;
            }
            visited.set(cur);
            value = visitor.enter(cur);
            if (value != null || values != null) {
                if (values == null) {
                    values = new Object[this.maxDominatorDepth + 1];
                }
                values[valuesTOS++] = value;
            }
            if ((alwaysReached = cur.getPostdominator()) != null) {
                if (alwaysReached.getDominator() != cur) {
                    alwaysReached = null;
                } else if (ControlFlowGraph.isDominatorTreeLoopExit(alwaysReached)) {
                    ControlFlowGraph.addDeferredExit(deferredExits, alwaysReached);
                } else {
                    stack[++tos] = alwaysReached;
                }
            }
            dominated.clear();
            for (b = (HIRBlock)cur.getFirstDominated(); b != null; b = (HIRBlock)b.getDominatedSibling()) {
                dominated.add(b);
            }
            while (!dominated.isEmpty()) {
                b = (HIRBlock)dominated.removeLast();
                if (b == alwaysReached) continue;
                if (ControlFlowGraph.isDominatorTreeLoopExit(b)) {
                    ControlFlowGraph.addDeferredExit(deferredExits, b);
                    continue;
                }
                stack[++tos] = b;
            }
        }
    }

    public <V> void visitDominatorTree(RecursiveVisitor<V> visitor, boolean deferLoopExits) {
        if (deferLoopExits && this.getLoops().size() > 0) {
            this.visitDominatorTreeDeferLoopExits(visitor);
        } else {
            this.visitDominatorTreeDefault(visitor);
        }
    }

    public static boolean isDominatorTreeLoopExit(HIRBlock b) {
        return ControlFlowGraph.isDominatorTreeLoopExit(b, false);
    }

    public static boolean isDominatorTreeLoopExit(HIRBlock b, boolean considerRealExits) {
        HIRBlock dominator = (HIRBlock)b.getDominator();
        if (!(dominator == null || b.getLoop() == dominator.getLoop() || b.isLoopHeader() && dominator.getLoopDepth() < b.getLoopDepth())) {
            return true;
        }
        return considerRealExits && b.getBeginNode() instanceof LoopExitNode;
    }

    private ControlFlowGraph(StructuredGraph graph) {
        this.graph = graph;
        this.nodeToBlock = graph.createNodeMap();
        this.buildConfig = new BuildConfiguration();
    }

    private boolean verifyRPOInnerLoopsFirst() {
        return this.rpoInnerLoopsFirst(b -> {}, b -> {});
    }

    private boolean rpoInnerLoopsFirst(Consumer<HIRBlock> perBasicBlockOption, Consumer<LoopBeginNode> loopClosedAction) {
        RPOLoopVerification[] openLoops = new RPOLoopVerification[this.graph.getNodes(LoopBeginNode.TYPE).count()];
        int tos = 0;
        for (HIRBlock b : this.reversePostOrder) {
            if (b.isLoopHeader()) {
                RPOLoopVerification lv = new RPOLoopVerification((LoopBeginNode)b.getBeginNode());
                openLoops[tos++] = lv;
            }
            perBasicBlockOption.accept(b);
            boolean wasExit = ControlFlowGraph.predecessorBlockSequentialLoopExit(b);
            FixedNode f = b.getBeginNode();
            while (true) {
                CompilationAlarm.checkProgress(this.graph);
                if (f instanceof LoopExitNode) {
                    LoopBeginNode closedLoop = ((LoopExitNode)f).loopBegin();
                    RPOLoopVerification lv = openLoops[tos - 1];
                    assert (lv.lb == closedLoop) : "Must close inner loops first before closing other ones stackLoop=" + String.valueOf(lv.lb) + " exited loop=" + String.valueOf(closedLoop) + " block=" + String.valueOf(b);
                    if (!lv.allEndsVisited()) {
                        throw GraalError.shouldNotReachHere("Loop ends should be visited before exits. This is a major error in the reverse post order of the control flow graph of this method. This typically means wrongly specified control-split nodes have been processed in ReversePostOrder.java.");
                    }
                    ++lv.exitsVisited;
                    if (lv.loopFullyProcessed()) {
                        loopClosedAction.accept(lv.lb);
                        --tos;
                    }
                    wasExit = true;
                }
                if (f == b.getEndNode()) break;
                f = ((FixedWithNextNode)f).next();
            }
            if (!b.isLoopEnd()) continue;
            RPOLoopVerification lv = null;
            LoopEndNode len = (LoopEndNode)b.getEndNode();
            int index = tos - 1;
            if (wasExit) {
                while (openLoops[index].lb != len.loopBegin()) {
                    --index;
                }
                lv = openLoops[index];
            } else {
                lv = openLoops[tos - 1];
            }
            LoopBeginNode closedLoop = ((LoopEndNode)b.getEndNode()).loopBegin();
            assert (lv.lb == closedLoop) : "Must close inner loops first before closing other ones stackLoop=" + String.valueOf(lv.lb) + " ended loop=" + String.valueOf(closedLoop) + " block=" + String.valueOf(b) + "->" + String.valueOf(b.getBeginNode());
            ++lv.endsVisited;
            if (!lv.loopFullyProcessed()) continue;
            loopClosedAction.accept(lv.lb);
            if (lv.lb != openLoops[tos - 1].lb) {
                RPOLoopVerification[] tmp = new RPOLoopVerification[openLoops.length];
                System.arraycopy(openLoops, 0, tmp, 0, index);
                System.arraycopy(openLoops, index + 1, tmp, index, openLoops.length - (index + 1));
                openLoops = tmp;
            }
            --tos;
        }
        assert (tos == 0) : "Unfinished loops on stack " + tos;
        return true;
    }

    private static boolean predecessorBlockSequentialLoopExit(HIRBlock b) {
        HIRBlock cur = b;
        while (cur.getPredecessorCount() == 1 && ((HIRBlock)cur.getPredecessorAt(0)).getSuccessorCount() == 1) {
            HIRBlock pred = (HIRBlock)cur.getPredecessorAt(0);
            FixedNode f = pred.getBeginNode();
            while (true) {
                CompilationAlarm.checkProgress(b.getCfg().graph);
                if (f instanceof LoopExitNode) {
                    return true;
                }
                if (f == pred.getEndNode()) break;
                f = ((FixedWithNextNode)f).next();
            }
            cur = (HIRBlock)cur.getPredecessorAt(0);
        }
        return false;
    }

    public void computeDominators() {
        if (this.buildConfig.dominatorsComputed) {
            return;
        }
        this.buildConfig.dominatorsComputed = true;
        assert (this.reversePostOrder[0].getPredecessorCount() == 0) : "start block has no predecessor and therefore no dominator";
        HIRBlock[] blocks = this.reversePostOrder;
        int curMaxDominatorDepth = 0;
        for (int i = 1; i < blocks.length; ++i) {
            HIRBlock block = blocks[i];
            assert (NumUtil.assertPositiveInt(block.getPredecessorCount()));
            BasicBlock dominator = null;
            for (int j = 0; j < block.getPredecessorCount(); ++j) {
                HIRBlock pred = (HIRBlock)block.getPredecessorAt(j);
                if (pred.isLoopEnd()) continue;
                dominator = dominator == null ? pred : ControlFlowGraph.commonDominatorRaw((HIRBlock)dominator, pred);
            }
            assert (dominator != null);
            block.setDominator(dominator);
            HIRBlock currentDominated = (HIRBlock)dominator.getFirstDominated();
            if (currentDominated != null && currentDominated.getId() < block.getId()) {
                while (currentDominated.getDominatedSibling() != null && ((HIRBlock)currentDominated.getDominatedSibling()).getId() < block.getId()) {
                    currentDominated = (HIRBlock)currentDominated.getDominatedSibling();
                }
                block.setDominatedSibling((HIRBlock)currentDominated.getDominatedSibling());
                currentDominated.setDominatedSibling(block);
            } else {
                block.setDominatedSibling((HIRBlock)dominator.getFirstDominated());
                dominator.setFirstDominated(block);
            }
            curMaxDominatorDepth = Math.max(curMaxDominatorDepth, block.getDominatorDepth());
        }
        this.maxDominatorDepth = curMaxDominatorDepth;
        ControlFlowGraph.calcDominatorRanges(this.getStartBlock(), this.reversePostOrder.length);
    }

    private static void calcDominatorRanges(HIRBlock block, int size) {
        HIRBlock[] stack = new HIRBlock[size];
        stack[0] = block;
        int tos = 0;
        int myNumber = 0;
        do {
            HIRBlock cur = stack[tos];
            HIRBlock dominated = (HIRBlock)cur.getFirstDominated();
            if (cur.getDominatorNumber() == -1) {
                cur.setDominatorNumber(myNumber);
                if (dominated != null) {
                    do {
                        stack[++tos] = dominated;
                    } while ((dominated = (HIRBlock)dominated.getDominatedSibling()) != null);
                } else {
                    cur.setMaxChildDomNumber(myNumber);
                    --tos;
                }
                ++myNumber;
                continue;
            }
            cur.setMaxChildDomNumber(dominated.getMaxChildDominatorNumber());
            --tos;
        } while (tos >= 0);
    }

    private static HIRBlock commonDominatorRaw(HIRBlock a, HIRBlock b) {
        int bDomDepth;
        int aDomDepth = a.getDominatorDepth();
        if (aDomDepth > (bDomDepth = b.getDominatorDepth())) {
            return ControlFlowGraph.commonDominatorRawSameDepth(a.getDominator(aDomDepth - bDomDepth), b);
        }
        return ControlFlowGraph.commonDominatorRawSameDepth(a, b.getDominator(bDomDepth - aDomDepth));
    }

    private static HIRBlock commonDominatorRawSameDepth(HIRBlock a, HIRBlock b) {
        HIRBlock iterA = a;
        for (HIRBlock iterB = b; iterA != iterB; iterA = (HIRBlock)iterA.getDominator(), iterB = (HIRBlock)iterB.getDominator()) {
        }
        return iterA;
    }

    public HIRBlock[] getBlocks() {
        return this.reversePostOrder;
    }

    @Override
    public HIRBlock getStartBlock() {
        return this.reversePostOrder[0];
    }

    public HIRBlock[] reversePostOrder() {
        return this.reversePostOrder;
    }

    public NodeMap<HIRBlock> getNodeToBlock() {
        return this.nodeToBlock;
    }

    public HIRBlock blockFor(Node node) {
        return this.nodeToBlock.get(node);
    }

    public HIRBlock commonDominatorFor(NodeIterable<? extends Node> nodes) {
        HIRBlock commonDom = null;
        for (Node node : nodes) {
            HIRBlock b = this.blockFor(node);
            commonDom = (HIRBlock)AbstractControlFlowGraph.commonDominator(commonDom, b);
        }
        return commonDom;
    }

    public List<CFGLoop<HIRBlock>> getLoops() {
        return this.loops;
    }

    public int getMaxDominatorDepth() {
        return this.maxDominatorDepth;
    }

    private void identifyBlock(HIRBlock block) {
        FixedNode next;
        FixedWithNextNode cur = block.getBeginNode();
        while (true) {
            CompilationAlarm.checkProgress(this.graph);
            assert (cur.isAlive()) : cur;
            assert (this.nodeToBlock.get(cur) == null);
            this.nodeToBlock.set(cur, block);
            next = cur.next();
            assert (next != null) : cur;
            if (next instanceof AbstractBeginNode) {
                block.endNode = cur;
                return;
            }
            if (!(next instanceof FixedWithNextNode)) break;
            cur = (FixedWithNextNode)next;
        }
        this.nodeToBlock.set(next, block);
        block.endNode = next;
    }

    private void finishLocalLoopFrequency(LoopBeginNode lb) {
        this.calculateLocalLoopFrequency(lb);
        double sumAllLexFrequency = 0.0;
        for (LoopExitNode lex : lb.loopExits()) {
            sumAllLexFrequency += this.blockFor((Node)lex).relativeFrequency;
        }
        for (LoopExitNode lex : lb.loopExits()) {
            HIRBlock lexBlock = this.blockFor(lex);
            assert (lexBlock != null);
            double lexFrequency = lexBlock.getRelativeFrequency();
            double scaleLexFrequency = lexFrequency / sumAllLexFrequency;
            double loopPredFrequency = this.blockFor((Node)lb.forwardEnd()).relativeFrequency;
            double exitFrequency = ControlFlowGraph.multiplyRelativeFrequencies(scaleLexFrequency, loopPredFrequency);
            lexBlock.setRelativeFrequency(exitFrequency);
            GraalError.guarantee(this.blockFor((Node)lex).relativeFrequency <= loopPredFrequency, "Lex frequency %f must be below pred frequency %f", (Object)loopPredFrequency, (Object)exitFrequency);
        }
    }

    private void computeLocalLoopFrequencies() {
        this.rpoInnerLoopsFirst(b -> this.perBasicBlockFrequencyAction((HIRBlock)b, true), lb -> this.finishLocalLoopFrequency((LoopBeginNode)lb));
    }

    private double calculateLocalLoopFrequency(LoopBeginNode lb) {
        HIRBlock header = this.blockFor(lb);
        assert (header != null);
        double loopFrequency = -1.0;
        ProfileData.ProfileSource source = ProfileData.ProfileSource.UNKNOWN;
        if (CFGOptions.UseLoopEndFrequencies.getValue(lb.graph().getOptions()).booleanValue()) {
            double loopEndFrequency = 0.0;
            for (LoopEndNode len : lb.loopEnds()) {
                HIRBlock endBlock = this.blockFor(len);
                assert (endBlock != null);
                assert (endBlock.relativeFrequency >= 0.0) : Assertions.errorMessageContext("endblock", endBlock, "endblock.rf", endBlock.relativeFrequency);
                loopEndFrequency += endBlock.relativeFrequency;
                source = source.combine(endBlock.frequencySource);
            }
            loopEndFrequency = Math.min(1.0, loopEndFrequency);
            if ((loopEndFrequency = Math.max(3.054936363499605E-151, loopEndFrequency)) == 1.0) {
                loopFrequency = 3.273390607896142E150;
            } else {
                double exitFrequency = 1.0 - loopEndFrequency;
                loopFrequency = 1.0 / exitFrequency;
                assert (Double.isFinite(loopFrequency)) : "Loop=" + String.valueOf(lb) + " Loop Frequency=" + loopFrequency + " endFrequency=" + loopEndFrequency;
                assert (!Double.isNaN(loopFrequency)) : "Loop=" + String.valueOf(lb) + " Loop Frequency=" + loopFrequency + " endFrequency=" + loopEndFrequency;
            }
        } else {
            double loopExitFrequencySum = 0.0;
            for (LoopExitNode lex : lb.loopExits()) {
                HIRBlock lexBlock = this.blockFor(lex);
                assert (lexBlock != null);
                assert (lexBlock.relativeFrequency >= 0.0) : Assertions.errorMessageContext("lexBlock", lexBlock);
                loopExitFrequencySum += lexBlock.relativeFrequency;
                source = source.combine(lexBlock.frequencySource);
            }
            loopExitFrequencySum = Math.min(1.0, loopExitFrequencySum);
            loopExitFrequencySum = Math.max(3.054936363499605E-151, loopExitFrequencySum);
            loopFrequency = 1.0 / loopExitFrequencySum;
            assert (Double.isFinite(loopFrequency)) : "Loop=" + String.valueOf(lb) + " Loop Frequency=" + loopFrequency + " lexFrequencySum=" + loopExitFrequencySum;
            assert (!Double.isNaN(loopFrequency)) : "Loop=" + String.valueOf(lb) + " Loop Frequency=" + loopFrequency + " lexFrequencySum=" + loopExitFrequencySum;
            if (CFGOptions.DumpEndVersusExitLoopFrequencies.getValue(lb.getOptions()).booleanValue()) {
                this.debugLocalLoopFrequencies(lb, loopFrequency, loopExitFrequencySum);
            }
        }
        this.localLoopFrequencyData.put((Object)lb, (Object)ProfileData.LoopFrequencyData.create(loopFrequency, source));
        return loopFrequency;
    }

    private void debugLocalLoopFrequencies(LoopBeginNode lb, double loopFrequency, double loopExitFrequencySum) {
        try (DebugContext.Scope s = lb.getDebug().scope("CFGFrequencyInfo");){
            boolean hasLoopExits;
            boolean sinkingImplicitExitsFullyVisited = true;
            double loopSinkFrequencySum = 0.0;
            for (HIRBlock loopBlock : this.blockFor(lb).getLoop().getBlocks()) {
                FixedNode blockEndNode = loopBlock.getEndNode();
                if (blockEndNode instanceof ControlSinkNode) {
                    double sinkBlockFrequency = this.blockFor((Node)blockEndNode).relativeFrequency;
                    loopSinkFrequencySum += sinkBlockFrequency;
                }
                if (this.blockFor((Node)blockEndNode).relativeFrequency != -1.0) continue;
                sinkingImplicitExitsFullyVisited = false;
            }
            double delta = 0.01;
            if (sinkingImplicitExitsFullyVisited) {
                block6: for (HIRBlock loopBlock : this.blockFor(lb).getLoop().getBlocks()) {
                    if (loopBlock.isLoopHeader() || ControlFlowGraph.isDominatorTreeLoopExit(loopBlock, true)) continue;
                    for (int i = 0; i < loopBlock.getSuccessorCount(); ++i) {
                        HIRBlock succ = (HIRBlock)loopBlock.getSuccessorAt(i);
                        if (ControlFlowGraph.isDominatorTreeLoopExit(succ, true) || succ.isLoopHeader()) continue block6;
                    }
                    double selfFrequency = loopBlock.relativeFrequency;
                    double succFrequency = 0.0;
                    for (int i = 0; i < loopBlock.getSuccessorCount(); ++i) {
                        HIRBlock succ = (HIRBlock)loopBlock.getSuccessorAt(i);
                        succFrequency += succ.relativeFrequency;
                    }
                    if (loopBlock.getSuccessorCount() == 0) {
                        GraalError.guarantee(loopBlock.getEndNode() instanceof ControlSinkNode, "Must sink if there is no successor");
                        continue;
                    }
                    if (!(succFrequency < selfFrequency - 0.01)) continue;
                    String format = "Successors must add up for block %s with begin %s, selfF=%f succF=%f";
                    this.graph.getDebug().dump(3, this.graph, format, loopBlock, loopBlock.getBeginNode(), selfFrequency, succFrequency);
                    throw GraalError.shouldNotReachHere(String.format(format, loopBlock, loopBlock.getBeginNode(), selfFrequency, succFrequency));
                }
            }
            double loopEndFrequencySum = 0.0;
            for (LoopEndNode len : lb.loopEnds()) {
                HIRBlock lenBlock = this.blockFor(len);
                loopEndFrequencySum += lenBlock.relativeFrequency;
            }
            double endBasedFrequency = 1.0 / (1.0 - loopEndFrequencySum);
            if (loopEndFrequencySum == 1.0) {
                endBasedFrequency = 3.273390607896142E150;
            }
            for (HIRBlock loopBlock : this.blockFor(lb).getLoop().getBlocks()) {
                if (!loopBlock.isLoopHeader() || loopBlock.getBeginNode() == lb) continue;
                LoopBeginNode otherLoop = (LoopBeginNode)loopBlock.getBeginNode();
                double otherLoopExitFrequencySum = 0.0;
                for (LoopExitNode lex : otherLoop.loopExits()) {
                    otherLoopExitFrequencySum += this.blockFor((Node)lex).relativeFrequency;
                }
                double predFrequency = loopBlock.getFirstPredecessor().relativeFrequency;
                double frequencyDifference = Math.abs(predFrequency - otherLoopExitFrequencySum);
                if (!(frequencyDifference > 0.01)) continue;
                this.graph.getDebug().dump(3, this.graph, "Frequencies diverge too much");
                throw GraalError.shouldNotReachHere("Frequencies diverge too much");
            }
            boolean bl = hasLoopExits = lb.loopExits().count() > 0;
            if (Math.abs(endBasedFrequency - loopFrequency) > CFGOptions.LoopExitVsLoopEndFrequencyDiff.getValue(lb.getOptions()) && hasLoopExits) {
                this.graph.getDebug().dump(3, this.graph, "Frequency divergence for loop %s,exitBasedFrequency=%.4f endBasedFrequency=%.4f, exitFSum=%.2f / endFSum=%.2f/ sinkSum=%.2f [allSum=%f]", lb, loopFrequency, endBasedFrequency, loopExitFrequencySum, loopEndFrequencySum, loopSinkFrequencySum, loopExitFrequencySum + loopEndFrequencySum + loopSinkFrequencySum);
            }
        }
    }

    private void resetBlockFrequencies() {
        for (HIRBlock block : this.reversePostOrder) {
            block.setRelativeFrequency(0.0);
        }
    }

    private void computeFrequenciesFromLocal() {
        for (HIRBlock block : this.reversePostOrder) {
            this.perBasicBlockFrequencyAction(block, false);
        }
    }

    private void perBasicBlockFrequencyAction(HIRBlock b, boolean computingLocalLoopFrequencies) {
        double relativeFrequency = -1.0;
        ProfileData.ProfileSource source = ProfileData.ProfileSource.UNKNOWN;
        if (b.getPredecessorCount() == 0) {
            relativeFrequency = 1.0;
        } else if (b.getPredecessorCount() == 1) {
            HIRBlock pred = (HIRBlock)b.getPredecessorAt(0);
            relativeFrequency = pred.relativeFrequency;
            if (pred.getSuccessorCount() > 1) {
                assert (pred.getEndNode() instanceof ControlSplitNode) : Assertions.errorMessage(pred, pred.getEndNode());
                ControlSplitNode controlSplit = (ControlSplitNode)pred.getEndNode();
                relativeFrequency = ControlFlowGraph.multiplyRelativeFrequencies(relativeFrequency, controlSplit.probability(b.getBeginNode()));
                if (computingLocalLoopFrequencies) {
                    source = controlSplit.getProfileData().getProfileSource();
                }
            }
        } else {
            relativeFrequency = ((HIRBlock)b.getPredecessorAt((int)0)).relativeFrequency;
            for (int i = 1; i < b.getPredecessorCount(); ++i) {
                HIRBlock pred = (HIRBlock)b.getPredecessorAt(i);
                relativeFrequency += pred.relativeFrequency;
                if (!computingLocalLoopFrequencies || pred.frequencySource == null) continue;
                source = source.combine(pred.frequencySource);
            }
            if (b.getBeginNode() instanceof LoopBeginNode) {
                if (computingLocalLoopFrequencies) {
                    relativeFrequency = 1.0;
                    source = ProfileData.ProfileSource.UNKNOWN;
                } else {
                    LoopBeginNode loopBegin = (LoopBeginNode)b.getBeginNode();
                    relativeFrequency = ControlFlowGraph.multiplyRelativeFrequencies(relativeFrequency, ((ProfileData.LoopFrequencyData)this.localLoopFrequencyData.get((Object)loopBegin)).getLoopFrequency());
                }
            }
        }
        if (relativeFrequency < 3.054936363499605E-151) {
            relativeFrequency = 3.054936363499605E-151;
        } else if (relativeFrequency > 3.273390607896142E150) {
            relativeFrequency = 3.273390607896142E150;
        }
        b.setRelativeFrequency(relativeFrequency);
        if (computingLocalLoopFrequencies) {
            b.setFrequencySource(source);
        }
    }

    public void computeFrequencies() {
        if (this.buildConfig.frequenciesComputed) {
            return;
        }
        this.buildConfig.frequenciesComputed = true;
        this.localLoopFrequencyData = EconomicMap.create();
        this.computeLocalLoopFrequencies();
        this.resetBlockFrequencies();
        this.computeFrequenciesFromLocal();
        if (Assertions.assertionsEnabled()) {
            for (HIRBlock block : this.reversePostOrder) {
                assert (block.getRelativeFrequency() >= 0.0) : "Must have a relative frequency set, block " + String.valueOf(block);
            }
        }
    }

    public void computeLoopInformation() {
        if (this.buildConfig.loopsComputed) {
            return;
        }
        this.buildConfig.loopsComputed = true;
        this.loops = new ArrayList<CFGLoop<HIRBlock>>(this.graph.getNodes(LoopBeginNode.TYPE).count());
        if (this.graph.hasLoops()) {
            HIRBlock[] stack = new HIRBlock[this.reversePostOrder.length];
            for (HIRBlock block : this.reversePostOrder) {
                AbstractBeginNode beginNode = block.getBeginNode();
                if (!(beginNode instanceof LoopBeginNode)) continue;
                CFGLoop<HIRBlock> parent = block.getLoop();
                HIRLoop loop = new HIRLoop(parent, this.loops.size(), block);
                if (parent != null) {
                    parent.getChildren().add(loop);
                }
                this.loops.add(loop);
                block.setLoop(loop);
                loop.getBlocks().add(block);
                LoopBeginNode loopBegin = (LoopBeginNode)beginNode;
                for (LoopEndNode end : loopBegin.loopEnds()) {
                    HIRBlock endBlock = this.nodeToBlock.get(end);
                    ControlFlowGraph.computeLoopBlocks(endBlock, loop, stack, true);
                }
                for (HIRBlock b : loop.getBlocks()) {
                    for (int i = 0; i < b.getSuccessorCount(); ++i) {
                        HIRBlock sux = (HIRBlock)b.getSuccessorAt(i);
                        if (sux.getLoop() == loop) continue;
                        assert (sux.getLoopDepth() < loop.getDepth()) : Assertions.errorMessageContext("sux", sux, "sux.loopDepth", sux.getLoopDepth(), "loop", loop, "loop.loopDepth", loop.getDepth());
                        loop.getNaturalExits().add(sux);
                    }
                }
                loop.getNaturalExits().sort(BasicBlock.BLOCK_ID_COMPARATOR);
                if (!this.graph.getGuardsStage().areFrameStatesAtDeopts()) {
                    for (LoopExitNode exit : loopBegin.loopExits()) {
                        HIRBlock exitBlock = this.nodeToBlock.get(exit);
                        assert (exitBlock.getPredecessorCount() == 1) : Assertions.errorMessage(exit, exitBlock);
                        ControlFlowGraph.computeLoopBlocks(exitBlock.getFirstPredecessor(), loop, stack, true);
                        loop.getLoopExits().add(exitBlock);
                    }
                    loop.getLoopExits().sort(BasicBlock.BLOCK_ID_COMPARATOR);
                    int size = loop.getBlocks().size();
                    for (int i = 0; i < size; ++i) {
                        HIRBlock b = (HIRBlock)loop.getBlocks().get(i);
                        for (int j = 0; j < b.getSuccessorCount(); ++j) {
                            AbstractBeginNode begin;
                            HIRBlock sux = (HIRBlock)b.getSuccessorAt(j);
                            if (sux.getLoop() == loop || loopBegin.isLoopExit(begin = sux.getBeginNode())) continue;
                            assert (!(begin instanceof LoopBeginNode)) : Assertions.errorMessageContext("begin", begin);
                            assert (sux.getLoopDepth() < loop.getDepth()) : Assertions.errorMessageContext("sux", sux, "sux.loopDepth", sux.getLoopDepth(), "loop", loop, "loop.loopDepth", loop.getDepth());
                            this.graph.getDebug().log(3, "Unexpected loop exit with %s, including whole branch in the loop", (Object)sux);
                            ControlFlowGraph.computeLoopBlocks(sux, loop, stack, false);
                        }
                    }
                    continue;
                }
                loop.getLoopExits().addAll(loop.getNaturalExits());
            }
        }
    }

    private static void computeLoopBlocks(HIRBlock start, CFGLoop<HIRBlock> loop, HIRBlock[] stack, boolean usePred) {
        if (start.getLoop() != loop) {
            start.setLoop(loop);
            stack[0] = start;
            loop.getBlocks().add(start);
            int tos = 0;
            do {
                HIRBlock block = stack[tos--];
                for (int i = 0; i < (usePred ? block.getPredecessorCount() : block.getSuccessorCount()); ++i) {
                    HIRBlock b;
                    HIRBlock hIRBlock = b = usePred ? (HIRBlock)block.getPredecessorAt(i) : (HIRBlock)block.getSuccessorAt(i);
                    if (b.getLoop() == loop) continue;
                    stack[++tos] = b;
                    b.setLoop(loop);
                    loop.getBlocks().add(b);
                }
            } while (tos >= 0);
        }
    }

    public void computePostdominators() {
        if (this.buildConfig.postdominatorsComputed) {
            return;
        }
        this.buildConfig.postdominatorsComputed = true;
        HIRBlock[] reversePostOrderTmp = this.reversePostOrder;
        block0: for (int j = reversePostOrderTmp.length - 1; j >= 0; --j) {
            HIRBlock block = reversePostOrderTmp[j];
            if (block.isLoopEnd() || block.getSuccessorCount() == 0) continue;
            HIRBlock firstSucc = (HIRBlock)block.getSuccessorAt(0);
            if (block.getSuccessorCount() == 1) {
                block.postdominator = firstSucc.getId();
                continue;
            }
            HIRBlock postdominator = firstSucc;
            for (int i = 0; i < block.getSuccessorCount(); ++i) {
                HIRBlock sux = (HIRBlock)block.getSuccessorAt(i);
                if ((postdominator = ControlFlowGraph.commonPostdominator(postdominator, sux)) == null) continue block0;
            }
            assert (!block.containsSucc(postdominator)) : "Block " + String.valueOf(block) + " has a wrong post dominator: " + String.valueOf(postdominator);
            block.setPostDominator(postdominator);
        }
    }

    private static HIRBlock commonPostdominator(HIRBlock a, HIRBlock b) {
        HIRBlock iterA = a;
        HIRBlock iterB = b;
        while (iterA != iterB) {
            if (iterA.getId() < iterB.getId()) {
                if ((iterA = iterA.getPostdominator()) != null) continue;
                return null;
            }
            assert (iterB.getId() < iterA.getId()) : Assertions.errorMessageContext("a", a, "b", b, "iterB.id", iterB.getId(), "iterA.id", iterA.getId());
            if ((iterB = iterB.getPostdominator()) != null) continue;
            return null;
        }
        return iterA;
    }

    public void setNodeToBlock(NodeMap<HIRBlock> nodeMap) {
        this.nodeToBlock = nodeMap;
    }

    public static double multiplyRelativeFrequencies(double a, double b, double c) {
        return ControlFlowGraph.multiplyRelativeFrequencies(ControlFlowGraph.multiplyRelativeFrequencies(a, b), c);
    }

    public static double multiplyRelativeFrequencies(double a, double b) {
        assert (!Double.isNaN(a) && !Double.isNaN(b) && Double.isFinite(a) && Double.isFinite(b)) : a + " " + b;
        double r = a * b;
        if (r > 3.273390607896142E150) {
            return 3.273390607896142E150;
        }
        if (r < 3.054936363499605E-151) {
            return 3.054936363499605E-151;
        }
        return r;
    }

    public record BlockTransplantData(HIRBlock oldBlock, BlockTransplantOrigin source, int oldBlockIDBeforeTransplant) {
    }

    public static enum BlockTransplantOrigin {
        CALLER,
        CALLEE;

    }

    private static final class BuildConfiguration {
        private boolean modifiableBlocks = false;
        private boolean connectBlocks = false;
        private boolean frequenciesComputed = false;
        private boolean loopsComputed = false;
        private boolean dominatorsComputed = false;
        private boolean postdominatorsComputed = false;

        private BuildConfiguration() {
        }

        public boolean notWeakerThan(boolean connectBlocks, boolean computeFrequency, boolean computeLoops, boolean computeDominators, boolean computePostdominators) {
            return !(!this.connectBlocks && connectBlocks || !this.frequenciesComputed && computeFrequency || !this.loopsComputed && computeLoops || !this.dominatorsComputed && computeDominators || !this.postdominatorsComputed && computePostdominators);
        }
    }

    public static class CFGOptions {
        public static final OptionKey<Boolean> UseLoopEndFrequencies = new OptionKey<Boolean>(false);
        public static final OptionKey<Boolean> DumpEndVersusExitLoopFrequencies = new OptionKey<Boolean>(false);
        public static final OptionKey<Double> LoopExitVsLoopEndFrequencyDiff = new OptionKey<Double>(1000.0);
    }

    public static interface RecursiveVisitor<V> {
        public V enter(HIRBlock var1);

        public void exit(HIRBlock var1, V var2);
    }

    public static final class DeferredExit {
        private final HIRBlock block;
        private final DeferredExit next;

        public DeferredExit(HIRBlock block, DeferredExit next) {
            this.block = block;
            this.next = next;
        }
    }

    private static class RPOLoopVerification {
        int endsVisited;
        int exitsVisited;
        LoopBeginNode lb;

        RPOLoopVerification(LoopBeginNode lb) {
            this.lb = lb;
        }

        boolean loopFullyProcessed() {
            return this.lb.getLoopEndCount() == this.endsVisited && this.exitsVisited == this.lb.loopExits().count();
        }

        boolean allEndsVisited() {
            return this.lb.getLoopEndCount() == this.endsVisited;
        }
    }

    public static class LoggingCFGDecorator
    implements RecursiveVisitor<HIRBlock> {
        private final RecursiveVisitor<HIRBlock> visitor;
        private String indent = "";

        public LoggingCFGDecorator(RecursiveVisitor<HIRBlock> visitor, ControlFlowGraph cfg) {
            this.visitor = visitor;
            TTY.printf("DomTree for %s%n", cfg.graph);
            LoggingCFGDecorator.printDomTree(cfg.getStartBlock(), "");
        }

        private static void printDomTree(HIRBlock cur, String indent) {
            TTY.printf("%s%s [dom %s, post dom %s]%n", indent, cur, cur.getDominator(), cur.getPostdominator());
            for (HIRBlock dominated = (HIRBlock)cur.getFirstDominated(); dominated != null; dominated = (HIRBlock)dominated.getDominatedSibling()) {
                LoggingCFGDecorator.printDomTree(dominated, indent + "\t");
            }
        }

        @Override
        public HIRBlock enter(HIRBlock b) {
            TTY.printf("%sEnter block %s for %s%n", this.indent, b, this.visitor);
            this.indent = this.indent + "\t";
            return this.visitor.enter(b);
        }

        @Override
        public void exit(HIRBlock b, HIRBlock value) {
            this.indent = this.indent.substring(0, this.indent.length() - 1);
            TTY.printf("%sExit block %s with value %s for %s%n", this.indent, b, value, this.visitor);
            this.visitor.exit(b, value);
        }
    }
}

