/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.nodes.cfg;

import java.util.ArrayDeque;
import jdk.graal.compiler.core.common.cfg.BasicBlock;
import jdk.graal.compiler.core.common.cfg.BlockMap;
import jdk.graal.compiler.core.common.cfg.CFGLoop;
import jdk.graal.compiler.debug.Assertions;
import jdk.graal.compiler.nodes.cfg.ControlFlowGraph;
import jdk.graal.compiler.nodes.cfg.HIRBlock;

public class CFGVerifier {
    public static boolean verify(ControlFlowGraph cfg) {
        for (HIRBlock block : cfg.getBlocks()) {
            int i;
            assert (block.getId() <= 0x7FFFFFFE) : block.getId();
            assert (cfg.getBlocks()[block.getId()] == block) : Assertions.errorMessageContext("block", block, "cfgBlockId", cfg.getBlocks()[block.getId()]);
            for (i = 0; i < block.getPredecessorCount(); ++i) {
                HIRBlock pred = (HIRBlock)block.getPredecessorAt(i);
                assert (pred.containsSucc(block));
                assert (pred.getId() < block.getId() || pred.isLoopEnd());
            }
            for (i = 0; i < block.getSuccessorCount(); ++i) {
                HIRBlock sux = (HIRBlock)block.getSuccessorAt(i);
                assert (sux.containsPred(block));
                assert (sux.getId() > block.getId() || sux.isLoopHeader());
            }
            if (block.getDominator() != null) {
                Object domChild;
                assert (((HIRBlock)block.getDominator()).getId() < block.getId()) : Assertions.errorMessage(block, block.getDominator());
                for (domChild = ((HIRBlock)block.getDominator()).getFirstDominated(); domChild != null && domChild != block; domChild = ((BasicBlock)domChild).getDominatedSibling()) {
                }
                assert (domChild != null) : "dominators must contain block";
            }
            for (HIRBlock dominated = (HIRBlock)block.getFirstDominated(); dominated != null; dominated = (HIRBlock)dominated.getDominatedSibling()) {
                assert (dominated.getId() > block.getId()) : Assertions.errorMessageContext("dominated", dominated, "block", block);
                assert (dominated.getDominator() == block) : Assertions.errorMessageContext("domianted", dominated, "dominated.dom", dominated.getDominator(), "block", block);
            }
            HIRBlock postDominatorBlock = block.getPostdominator();
            if (postDominatorBlock != null) {
                assert (block.getSuccessorCount() > 0) : "block has post-dominator block, but no successors";
                BlockMap<Boolean> visitedBlocks = new BlockMap<Boolean>(cfg);
                visitedBlocks.put(block, true);
                ArrayDeque<HIRBlock> stack = new ArrayDeque<HIRBlock>();
                for (int i2 = 0; i2 < block.getSuccessorCount(); ++i2) {
                    HIRBlock sux = (HIRBlock)block.getSuccessorAt(i2);
                    visitedBlocks.put(sux, true);
                    stack.push(sux);
                }
                while (stack.size() > 0) {
                    HIRBlock tos = (HIRBlock)stack.pop();
                    assert (tos.getId() <= postDominatorBlock.getId()) : Assertions.errorMessageContext("tos", tos, "tos.getid", tos.getId(), "postDom", postDominatorBlock, "postDomId", postDominatorBlock.getId());
                    if (tos == postDominatorBlock) continue;
                    assert (tos.getSuccessorCount() > 0) : "no path found";
                    for (int i3 = 0; i3 < tos.getSuccessorCount(); ++i3) {
                        HIRBlock sux = (HIRBlock)tos.getSuccessorAt(i3);
                        if (visitedBlocks.get(sux) != null) continue;
                        visitedBlocks.put(sux, true);
                        stack.push(sux);
                    }
                }
            }
            assert (cfg.getLoops() == null || !block.isLoopHeader() || block.getLoop().getHeader() == block) : Assertions.errorMessage(block, block.getLoop());
        }
        if (cfg.getLoops() != null) {
            for (CFGLoop cFGLoop : cfg.getLoops()) {
                CFGLoop<HIRBlock> blockLoop;
                assert (((HIRBlock)cFGLoop.getHeader()).isLoopHeader()) : "LoopHeader block must be loop header " + Assertions.errorMessageContext("loop", cFGLoop, "loop.getheader", cFGLoop.getHeader());
                for (HIRBlock block : cFGLoop.getBlocks()) {
                    assert (block.getId() >= ((HIRBlock)cFGLoop.getHeader()).getId()) : Assertions.errorMessageContext("block", block, "loop.getheader", cFGLoop.getHeader());
                    for (blockLoop = block.getLoop(); blockLoop != cFGLoop; blockLoop = blockLoop.getParent()) {
                        assert (blockLoop != null);
                    }
                    if (block.isLoopHeader() && block.getLoop() == cFGLoop) continue;
                    for (int i = 0; i < block.getPredecessorCount(); ++i) {
                        HIRBlock pred = (HIRBlock)block.getPredecessorAt(i);
                        if (cFGLoop.getBlocks().contains(pred)) continue;
                        assert (false) : "Loop " + String.valueOf(cFGLoop) + " does not contain " + String.valueOf(pred);
                        return false;
                    }
                }
                for (HIRBlock block : cFGLoop.getLoopExits()) {
                    assert (block.getId() >= ((HIRBlock)cFGLoop.getHeader()).getId()) : Assertions.errorMessageContext("block", block, "loop", cFGLoop, "loop.gethead", cFGLoop.getHeader());
                    for (blockLoop = block.getLoop(); blockLoop != null; blockLoop = blockLoop.getParent()) {
                        assert (blockLoop != cFGLoop) : "Parent loop must be different than loop that is exitted " + Assertions.errorMessageContext("blockLoop", blockLoop, "loop", cFGLoop);
                    }
                }
            }
        }
        return true;
    }
}

