/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.nodes.calc;

import java.nio.ByteOrder;
import jdk.graal.compiler.core.common.type.StampFactory;
import jdk.graal.compiler.graph.Node;
import jdk.graal.compiler.graph.NodeClass;
import jdk.graal.compiler.nodeinfo.NodeCycles;
import jdk.graal.compiler.nodeinfo.NodeInfo;
import jdk.graal.compiler.nodes.ConstantNode;
import jdk.graal.compiler.nodes.NodeView;
import jdk.graal.compiler.nodes.ValueNode;
import jdk.graal.compiler.nodes.calc.IntegerConvertNode;
import jdk.graal.compiler.nodes.calc.ReinterpretNode;
import jdk.graal.compiler.nodes.calc.UnaryNode;
import jdk.graal.compiler.nodes.calc.UnsignedRightShiftNode;
import jdk.graal.compiler.nodes.spi.CanonicalizerTool;
import jdk.graal.compiler.nodes.spi.Lowerable;
import jdk.vm.ci.meta.JavaKind;

@NodeInfo(cycles=NodeCycles.CYCLES_2)
public final class UnpackEndianHalfNode
extends UnaryNode
implements Lowerable {
    public static final NodeClass<UnpackEndianHalfNode> TYPE = NodeClass.create(UnpackEndianHalfNode.class);
    private final boolean firstHalf;

    protected UnpackEndianHalfNode(ValueNode value, boolean firstHalf) {
        super(TYPE, StampFactory.forKind(JavaKind.Int), value);
        assert (value.getStackKind() == JavaKind.Double || value.getStackKind() == JavaKind.Long) : "unexpected kind " + String.valueOf(value.getStackKind());
        this.firstHalf = firstHalf;
    }

    public static ValueNode create(ValueNode value, boolean firstHalf, NodeView view) {
        if (value.isConstant() && value.asConstant().isDefaultForKind()) {
            return ConstantNode.defaultForKind(JavaKind.Int);
        }
        return new UnpackEndianHalfNode(value, firstHalf);
    }

    public boolean isFirstHalf() {
        return this.firstHalf;
    }

    @Override
    public Node canonical(CanonicalizerTool tool, ValueNode forValue) {
        if (forValue.isDefaultConstant()) {
            return ConstantNode.defaultForKind(this.stamp.getStackKind());
        }
        return this;
    }

    public void lower(ByteOrder byteOrder) {
        ValueNode result = this.value;
        if (this.value.getStackKind() == JavaKind.Double) {
            result = this.graph().unique(new ReinterpretNode(JavaKind.Long, this.value));
        }
        if (byteOrder == ByteOrder.BIG_ENDIAN == this.firstHalf) {
            result = this.graph().unique(new UnsignedRightShiftNode(result, ConstantNode.forInt(32, this.graph())));
        }
        result = IntegerConvertNode.convert(result, StampFactory.forKind(JavaKind.Int), this.graph(), NodeView.DEFAULT);
        this.replaceAtUsagesAndDelete(result);
    }
}

