/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.nodes.calc;

import jdk.graal.compiler.core.common.type.ArithmeticOpTable;
import jdk.graal.compiler.core.common.type.FloatStamp;
import jdk.graal.compiler.core.common.type.Stamp;
import jdk.graal.compiler.debug.Assertions;
import jdk.graal.compiler.debug.GraalError;
import jdk.graal.compiler.graph.NodeClass;
import jdk.graal.compiler.nodeinfo.NodeCycles;
import jdk.graal.compiler.nodeinfo.NodeInfo;
import jdk.graal.compiler.nodeinfo.NodeSize;
import jdk.graal.compiler.nodes.ArithmeticOperation;
import jdk.graal.compiler.nodes.ConstantNode;
import jdk.graal.compiler.nodes.NodeView;
import jdk.graal.compiler.nodes.ValueNode;
import jdk.graal.compiler.nodes.calc.BinaryArithmeticNode;
import jdk.graal.compiler.nodes.calc.FusedMultiplyAddNode;
import jdk.graal.compiler.nodes.calc.TernaryNode;
import jdk.graal.compiler.nodes.spi.ArithmeticLIRLowerable;
import jdk.graal.compiler.nodes.spi.Canonicalizable;
import jdk.graal.compiler.nodes.spi.CanonicalizerTool;
import jdk.vm.ci.meta.Constant;

@NodeInfo(cycles=NodeCycles.CYCLES_1, size=NodeSize.SIZE_1)
public abstract class TernaryArithmeticNode<OP>
extends TernaryNode
implements ArithmeticOperation,
ArithmeticLIRLowerable,
Canonicalizable.Ternary<ValueNode> {
    public static final NodeClass<TernaryArithmeticNode> TYPE = NodeClass.create(TernaryArithmeticNode.class);

    protected TernaryArithmeticNode(NodeClass<? extends TernaryArithmeticNode<OP>> c, ArithmeticOpTable.TernaryOp<OP> opForStampComputation, ValueNode x, ValueNode y, ValueNode z) {
        super(c, opForStampComputation.foldStamp(x.stamp(NodeView.DEFAULT), y.stamp(NodeView.DEFAULT), z.stamp(NodeView.DEFAULT)), x, y, z);
    }

    protected abstract ArithmeticOpTable.TernaryOp<OP> getOp(ArithmeticOpTable var1);

    private ArithmeticOpTable.TernaryOp<OP> getOp(ValueNode forX, ValueNode forY, ValueNode forZ) {
        ArithmeticOpTable table = BinaryArithmeticNode.getArithmeticOpTable(forX);
        assert (table.equals(BinaryArithmeticNode.getArithmeticOpTable(forY)) && table.equals(BinaryArithmeticNode.getArithmeticOpTable(forZ))) : "Should have the same type";
        return this.getOp(table);
    }

    @Override
    public final ArithmeticOpTable.TernaryOp<OP> getArithmeticOp() {
        return this.getOp(this.getX(), this.getY(), this.getZ());
    }

    public ValueNode canonical(CanonicalizerTool tool, ValueNode forX, ValueNode forY, ValueNode forZ) {
        NodeView view = NodeView.from(tool);
        ConstantNode result = TernaryArithmeticNode.tryConstantFold(this.getOp(forX, forY, forZ), forX, forY, forZ, this.stamp(view));
        if (result != null) {
            return result;
        }
        return this;
    }

    public static <OP> ConstantNode tryConstantFold(ArithmeticOpTable.TernaryOp<OP> op, ValueNode forX, ValueNode forY, ValueNode forZ, Stamp stamp) {
        Constant ret;
        if (forX.isConstant() && forY.isConstant() && forZ.isConstant() && (ret = op.foldConstant(forX.asConstant(), forY.asConstant(), forZ.asConstant())) != null) {
            return ConstantNode.forPrimitive(stamp, ret);
        }
        return null;
    }

    @Override
    public Stamp foldStamp(Stamp stampX, Stamp stampY, Stamp stampZ) {
        assert (stampX.isCompatible(this.x.stamp(NodeView.DEFAULT))) : Assertions.errorMessageContext("this", this, "xStamp", this.x.stamp(NodeView.DEFAULT), "stampX", stampX);
        assert (stampY.isCompatible(this.y.stamp(NodeView.DEFAULT))) : Assertions.errorMessageContext("this", this, "yStamp", this.y.stamp(NodeView.DEFAULT), "stampY", stampY);
        assert (stampZ.isCompatible(this.z.stamp(NodeView.DEFAULT))) : Assertions.errorMessageContext("this", this, "zStamp", this.z.stamp(NodeView.DEFAULT), "stampZ", stampZ);
        return ((ArithmeticOpTable.TernaryOp)this.getArithmeticOp()).foldStamp(stampX, stampY, stampZ);
    }

    public static ValueNode ternaryFloatOp(ValueNode v1, ValueNode v2, ValueNode v3, NodeView view, ArithmeticOpTable.TernaryOp<?> op) {
        if (FloatStamp.OPS.getFMA().equals(op)) {
            return FusedMultiplyAddNode.create(v1, v2, v3, view);
        }
        throw GraalError.shouldNotReachHere(String.format("%s is not a ternary operation!", op));
    }
}

