/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.nodes.calc;

import jdk.graal.compiler.core.common.GraalOptions;
import jdk.graal.compiler.core.common.NumUtil;
import jdk.graal.compiler.core.common.type.IntegerStamp;
import jdk.graal.compiler.core.common.type.PrimitiveStamp;
import jdk.graal.compiler.core.common.type.Stamp;
import jdk.graal.compiler.debug.Assertions;
import jdk.graal.compiler.graph.Node;
import jdk.graal.compiler.graph.NodeClass;
import jdk.graal.compiler.nodeinfo.NodeInfo;
import jdk.graal.compiler.nodes.ConstantNode;
import jdk.graal.compiler.nodes.FrameState;
import jdk.graal.compiler.nodes.GraphState;
import jdk.graal.compiler.nodes.NodeView;
import jdk.graal.compiler.nodes.ValueNode;
import jdk.graal.compiler.nodes.calc.BinaryArithmeticNode;
import jdk.graal.compiler.nodes.calc.IntegerDivRemNode;
import jdk.graal.compiler.nodes.calc.NegateNode;
import jdk.graal.compiler.nodes.calc.RightShiftNode;
import jdk.graal.compiler.nodes.calc.SignedFloatingIntegerDivNode;
import jdk.graal.compiler.nodes.calc.SignedRemNode;
import jdk.graal.compiler.nodes.calc.SubNode;
import jdk.graal.compiler.nodes.calc.UnsignedRightShiftNode;
import jdk.graal.compiler.nodes.extended.GuardingNode;
import jdk.graal.compiler.nodes.spi.CanonicalizerTool;
import jdk.graal.compiler.nodes.spi.LIRLowerable;
import jdk.graal.compiler.nodes.spi.NodeLIRBuilderTool;
import jdk.vm.ci.code.CodeUtil;

@NodeInfo(shortName="/")
public class SignedDivNode
extends IntegerDivRemNode
implements LIRLowerable {
    public static final NodeClass<SignedDivNode> TYPE = NodeClass.create(SignedDivNode.class);

    public SignedDivNode(ValueNode x, ValueNode y, GuardingNode zeroCheck) {
        this(TYPE, x, y, zeroCheck);
    }

    protected SignedDivNode(NodeClass<? extends SignedDivNode> c, ValueNode x, ValueNode y, GuardingNode zeroCheck) {
        super(c, IntegerStamp.OPS.getDiv().foldStamp(x.stamp(NodeView.DEFAULT), y.stamp(NodeView.DEFAULT)), IntegerDivRemNode.Op.DIV, IntegerDivRemNode.Type.SIGNED, x, y, zeroCheck);
    }

    public static ValueNode create(ValueNode x, ValueNode y, GuardingNode zeroCheck, NodeView view) {
        return SignedDivNode.canonical(null, x, y, zeroCheck, view);
    }

    @Override
    public boolean inferStamp() {
        return this.updateStamp(IntegerStamp.OPS.getDiv().foldStamp(this.getX().stamp(NodeView.DEFAULT), this.getY().stamp(NodeView.DEFAULT)));
    }

    public ValueNode canonical(CanonicalizerTool tool, ValueNode forX, ValueNode forY) {
        NodeView view = NodeView.from(tool);
        return SignedDivNode.canonical(this, forX, forY, this.getZeroGuard(), view, this.canDeoptimize() ? tool.divisionOverflowIsJVMSCompliant() : true);
    }

    protected SignedDivNode createWithInputs(ValueNode forX, ValueNode forY, GuardingNode forZeroCheck, FrameState forStateBefore) {
        SignedDivNode sd = new SignedDivNode(forX, forY, forZeroCheck);
        sd.stateBefore = forStateBefore;
        return sd;
    }

    public static ValueNode canonical(SignedDivNode self, ValueNode forX, ValueNode forY, GuardingNode zeroCheck, NodeView view) {
        return SignedDivNode.canonical(self, forX, forY, zeroCheck, view, self == null ? false : !self.canDeoptimize());
    }

    public static ValueNode canonical(SignedDivNode self, ValueNode forX, ValueNode forY, GuardingNode zeroCheck, NodeView view, boolean divisionOverflowIsJVMSCompliant) {
        IntegerStamp yStamp;
        SubNode integerSubNode;
        long c;
        ValueNode v;
        Stamp stamp;
        Stamp predictedStamp = IntegerStamp.OPS.getDiv().foldStamp(forX.stamp(NodeView.DEFAULT), forY.stamp(NodeView.DEFAULT));
        Stamp stamp2 = stamp = self != null ? self.stamp(view) : predictedStamp;
        if (forX.isConstant() && forY.isConstant()) {
            long y = forY.asJavaConstant().asLong();
            if (y == 0L) {
                return self != null ? self : new SignedDivNode(forX, forY, zeroCheck);
            }
            return ConstantNode.forIntegerStamp(stamp, forX.asJavaConstant().asLong() / y);
        }
        if (forY.isConstant() && (v = SignedDivNode.canonical(forX, c = forY.asJavaConstant().asLong(), view)) != null) {
            return v;
        }
        if (forX instanceof SubNode && (integerSubNode = (SubNode)forX).getY() instanceof SignedRemNode) {
            SignedRemNode integerRemNode = (SignedRemNode)integerSubNode.getY();
            if (integerSubNode.stamp(view).isCompatible(stamp) && integerRemNode.stamp(view).isCompatible(stamp) && integerSubNode.getX() == integerRemNode.getX() && forY == integerRemNode.getY()) {
                if (self != null) {
                    return self.createWithInputs(integerSubNode.getX(), forY, zeroCheck, self.stateBefore);
                }
                return new SignedDivNode(integerSubNode.getX(), forY, zeroCheck);
            }
        }
        if (self != null && self.canFloat() && GraalOptions.FloatingDivNodes.getValue(self.getOptions()).booleanValue() && self.graph().isBeforeStage(GraphState.StageFlag.VALUE_PROXY_REMOVAL) && !(yStamp = (IntegerStamp)forY.stamp(view)).contains(0L) && SignedDivNode.divisionIsJVMSCompliant(forX, forY, divisionOverflowIsJVMSCompliant)) {
            return SignedFloatingIntegerDivNode.create(forX, forY, view, zeroCheck, divisionOverflowIsJVMSCompliant);
        }
        if (self != null && self.next() instanceof SignedDivNode) {
            NodeClass<? extends Node> nodeClass = self.getNodeClass();
            if (self.next().getClass() == self.getClass() && nodeClass.equalInputs(self, self.next()) && self.valueEquals(self.next())) {
                return self.next();
            }
        }
        return self != null ? self : new SignedDivNode(forX, forY, zeroCheck);
    }

    @Override
    public boolean canFloat() {
        return true;
    }

    public static boolean divisionIsJVMSCompliant(ValueNode dividend, ValueNode divisor, boolean platformIsCompliant) {
        if (platformIsCompliant) {
            return true;
        }
        IntegerStamp dividendStamp = (IntegerStamp)dividend.stamp(NodeView.DEFAULT);
        IntegerStamp divisorStamp = (IntegerStamp)divisor.stamp(NodeView.DEFAULT);
        assert (dividendStamp.getBits() == divisorStamp.getBits()) : Assertions.errorMessage(dividend, divisor);
        long minValue = NumUtil.minValue(dividendStamp.getBits());
        return !dividendStamp.contains(minValue) || !divisorStamp.contains(-1L);
    }

    public static ValueNode canonical(ValueNode forX, long c, NodeView view) {
        if (c == 1L) {
            return forX;
        }
        if (c == -1L) {
            return NegateNode.create(forX, view);
        }
        if (NumUtil.absOverflows(c, IntegerStamp.getBits(forX.stamp(view)))) {
            return null;
        }
        long abs = NumUtil.safeAbs(c, forX);
        if (CodeUtil.isPowerOf2((long)abs) && forX.stamp(view) instanceof IntegerStamp) {
            IntegerStamp stampX = (IntegerStamp)forX.stamp(view);
            ValueNode dividend = forX;
            int log2 = CodeUtil.log2((long)abs);
            if (stampX.canBeNegative() && (stampX.mayBeSet() & abs - 1L) != 0L) {
                int bits = PrimitiveStamp.getBits(forX.stamp(view));
                RightShiftNode sign = new RightShiftNode(forX, ConstantNode.forInt(bits - 1));
                UnsignedRightShiftNode round = new UnsignedRightShiftNode(sign, ConstantNode.forInt(bits - log2));
                dividend = BinaryArithmeticNode.add(dividend, round, view);
            }
            RightShiftNode shift = new RightShiftNode(dividend, ConstantNode.forInt(log2));
            if (c < 0L) {
                return NegateNode.create(shift, view);
            }
            return shift;
        }
        return null;
    }

    @Override
    public void generate(NodeLIRBuilderTool gen) {
        gen.setResult(this, gen.getLIRGeneratorTool().getArithmetic().emitDiv(gen.operand(this.getX()), gen.operand(this.getY()), gen.state(this)));
    }
}

