/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.nodes.calc;

import java.util.Set;
import jdk.graal.compiler.core.common.type.ArithmeticOpTable;
import jdk.graal.compiler.core.common.type.IntegerStamp;
import jdk.graal.compiler.core.common.type.Stamp;
import jdk.graal.compiler.debug.GraalError;
import jdk.graal.compiler.graph.NodeClass;
import jdk.graal.compiler.nodeinfo.NodeCycles;
import jdk.graal.compiler.nodeinfo.NodeInfo;
import jdk.graal.compiler.nodeinfo.NodeSize;
import jdk.graal.compiler.nodes.ArithmeticOperation;
import jdk.graal.compiler.nodes.ConstantNode;
import jdk.graal.compiler.nodes.NodeView;
import jdk.graal.compiler.nodes.ValueNode;
import jdk.graal.compiler.nodes.calc.BinaryArithmeticNode;
import jdk.graal.compiler.nodes.calc.BinaryNode;
import jdk.graal.compiler.nodes.calc.LeftShiftNode;
import jdk.graal.compiler.nodes.calc.NarrowableArithmeticNode;
import jdk.graal.compiler.nodes.calc.RightShiftNode;
import jdk.graal.compiler.nodes.calc.UnsignedRightShiftNode;
import jdk.graal.compiler.nodes.spi.ArithmeticLIRLowerable;
import jdk.graal.compiler.nodes.spi.CanonicalizerTool;
import jdk.vm.ci.code.CodeUtil;
import jdk.vm.ci.meta.Constant;

@NodeInfo(cycles=NodeCycles.CYCLES_1, size=NodeSize.SIZE_1)
public abstract class ShiftNode<OP>
extends BinaryNode
implements ArithmeticOperation,
ArithmeticLIRLowerable,
NarrowableArithmeticNode {
    public static final NodeClass<ShiftNode> TYPE = NodeClass.create(ShiftNode.class);

    protected ShiftNode(NodeClass<? extends ShiftNode<OP>> c, ArithmeticOpTable.ShiftOp<OP> opForStampComputation, ValueNode x, ValueNode s) {
        super(c, opForStampComputation.foldStamp(x.stamp(NodeView.DEFAULT), s.stamp(NodeView.DEFAULT)), x, s);
    }

    protected abstract ArithmeticOpTable.ShiftOp<OP> getOp(ArithmeticOpTable var1);

    protected final ArithmeticOpTable.ShiftOp<OP> getOp(ValueNode forValue) {
        return this.getOp(BinaryArithmeticNode.getArithmeticOpTable(forValue));
    }

    @Override
    public final ArithmeticOpTable.ShiftOp<OP> getArithmeticOp() {
        return this.getOp(this.getX());
    }

    @Override
    public Stamp foldStamp(Stamp stampX, Stamp stampY) {
        return ((ArithmeticOpTable.BinaryOp)this.getArithmeticOp()).foldStamp(stampX, stampY);
    }

    public ValueNode canonical(CanonicalizerTool tool, ValueNode forX, ValueNode forY) {
        NodeView view = NodeView.from(tool);
        ValueNode valueNode = ShiftNode.canonical(this.getOp(forX), this.stamp(NodeView.DEFAULT), forX, forY, view);
        if (valueNode != null) {
            return valueNode;
        }
        return this;
    }

    public static <OP> ValueNode canonical(ArithmeticOpTable.ShiftOp<OP> op, Stamp stamp, ValueNode forX, ValueNode forY, NodeView view) {
        if (forX.isConstant() && forY.isConstant()) {
            Constant amount = forY.asConstant();
            return ConstantNode.forPrimitive(stamp, op.foldConstant(forX.asConstant(), amount));
        }
        return null;
    }

    public static ValueNode shiftOp(ValueNode x, ValueNode y, NodeView view, ArithmeticOpTable.ShiftOp<?> op) {
        if (IntegerStamp.OPS.getShl().equals(op)) {
            return LeftShiftNode.create(x, y, view);
        }
        if (IntegerStamp.OPS.getShr().equals(op)) {
            return RightShiftNode.create(x, y, view);
        }
        if (IntegerStamp.OPS.getUShr().equals(op)) {
            return UnsignedRightShiftNode.create(x, y, view);
        }
        if (Set.of(IntegerStamp.OPS.getShiftOps()).contains(op)) {
            GraalError.unimplemented(String.format("creating %s via ShiftNode#shiftOp is not implemented yet", op));
        } else {
            GraalError.shouldNotReachHere(String.format("%s is not a shift operation!", op));
        }
        return null;
    }

    public int getShiftAmountMask() {
        return ((ArithmeticOpTable.ShiftOp)this.getArithmeticOp()).getShiftAmountMask(this.stamp(NodeView.DEFAULT));
    }

    @Override
    public boolean isNarrowable(int resultBits) {
        assert (CodeUtil.isPowerOf2((int)resultBits));
        int narrowMask = resultBits <= 32 ? 31 : 63;
        int wideMask = this.getShiftAmountMask();
        assert ((wideMask & narrowMask) == narrowMask) : String.format("wideMask %x should be wider than narrowMask %x", wideMask, narrowMask);
        Stamp stamp = this.getY().stamp(NodeView.DEFAULT);
        if (!(stamp instanceof IntegerStamp)) {
            return false;
        }
        IntegerStamp yStamp = (IntegerStamp)stamp;
        return (yStamp.mayBeSet() & (long)(wideMask & ~narrowMask)) == 0L;
    }
}

