/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.nodes.calc;

import jdk.graal.compiler.core.common.type.ArithmeticOpTable;
import jdk.graal.compiler.core.common.type.IntegerStamp;
import jdk.graal.compiler.core.common.type.Stamp;
import jdk.graal.compiler.debug.Assertions;
import jdk.graal.compiler.graph.NodeClass;
import jdk.graal.compiler.lir.gen.ArithmeticLIRGeneratorTool;
import jdk.graal.compiler.nodeinfo.NodeInfo;
import jdk.graal.compiler.nodes.ConstantNode;
import jdk.graal.compiler.nodes.NodeView;
import jdk.graal.compiler.nodes.ValueNode;
import jdk.graal.compiler.nodes.calc.BinaryArithmeticNode;
import jdk.graal.compiler.nodes.calc.ShiftNode;
import jdk.graal.compiler.nodes.calc.UnsignedRightShiftNode;
import jdk.graal.compiler.nodes.spi.CanonicalizerTool;
import jdk.graal.compiler.nodes.spi.NodeLIRBuilderTool;
import jdk.vm.ci.code.CodeUtil;

@NodeInfo(shortName=">>")
public final class RightShiftNode
extends ShiftNode<ArithmeticOpTable.ShiftOp.Shr> {
    public static final NodeClass<RightShiftNode> TYPE = NodeClass.create(RightShiftNode.class);

    public RightShiftNode(ValueNode x, ValueNode y) {
        super(TYPE, BinaryArithmeticNode.getArithmeticOpTable(x).getShr(), x, y);
    }

    public static ValueNode create(ValueNode x, int y, NodeView view) {
        if (y == 0) {
            return x;
        }
        return RightShiftNode.create(x, ConstantNode.forInt(y), view);
    }

    public static ValueNode create(ValueNode x, ValueNode y, NodeView view) {
        Stamp stamp;
        ArithmeticOpTable.ShiftOp<ArithmeticOpTable.ShiftOp.Shr> op = ArithmeticOpTable.forStamp(x.stamp(view)).getShr();
        ValueNode value = RightShiftNode.canonical(op, stamp = op.foldStamp(x.stamp(view), y.stamp(view)), x, y, view);
        if (value != null) {
            return value;
        }
        return RightShiftNode.canonical(null, op, stamp, x, y, view);
    }

    @Override
    protected ArithmeticOpTable.ShiftOp<ArithmeticOpTable.ShiftOp.Shr> getOp(ArithmeticOpTable table) {
        return table.getShr();
    }

    @Override
    public ValueNode canonical(CanonicalizerTool tool, ValueNode forX, ValueNode forY) {
        NodeView view = NodeView.from(tool);
        ValueNode ret = super.canonical(tool, forX, forY);
        if (ret != this) {
            return ret;
        }
        return RightShiftNode.canonical(this, (ArithmeticOpTable.ShiftOp<ArithmeticOpTable.ShiftOp.Shr>)this.getArithmeticOp(), this.stamp(view), forX, forY, view);
    }

    private static ValueNode canonical(RightShiftNode rightShiftNode, ArithmeticOpTable.ShiftOp<ArithmeticOpTable.ShiftOp.Shr> op, Stamp stamp, ValueNode forX, ValueNode forY, NodeView view) {
        IntegerStamp xStamp;
        RightShiftNode self = rightShiftNode;
        if (forX.stamp(view) instanceof IntegerStamp && ((IntegerStamp)forX.stamp(view)).isPositive()) {
            return new UnsignedRightShiftNode(forX, forY);
        }
        Stamp xStampGeneric = forX.stamp(view);
        if (xStampGeneric instanceof IntegerStamp && (xStamp = (IntegerStamp)xStampGeneric).lowerBound() >= -1L && xStamp.upperBound() <= 0L) {
            return forX;
        }
        if (forY.isConstant() && op.isNeutral(forY.asConstant())) {
            return forX;
        }
        if (forY.isJavaConstant()) {
            ShiftNode other;
            IntegerStamp xStamp2;
            int amount;
            int originalAmout = amount = forY.asJavaConstant().asInt();
            int mask = op.getShiftAmountMask(stamp);
            if ((amount &= mask) == 0) {
                return forX;
            }
            if (xStampGeneric instanceof IntegerStamp && (xStamp2 = (IntegerStamp)xStampGeneric).lowerBound() >> amount == xStamp2.upperBound() >> amount) {
                return ConstantNode.forIntegerBits(xStamp2.getBits(), xStamp2.lowerBound() >> amount);
            }
            if (forX instanceof ShiftNode && (other = (ShiftNode)forX).getY().isConstant()) {
                int otherAmount = other.getY().asJavaConstant().asInt() & mask;
                if (other instanceof RightShiftNode) {
                    int total = amount + otherAmount;
                    if (total != (total & mask)) {
                        assert (other.getX().stamp(view) instanceof IntegerStamp) : Assertions.errorMessageContext("rightShiftNode", rightShiftNode, "forX", forX, "forY", forY, "other", other, "other.x", other.getX());
                        IntegerStamp istamp = (IntegerStamp)other.getX().stamp(view);
                        if (istamp.isPositive()) {
                            return ConstantNode.forIntegerBits(istamp.getBits(), 0L);
                        }
                        if (istamp.isStrictlyNegative()) {
                            return ConstantNode.forIntegerBits(istamp.getBits(), -1L);
                        }
                        assert (total >= mask) : Assertions.errorMessageContext("rightShiftNode", rightShiftNode, "forX", forX, "forY", forY, "other", other, "other.x", other.getX(), "total", total, "mask", mask);
                        return new RightShiftNode(other.getX(), ConstantNode.forInt(mask));
                    }
                    return new RightShiftNode(other.getX(), ConstantNode.forInt(total));
                }
            }
            if (originalAmout != amount) {
                return new RightShiftNode(forX, ConstantNode.forInt(amount));
            }
        }
        if (self == null) {
            self = new RightShiftNode(forX, forY);
        }
        return self;
    }

    @Override
    public void generate(NodeLIRBuilderTool nodeValueMap, ArithmeticLIRGeneratorTool gen) {
        nodeValueMap.setResult(this, gen.emitShr(nodeValueMap.operand(this.getX()), nodeValueMap.operand(this.getY())));
    }

    @Override
    public boolean isNarrowable(int resultBits) {
        if (resultBits >= 32 && super.isNarrowable(resultBits)) {
            IntegerStamp inputStamp = (IntegerStamp)this.getX().stamp(NodeView.DEFAULT);
            return CodeUtil.minValue((int)resultBits) <= inputStamp.lowerBound() && inputStamp.upperBound() <= CodeUtil.maxValue((int)resultBits);
        }
        return false;
    }
}

