/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.nodes.calc;

import jdk.graal.compiler.core.common.LIRKind;
import jdk.graal.compiler.core.common.calc.ReinterpretUtils;
import jdk.graal.compiler.core.common.type.ArithmeticOpTable;
import jdk.graal.compiler.core.common.type.ArithmeticStamp;
import jdk.graal.compiler.core.common.type.FloatStamp;
import jdk.graal.compiler.core.common.type.IntegerStamp;
import jdk.graal.compiler.core.common.type.Stamp;
import jdk.graal.compiler.core.common.type.StampFactory;
import jdk.graal.compiler.debug.Assertions;
import jdk.graal.compiler.graph.NodeClass;
import jdk.graal.compiler.lir.gen.ArithmeticLIRGeneratorTool;
import jdk.graal.compiler.nodeinfo.NodeCycles;
import jdk.graal.compiler.nodeinfo.NodeInfo;
import jdk.graal.compiler.nodes.ArithmeticOperation;
import jdk.graal.compiler.nodes.ConstantNode;
import jdk.graal.compiler.nodes.NodeView;
import jdk.graal.compiler.nodes.ValueNode;
import jdk.graal.compiler.nodes.calc.BinaryArithmeticNode;
import jdk.graal.compiler.nodes.calc.UnaryNode;
import jdk.graal.compiler.nodes.spi.ArithmeticLIRLowerable;
import jdk.graal.compiler.nodes.spi.CanonicalizerTool;
import jdk.graal.compiler.nodes.spi.NodeLIRBuilderTool;
import jdk.vm.ci.meta.Constant;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.SerializableConstant;

@NodeInfo(cycles=NodeCycles.CYCLES_1)
public final class ReinterpretNode
extends UnaryNode
implements ArithmeticOperation,
ArithmeticLIRLowerable {
    public static final NodeClass<ReinterpretNode> TYPE = NodeClass.create(ReinterpretNode.class);

    public ReinterpretNode(JavaKind to, ValueNode value) {
        this(StampFactory.forKind(to), value);
    }

    protected ReinterpretNode(Stamp to, ValueNode value) {
        super(TYPE, ReinterpretNode.getReinterpretStamp(to, value.stamp(NodeView.DEFAULT)), value);
        assert (to instanceof ArithmeticStamp) : Assertions.errorMessageContext("to", to, "value", value);
    }

    public static ValueNode create(JavaKind to, ValueNode value, NodeView view) {
        return ReinterpretNode.create(StampFactory.forKind(to), value, view);
    }

    public static ValueNode create(Stamp to, ValueNode value, NodeView view) {
        return ReinterpretNode.canonical(null, to, value, view);
    }

    private static Constant evalConst(Stamp forStamp, SerializableConstant c) {
        return ArithmeticOpTable.forStamp(forStamp).getReinterpret().foldConstant(forStamp, (Constant)c);
    }

    public ValueNode canonical(CanonicalizerTool tool, ValueNode forValue) {
        NodeView view = NodeView.from(tool);
        return ReinterpretNode.canonical(this, this.stamp(view), forValue, view);
    }

    public static ValueNode canonical(ReinterpretNode node, Stamp forStamp, ValueNode forValue, NodeView view) {
        if (forValue.isConstant()) {
            return ConstantNode.forConstant(forStamp, ReinterpretNode.evalConst(forStamp, (SerializableConstant)forValue.asConstant()), null);
        }
        if (forStamp.isCompatible(forValue.stamp(view))) {
            return forValue;
        }
        if (forValue instanceof ReinterpretNode) {
            ReinterpretNode reinterpret = (ReinterpretNode)forValue;
            if (forStamp.isCompatible(reinterpret.value.stamp(view))) {
                return reinterpret.value;
            }
        }
        return node != null ? node : new ReinterpretNode(forStamp, forValue);
    }

    private static Stamp getReinterpretStamp(Stamp toStamp, Stamp fromStamp) {
        if (toStamp instanceof IntegerStamp && fromStamp instanceof FloatStamp) {
            return ReinterpretUtils.floatToInt((FloatStamp)fromStamp);
        }
        if (toStamp instanceof FloatStamp && fromStamp instanceof IntegerStamp) {
            return ReinterpretUtils.intToFloat((IntegerStamp)fromStamp);
        }
        return toStamp;
    }

    @Override
    public Stamp foldStamp(Stamp newStamp) {
        assert (newStamp.isCompatible(this.getValue().stamp(NodeView.DEFAULT)));
        return ReinterpretNode.getOp(this.getValue()).foldStamp(this.stamp(NodeView.DEFAULT), newStamp);
    }

    @Override
    public void generate(NodeLIRBuilderTool builder, ArithmeticLIRGeneratorTool gen) {
        LIRKind kind = builder.getLIRGeneratorTool().getLIRKind(this.stamp(NodeView.DEFAULT));
        builder.setResult(this, gen.emitReinterpret(kind, builder.operand(this.getValue())));
    }

    public static ValueNode reinterpret(JavaKind toKind, ValueNode value) {
        return value.graph().unique(new ReinterpretNode(toKind, value));
    }

    @Override
    public ArithmeticOpTable.ReinterpretOp getArithmeticOp() {
        return ReinterpretNode.getOp(this.getValue());
    }

    private static ArithmeticOpTable.ReinterpretOp getOp(ValueNode forValue) {
        return BinaryArithmeticNode.getArithmeticOpTable(forValue).getReinterpret();
    }
}

