/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.nodes.calc;

import jdk.graal.compiler.core.common.type.ArithmeticOpTable;
import jdk.graal.compiler.core.common.type.IntegerStamp;
import jdk.graal.compiler.core.common.type.Stamp;
import jdk.graal.compiler.graph.NodeClass;
import jdk.graal.compiler.lir.gen.ArithmeticLIRGeneratorTool;
import jdk.graal.compiler.nodeinfo.NodeInfo;
import jdk.graal.compiler.nodes.ConstantNode;
import jdk.graal.compiler.nodes.NodeView;
import jdk.graal.compiler.nodes.ValueNode;
import jdk.graal.compiler.nodes.calc.AndNode;
import jdk.graal.compiler.nodes.calc.BinaryArithmeticNode;
import jdk.graal.compiler.nodes.calc.NarrowableArithmeticNode;
import jdk.graal.compiler.nodes.calc.NotNode;
import jdk.graal.compiler.nodes.spi.Canonicalizable;
import jdk.graal.compiler.nodes.spi.CanonicalizerTool;
import jdk.graal.compiler.nodes.spi.NodeLIRBuilderTool;
import jdk.graal.compiler.nodes.util.GraphUtil;
import jdk.vm.ci.meta.Constant;

@NodeInfo(shortName="|")
public final class OrNode
extends BinaryArithmeticNode<ArithmeticOpTable.BinaryOp.Or>
implements Canonicalizable.BinaryCommutative<ValueNode>,
NarrowableArithmeticNode {
    public static final NodeClass<OrNode> TYPE = NodeClass.create(OrNode.class);

    public OrNode(ValueNode x, ValueNode y) {
        super(TYPE, OrNode.getArithmeticOpTable(x).getOr(), x, y);
    }

    public static ValueNode create(ValueNode x, ValueNode y, NodeView view) {
        Stamp stamp;
        ArithmeticOpTable.BinaryOp<ArithmeticOpTable.BinaryOp.Or> op = ArithmeticOpTable.forStamp(x.stamp(view)).getOr();
        ConstantNode tryConstantFold = OrNode.tryConstantFold(op, x, y, stamp = op.foldStamp(x.stamp(view), y.stamp(view)), view);
        if (tryConstantFold != null) {
            return tryConstantFold;
        }
        return OrNode.canonical(null, op, x, y, view);
    }

    @Override
    protected ArithmeticOpTable.BinaryOp<ArithmeticOpTable.BinaryOp.Or> getOp(ArithmeticOpTable table) {
        return table.getOr();
    }

    @Override
    public ValueNode canonical(CanonicalizerTool tool, ValueNode forX, ValueNode forY) {
        NodeView view = NodeView.from(tool);
        ValueNode ret = super.canonical(tool, forX, forY);
        if (ret != this) {
            return ret;
        }
        return OrNode.canonical(this, this.getOp(forX, forY), forX, forY, view);
    }

    private static ValueNode canonical(OrNode self, ArithmeticOpTable.BinaryOp<ArithmeticOpTable.BinaryOp.Or> op, ValueNode forX, ValueNode forY, NodeView view) {
        if (GraphUtil.unproxify(forX) == GraphUtil.unproxify(forY)) {
            return forX;
        }
        if (forX.isConstant() && !forY.isConstant()) {
            return new OrNode(forY, forX);
        }
        Stamp rawXStamp = forX.stamp(view);
        Stamp rawYStamp = forY.stamp(view);
        if (rawXStamp instanceof IntegerStamp && rawYStamp instanceof IntegerStamp) {
            IntegerStamp xStamp = (IntegerStamp)rawXStamp;
            IntegerStamp yStamp = (IntegerStamp)rawYStamp;
            if (((xStamp.mustBeSet() ^ 0xFFFFFFFFFFFFFFFFL) & yStamp.mayBeSet()) == 0L) {
                return forX;
            }
            if (((yStamp.mustBeSet() ^ 0xFFFFFFFFFFFFFFFFL) & xStamp.mayBeSet()) == 0L) {
                return forY;
            }
        }
        if (forY.isConstant()) {
            Constant c = forY.asConstant();
            if (op.isNeutral(c)) {
                return forX;
            }
            return OrNode.reassociateMatchedValues(self != null ? self : (OrNode)new OrNode(forX, forY).maybeCommuteInputs(), ValueNode.isConstantPredicate(), forX, forY, view);
        }
        if (forX instanceof NotNode && forY instanceof NotNode) {
            return new NotNode(AndNode.create(((NotNode)forX).getValue(), ((NotNode)forY).getValue(), view));
        }
        if (forY instanceof NotNode && ((NotNode)forY).getValue() == forX) {
            return ConstantNode.forIntegerStamp(rawXStamp, -1L);
        }
        return self != null ? self : new OrNode(forX, forY).maybeCommuteInputs();
    }

    @Override
    public void generate(NodeLIRBuilderTool nodeValueMap, ArithmeticLIRGeneratorTool gen) {
        nodeValueMap.setResult(this, gen.emitOr(nodeValueMap.operand(this.getX()), nodeValueMap.operand(this.getY())));
    }
}

