/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.nodes.calc;

import jdk.graal.compiler.core.common.type.ArithmeticOpTable;
import jdk.graal.compiler.core.common.type.Stamp;
import jdk.graal.compiler.graph.NodeClass;
import jdk.graal.compiler.lir.gen.ArithmeticLIRGeneratorTool;
import jdk.graal.compiler.nodeinfo.NodeCycles;
import jdk.graal.compiler.nodeinfo.NodeInfo;
import jdk.graal.compiler.nodeinfo.NodeSize;
import jdk.graal.compiler.nodes.NodeView;
import jdk.graal.compiler.nodes.ValueNode;
import jdk.graal.compiler.nodes.calc.AddNode;
import jdk.graal.compiler.nodes.calc.BinaryArithmeticNode;
import jdk.graal.compiler.nodes.calc.NarrowableArithmeticNode;
import jdk.graal.compiler.nodes.calc.NegateNode;
import jdk.graal.compiler.nodes.calc.UnaryArithmeticNode;
import jdk.graal.compiler.nodes.spi.ArithmeticLIRLowerable;
import jdk.graal.compiler.nodes.spi.CanonicalizerTool;
import jdk.graal.compiler.nodes.spi.NodeLIRBuilderTool;
import jdk.graal.compiler.nodes.spi.StampInverter;

@NodeInfo(cycles=NodeCycles.CYCLES_1, size=NodeSize.SIZE_1)
public final class NotNode
extends UnaryArithmeticNode<ArithmeticOpTable.UnaryOp.Not>
implements ArithmeticLIRLowerable,
NarrowableArithmeticNode,
StampInverter {
    public static final NodeClass<NotNode> TYPE = NodeClass.create(NotNode.class);

    protected NotNode(ValueNode x) {
        super(TYPE, BinaryArithmeticNode.getArithmeticOpTable(x).getNot(), x);
    }

    public static ValueNode create(ValueNode x) {
        return NotNode.canonicalize(null, x);
    }

    @Override
    protected ArithmeticOpTable.UnaryOp<ArithmeticOpTable.UnaryOp.Not> getOp(ArithmeticOpTable table) {
        return table.getNot();
    }

    @Override
    public ValueNode canonical(CanonicalizerTool tool, ValueNode forValue) {
        ValueNode ret = super.canonical(tool, forValue);
        if (ret != this) {
            return ret;
        }
        return NotNode.canonicalize(this, forValue);
    }

    private static ValueNode canonicalize(NotNode node, ValueNode x) {
        AddNode addNode;
        if (x instanceof NotNode) {
            return ((NotNode)x).getValue();
        }
        if (x instanceof AddNode && (addNode = (AddNode)x).getY().isJavaConstant() && addNode.getY().asJavaConstant().asLong() == -1L) {
            return NegateNode.create(addNode.getX(), NodeView.DEFAULT);
        }
        if (node != null) {
            return node;
        }
        return new NotNode(x);
    }

    @Override
    public void generate(NodeLIRBuilderTool nodeValueMap, ArithmeticLIRGeneratorTool gen) {
        nodeValueMap.setResult(this, gen.emitNot(nodeValueMap.operand(this.getValue())));
    }

    @Override
    public Stamp invertStamp(Stamp outStamp) {
        return ((ArithmeticOpTable.UnaryOp)this.getArithmeticOp()).foldStamp(outStamp);
    }
}

