/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.nodes.calc;

import jdk.graal.compiler.core.common.calc.CanonicalCondition;
import jdk.graal.compiler.core.common.type.IntegerStamp;
import jdk.graal.compiler.core.common.type.Stamp;
import jdk.graal.compiler.debug.Assertions;
import jdk.graal.compiler.debug.GraalError;
import jdk.graal.compiler.graph.Node;
import jdk.graal.compiler.graph.NodeClass;
import jdk.graal.compiler.nodeinfo.NodeInfo;
import jdk.graal.compiler.nodes.ConstantNode;
import jdk.graal.compiler.nodes.LogicConstantNode;
import jdk.graal.compiler.nodes.LogicNegationNode;
import jdk.graal.compiler.nodes.LogicNode;
import jdk.graal.compiler.nodes.NodeView;
import jdk.graal.compiler.nodes.ValueNode;
import jdk.graal.compiler.nodes.calc.AbstractNormalizeCompareNode;
import jdk.graal.compiler.nodes.calc.AddNode;
import jdk.graal.compiler.nodes.calc.AndNode;
import jdk.graal.compiler.nodes.calc.BinaryNode;
import jdk.graal.compiler.nodes.calc.CompareNode;
import jdk.graal.compiler.nodes.calc.IntegerLowerThanNode;
import jdk.graal.compiler.nodes.calc.IntegerTestNode;
import jdk.graal.compiler.nodes.calc.LeftShiftNode;
import jdk.graal.compiler.nodes.calc.NotNode;
import jdk.graal.compiler.nodes.calc.RightShiftNode;
import jdk.graal.compiler.nodes.calc.ShiftNode;
import jdk.graal.compiler.nodes.calc.SubNode;
import jdk.graal.compiler.nodes.calc.UnsignedRightShiftNode;
import jdk.graal.compiler.nodes.calc.XorNode;
import jdk.graal.compiler.nodes.spi.Canonicalizable;
import jdk.graal.compiler.nodes.spi.CanonicalizerTool;
import jdk.graal.compiler.nodes.util.GraphUtil;
import jdk.graal.compiler.options.OptionValues;
import jdk.vm.ci.meta.Constant;
import jdk.vm.ci.meta.ConstantReflectionProvider;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.MetaAccessProvider;
import jdk.vm.ci.meta.PrimitiveConstant;
import jdk.vm.ci.meta.TriState;

@NodeInfo(shortName="==")
public final class IntegerEqualsNode
extends CompareNode
implements Canonicalizable.BinaryCommutative<ValueNode> {
    public static final NodeClass<IntegerEqualsNode> TYPE = NodeClass.create(IntegerEqualsNode.class);
    private static final IntegerEqualsOp OP = new IntegerEqualsOp();

    public IntegerEqualsNode(ValueNode x, ValueNode y) {
        super(TYPE, CanonicalCondition.EQ, false, x, y);
        Stamp xStamp = x.stamp(NodeView.DEFAULT);
        Stamp yStamp = y.stamp(NodeView.DEFAULT);
        assert (xStamp.isIntegerStamp()) : "expected integer x value: " + String.valueOf(x);
        assert (yStamp.isIntegerStamp()) : "expected integer y value: " + String.valueOf(y);
        assert (xStamp.isCompatible(yStamp)) : "expected compatible stamps: " + String.valueOf(xStamp) + " / " + String.valueOf(yStamp);
    }

    public static LogicNode create(ValueNode x, ValueNode y, NodeView view) {
        LogicNode result = IntegerEqualsNode.tryConstantFoldPrimitive(CanonicalCondition.EQ, x, y, false, view);
        if (result != null) {
            return result;
        }
        return new IntegerEqualsNode(x, y).maybeCommuteInputs();
    }

    public static LogicNode create(ConstantReflectionProvider constantReflection, MetaAccessProvider metaAccess, OptionValues options, Integer smallestCompareWidth, ValueNode x, ValueNode y, NodeView view) {
        LogicNode value = OP.canonical(constantReflection, metaAccess, options, smallestCompareWidth, CanonicalCondition.EQ, false, x, y, view);
        if (value != null) {
            return value;
        }
        return IntegerEqualsNode.create(x, y, view);
    }

    @Override
    public Node canonical(CanonicalizerTool tool, ValueNode forX, ValueNode forY) {
        NodeView view = NodeView.from(tool);
        LogicNode value = OP.canonical(tool.getConstantReflection(), tool.getMetaAccess(), tool.getOptions(), tool.smallestCompareWidth(), CanonicalCondition.EQ, false, forX, forY, view);
        if (value != null) {
            return value;
        }
        return super.canonical(tool, forX, forY);
    }

    @Override
    public Stamp getSucceedingStampForX(boolean negated, Stamp xStamp, Stamp yStamp) {
        if (!negated) {
            return xStamp.join(yStamp);
        }
        return null;
    }

    @Override
    public Stamp getSucceedingStampForY(boolean negated, Stamp xStamp, Stamp yStamp) {
        if (!negated) {
            return xStamp.join(yStamp);
        }
        return null;
    }

    @Override
    public TriState tryFold(Stamp xStampGeneric, Stamp yStampGeneric) {
        if (xStampGeneric instanceof IntegerStamp && yStampGeneric instanceof IntegerStamp) {
            IntegerStamp xStamp = (IntegerStamp)xStampGeneric;
            IntegerStamp yStamp = (IntegerStamp)yStampGeneric;
            if (xStamp.alwaysDistinct(yStamp)) {
                return TriState.FALSE;
            }
            if (xStamp.neverDistinct(yStamp)) {
                return TriState.TRUE;
            }
        }
        return TriState.UNKNOWN;
    }

    @Override
    public TriState implies(boolean thisNegated, LogicNode other) {
        if (!thisNegated && other instanceof IntegerLowerThanNode) {
            ValueNode otherX = ((IntegerLowerThanNode)other).getX();
            ValueNode otherY = ((IntegerLowerThanNode)other).getY();
            if (this.getX() == otherX && this.getY() == otherY || this.getX() == otherY && this.getY() == otherX) {
                return TriState.FALSE;
            }
        }
        return super.implies(thisNegated, other);
    }

    public static class IntegerEqualsOp
    extends CompareNode.CompareOp {
        @Override
        protected LogicNode optimizeNormalizeCompare(ConstantReflectionProvider constantReflection, MetaAccessProvider metaAccess, OptionValues options, Integer smallestCompareWidth, Constant constant, AbstractNormalizeCompareNode normalizeNode, boolean mirrored, NodeView view) {
            PrimitiveConstant primitive = (PrimitiveConstant)constant;
            long cst = primitive.asLong();
            if (cst == 0L) {
                return normalizeNode.createEqualComparison(constantReflection, metaAccess, options, smallestCompareWidth, view);
            }
            if (cst == 1L) {
                return normalizeNode.createLowerComparison(true, constantReflection, metaAccess, options, smallestCompareWidth, view);
            }
            if (cst == -1L) {
                return normalizeNode.createLowerComparison(false, constantReflection, metaAccess, options, smallestCompareWidth, view);
            }
            return LogicConstantNode.contradiction();
        }

        @Override
        protected LogicNode duplicateModified(ValueNode newX, ValueNode newY, boolean unorderedIsTrue, NodeView view) {
            if (newX.stamp(view) instanceof IntegerStamp && newY.stamp(view) instanceof IntegerStamp) {
                return IntegerEqualsNode.create(newX, newY, view);
            }
            throw GraalError.shouldNotReachHere(String.valueOf(newX.stamp(view)) + " " + String.valueOf(newY.stamp(view)));
        }

        @Override
        public LogicNode canonical(ConstantReflectionProvider constantReflection, MetaAccessProvider metaAccess, OptionValues options, Integer smallestCompareWidth, CanonicalCondition condition, boolean unorderedIsTrue, ValueNode forX, ValueNode forY, NodeView view) {
            NotNode notX;
            NotNode notY;
            SubNode subNode;
            BinaryNode binaryNode;
            ValueNode v2;
            ValueNode v1;
            if (GraphUtil.unproxify(forX) == GraphUtil.unproxify(forY)) {
                return LogicConstantNode.tautology();
            }
            if (forX.stamp(view).alwaysDistinct(forY.stamp(view))) {
                return LogicConstantNode.contradiction();
            }
            if (forX instanceof AddNode && forY instanceof AddNode || forX instanceof XorNode && forY instanceof XorNode) {
                BinaryNode addX = (BinaryNode)forX;
                BinaryNode addY = (BinaryNode)forY;
                v1 = null;
                v2 = null;
                if (addX.getX() == addY.getX()) {
                    v1 = addX.getY();
                    v2 = addY.getY();
                } else if (addX.getX() == addY.getY()) {
                    v1 = addX.getY();
                    v2 = addY.getX();
                } else if (addX.getY() == addY.getX()) {
                    v1 = addX.getX();
                    v2 = addY.getY();
                } else if (addX.getY() == addY.getY()) {
                    v1 = addX.getX();
                    v2 = addY.getX();
                }
                if (v1 != null) {
                    assert (v2 != null);
                    return IntegerEqualsNode.create(v1, v2, view);
                }
            }
            if (forX instanceof SubNode && forY instanceof SubNode) {
                SubNode subX = (SubNode)forX;
                SubNode subY = (SubNode)forY;
                v1 = null;
                v2 = null;
                if (subX.getX() == subY.getX()) {
                    v1 = subX.getY();
                    v2 = subY.getY();
                } else if (subX.getY() == subY.getY()) {
                    v1 = subX.getX();
                    v2 = subY.getX();
                }
                if (v1 != null) {
                    assert (v2 != null);
                    return IntegerEqualsNode.create(v1, v2, view);
                }
            }
            if (forX instanceof AddNode || forX instanceof XorNode) {
                binaryNode = (BinaryNode)forX;
                if (binaryNode.getX() == forY) {
                    return IntegerEqualsNode.create(binaryNode.getY(), ConstantNode.forIntegerStamp(view.stamp(binaryNode), 0L), view);
                }
                if (binaryNode.getY() == forY) {
                    return IntegerEqualsNode.create(binaryNode.getX(), ConstantNode.forIntegerStamp(view.stamp(binaryNode), 0L), view);
                }
            }
            if (forY instanceof AddNode || forY instanceof XorNode) {
                binaryNode = (BinaryNode)forY;
                if (binaryNode.getX() == forX) {
                    return IntegerEqualsNode.create(binaryNode.getY(), ConstantNode.forIntegerStamp(view.stamp(binaryNode), 0L), view);
                }
                if (binaryNode.getY() == forX) {
                    return IntegerEqualsNode.create(binaryNode.getX(), ConstantNode.forIntegerStamp(view.stamp(binaryNode), 0L), view);
                }
            }
            if (forX instanceof SubNode && (subNode = (SubNode)forX).getX() == forY) {
                return IntegerEqualsNode.create(subNode.getY(), ConstantNode.forIntegerStamp(view.stamp(subNode), 0L), view);
            }
            if (forY instanceof SubNode && forX == (subNode = (SubNode)forY).getX()) {
                return IntegerEqualsNode.create(subNode.getY(), ConstantNode.forIntegerStamp(view.stamp(subNode), 0L), view);
            }
            if (forX instanceof NotNode && (notY = (NotNode)forX).getValue() == forY) {
                return LogicConstantNode.contradiction();
            }
            if (forY instanceof NotNode && forX == (notX = (NotNode)forY).getValue()) {
                return LogicConstantNode.contradiction();
            }
            return super.canonical(constantReflection, metaAccess, options, smallestCompareWidth, condition, unorderedIsTrue, forX, forY, view);
        }

        @Override
        protected LogicNode canonicalizeSymmetricConstant(ConstantReflectionProvider constantReflection, MetaAccessProvider metaAccess, OptionValues options, Integer smallestCompareWidth, CanonicalCondition condition, Constant constant, ValueNode nonConstant, boolean mirrored, boolean unorderedIsTrue, NodeView view) {
            if (constant instanceof PrimitiveConstant) {
                XorNode xorNode;
                AddNode addNode;
                PrimitiveConstant primitiveConstant = (PrimitiveConstant)constant;
                IntegerStamp nonConstantStamp = (IntegerStamp)nonConstant.stamp(view);
                if (primitiveConstant.asLong() == 1L && nonConstantStamp.upperBound() == 1L && nonConstantStamp.lowerBound() == 0L || primitiveConstant.asLong() == -1L && nonConstantStamp.upperBound() == 0L && nonConstantStamp.lowerBound() == -1L) {
                    return LogicNegationNode.create(IntegerEqualsNode.create(constantReflection, metaAccess, options, smallestCompareWidth, nonConstant, ConstantNode.forIntegerStamp(nonConstantStamp, 0L), view));
                }
                if (primitiveConstant.asLong() == 0L) {
                    if (nonConstant instanceof AndNode) {
                        AndNode andNode = (AndNode)nonConstant;
                        return new IntegerTestNode(andNode.getX(), andNode.getY());
                    }
                    if (nonConstant instanceof SubNode || nonConstant instanceof XorNode) {
                        BinaryNode binaryNode = (BinaryNode)nonConstant;
                        return IntegerEqualsNode.create(constantReflection, metaAccess, options, smallestCompareWidth, binaryNode.getX(), binaryNode.getY(), view);
                    }
                    if (nonConstant instanceof ShiftNode && nonConstant.stamp(view) instanceof IntegerStamp) {
                        ShiftNode shift;
                        if (nonConstant instanceof LeftShiftNode) {
                            shift = (LeftShiftNode)nonConstant;
                            if (shift.getY().isConstant()) {
                                int mask = shift.getShiftAmountMask();
                                int amount = shift.getY().asJavaConstant().asInt() & mask;
                                if (shift.getX().getStackKind() == JavaKind.Int) {
                                    return new IntegerTestNode(shift.getX(), ConstantNode.forInt(-1 >>> amount));
                                }
                                assert (shift.getX().getStackKind() == JavaKind.Long) : Assertions.errorMessage(shift, shift.getX(), shift.getY());
                                return new IntegerTestNode(shift.getX(), ConstantNode.forLong(-1L >>> amount));
                            }
                        } else if (nonConstant instanceof RightShiftNode) {
                            shift = (RightShiftNode)nonConstant;
                            if (shift.getY().isConstant() && ((IntegerStamp)shift.getX().stamp(view)).isPositive()) {
                                int mask = shift.getShiftAmountMask();
                                int amount = shift.getY().asJavaConstant().asInt() & mask;
                                if (shift.getX().getStackKind() == JavaKind.Int) {
                                    return new IntegerTestNode(shift.getX(), ConstantNode.forInt(-1 << amount));
                                }
                                assert (shift.getX().getStackKind() == JavaKind.Long) : Assertions.errorMessage(shift, shift.getX(), shift.getY());
                                return new IntegerTestNode(shift.getX(), ConstantNode.forLong(-1L << amount));
                            }
                        } else if (nonConstant instanceof UnsignedRightShiftNode && (shift = (UnsignedRightShiftNode)nonConstant).getY().isConstant()) {
                            int mask = shift.getShiftAmountMask();
                            int amount = shift.getY().asJavaConstant().asInt() & mask;
                            if (shift.getX().getStackKind() == JavaKind.Int) {
                                return new IntegerTestNode(shift.getX(), ConstantNode.forInt(-1 << amount));
                            }
                            assert (shift.getX().getStackKind() == JavaKind.Long) : Assertions.errorMessage(shift, shift.getX(), shift.getY());
                            return new IntegerTestNode(shift.getX(), ConstantNode.forLong(-1L << amount));
                        }
                    }
                }
                if (nonConstant instanceof AddNode && (addNode = (AddNode)nonConstant).getY().isJavaConstant()) {
                    return new IntegerEqualsNode(addNode.getX(), ConstantNode.forIntegerStamp(nonConstantStamp, primitiveConstant.asLong() - addNode.getY().asJavaConstant().asLong()));
                }
                if (nonConstant instanceof AndNode) {
                    AndNode andNode = (AndNode)nonConstant;
                    if (Long.bitCount(((PrimitiveConstant)constant).asLong()) == 1 && andNode.getY().isConstant() && andNode.getY().asJavaConstant().equals((Object)constant)) {
                        return LogicNegationNode.create(new IntegerTestNode(andNode.getX(), andNode.getY()));
                    }
                }
                if (nonConstant instanceof XorNode && nonConstant.stamp(view) instanceof IntegerStamp && (xorNode = (XorNode)nonConstant).getY().isJavaConstant() && xorNode.getY().asJavaConstant().asLong() == 1L && ((IntegerStamp)xorNode.getX().stamp(view)).mayBeSet() == 1L) {
                    return new IntegerEqualsNode(xorNode.getX(), ConstantNode.forIntegerStamp(xorNode.getX().stamp(view), primitiveConstant.asLong() ^ 1L));
                }
            }
            return super.canonicalizeSymmetricConstant(constantReflection, metaAccess, options, smallestCompareWidth, condition, constant, nonConstant, mirrored, unorderedIsTrue, view);
        }
    }
}

