/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.nodes.calc;

import jdk.graal.compiler.core.common.type.IntegerStamp;
import jdk.graal.compiler.core.common.type.Stamp;
import jdk.graal.compiler.graph.IterableNodeType;
import jdk.graal.compiler.graph.Node;
import jdk.graal.compiler.graph.NodeClass;
import jdk.graal.compiler.nodeinfo.InputType;
import jdk.graal.compiler.nodeinfo.NodeCycles;
import jdk.graal.compiler.nodeinfo.NodeInfo;
import jdk.graal.compiler.nodeinfo.NodeSize;
import jdk.graal.compiler.nodes.NodeView;
import jdk.graal.compiler.nodes.ValueNode;
import jdk.graal.compiler.nodes.calc.FixedBinaryNode;
import jdk.graal.compiler.nodes.extended.GuardingNode;
import jdk.graal.compiler.nodes.spi.Lowerable;
import jdk.vm.ci.meta.JavaConstant;

@NodeInfo(allowedUsageTypes={InputType.Guard}, cycles=NodeCycles.CYCLES_32, size=NodeSize.SIZE_1)
public abstract class IntegerDivRemNode
extends FixedBinaryNode
implements Lowerable,
IterableNodeType,
GuardingNode {
    public static final NodeClass<IntegerDivRemNode> TYPE = NodeClass.create(IntegerDivRemNode.class);
    @Node.OptionalInput(value=InputType.Guard)
    private GuardingNode zeroGuard;
    private final Op op;
    private final Type type;
    private boolean canDeopt;
    protected JavaConstant deoptReasonAndAction;
    protected JavaConstant deoptSpeculation;

    protected IntegerDivRemNode(NodeClass<? extends IntegerDivRemNode> c, Stamp stamp, Op op, Type type, ValueNode dividend, ValueNode divisor, GuardingNode zeroGuard) {
        super(c, stamp, dividend, divisor);
        this.zeroGuard = zeroGuard;
        this.op = op;
        this.type = type;
        this.canDeopt = this.calculateCanDeoptimize();
    }

    public final GuardingNode getZeroGuard() {
        return this.zeroGuard;
    }

    public void setZeroGuard(GuardingNode zeroCheck) {
        this.updateUsagesInterface(this.zeroGuard, zeroCheck);
        this.zeroGuard = zeroCheck;
    }

    public final Op getOp() {
        return this.op;
    }

    public final Type getType() {
        return this.type;
    }

    private boolean calculateCanDeoptimize() {
        IntegerStamp yStamp = (IntegerStamp)this.getY().stamp(NodeView.DEFAULT);
        return yStamp.contains(0L) && this.zeroGuard == null || yStamp.contains(-1L);
    }

    public boolean canFloat() {
        return false;
    }

    public void setCanDeopt(boolean canDeopt) {
        this.canDeopt = canDeopt;
    }

    @Override
    public boolean canDeoptimize() {
        this.canDeopt = this.canDeopt && this.calculateCanDeoptimize();
        return this.canDeopt;
    }

    public JavaConstant getDeoptReasonAndAction() {
        return this.deoptReasonAndAction;
    }

    public JavaConstant getDeoptSpeculation() {
        return this.deoptSpeculation;
    }

    public void setImplicitDeoptimization(JavaConstant deoptReasonAndAction, JavaConstant deoptSpeculation) {
        assert (deoptReasonAndAction != null);
        assert (deoptSpeculation != null);
        this.deoptReasonAndAction = deoptReasonAndAction;
        this.deoptSpeculation = deoptSpeculation;
    }

    public static enum Op {
        DIV,
        REM;

    }

    public static enum Type {
        SIGNED,
        UNSIGNED;

    }
}

