/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.nodes.calc;

import jdk.graal.compiler.core.common.NumUtil;
import jdk.graal.compiler.core.common.calc.CanonicalCondition;
import jdk.graal.compiler.core.common.type.IntegerStamp;
import jdk.graal.compiler.core.common.type.Stamp;
import jdk.graal.compiler.core.common.type.StampFactory;
import jdk.graal.compiler.debug.Assertions;
import jdk.graal.compiler.graph.Node;
import jdk.graal.compiler.graph.NodeClass;
import jdk.graal.compiler.nodeinfo.NodeInfo;
import jdk.graal.compiler.nodes.LogicConstantNode;
import jdk.graal.compiler.nodes.LogicNegationNode;
import jdk.graal.compiler.nodes.LogicNode;
import jdk.graal.compiler.nodes.NodeView;
import jdk.graal.compiler.nodes.ValueNode;
import jdk.graal.compiler.nodes.calc.AbstractNormalizeCompareNode;
import jdk.graal.compiler.nodes.calc.AddNode;
import jdk.graal.compiler.nodes.calc.ConditionalNode;
import jdk.graal.compiler.nodes.calc.IntegerLessThanNode;
import jdk.graal.compiler.nodes.calc.IntegerLowerThanNode;
import jdk.graal.compiler.nodes.calc.SubNode;
import jdk.graal.compiler.nodes.calc.ZeroExtendNode;
import jdk.graal.compiler.nodes.spi.CanonicalizerTool;
import jdk.graal.compiler.options.OptionValues;
import jdk.vm.ci.code.CodeUtil;
import jdk.vm.ci.meta.Constant;
import jdk.vm.ci.meta.ConstantReflectionProvider;
import jdk.vm.ci.meta.MetaAccessProvider;
import jdk.vm.ci.meta.PrimitiveConstant;
import jdk.vm.ci.meta.TriState;

@NodeInfo(shortName="|<|")
public final class IntegerBelowNode
extends IntegerLowerThanNode {
    public static final NodeClass<IntegerBelowNode> TYPE = NodeClass.create(IntegerBelowNode.class);
    private static final BelowOp OP = new BelowOp();

    public IntegerBelowNode(ValueNode x, ValueNode y) {
        super(TYPE, x, y, OP);
        Stamp xStamp = x.stamp(NodeView.DEFAULT);
        Stamp yStamp = y.stamp(NodeView.DEFAULT);
        assert (xStamp.isIntegerStamp()) : "expected integer x value: " + String.valueOf(x);
        assert (yStamp.isIntegerStamp()) : "expected integer y value: " + String.valueOf(y);
        assert (xStamp.isCompatible(yStamp)) : "expected compatible stamps: " + String.valueOf(xStamp) + " / " + String.valueOf(yStamp);
    }

    public static LogicNode create(ValueNode x, ValueNode y, NodeView view) {
        return OP.create(x, y, view);
    }

    public static LogicNode create(ConstantReflectionProvider constantReflection, MetaAccessProvider metaAccess, OptionValues options, Integer smallestCompareWidth, ValueNode x, ValueNode y, NodeView view) {
        LogicNode value = OP.canonical(constantReflection, metaAccess, options, smallestCompareWidth, OP.getCondition(), false, x, y, view);
        if (value != null) {
            return value;
        }
        return IntegerBelowNode.create(x, y, view);
    }

    @Override
    public Node canonical(CanonicalizerTool tool, ValueNode forX, ValueNode forY) {
        NodeView view = NodeView.from(tool);
        LogicNode value = OP.canonical(tool.getConstantReflection(), tool.getMetaAccess(), tool.getOptions(), tool.smallestCompareWidth(), OP.getCondition(), false, forX, forY, view);
        if (value != null) {
            return value;
        }
        return this;
    }

    @Override
    public TriState implies(boolean thisNegated, LogicNode other) {
        TriState result;
        if (other instanceof LogicNegationNode && (result = this.implies(thisNegated, ((LogicNegationNode)other).getValue())).isKnown()) {
            return TriState.get((!result.toBoolean() ? 1 : 0) != 0);
        }
        if (!thisNegated && other instanceof IntegerLessThanNode) {
            IntegerLessThanNode integerLessThanNode = (IntegerLessThanNode)other;
            IntegerStamp stampL = (IntegerStamp)this.getY().stamp(NodeView.DEFAULT);
            if (stampL.isPositive() && this.getX() == integerLessThanNode.getX()) {
                if (this.getY() == integerLessThanNode.getY()) {
                    return TriState.TRUE;
                }
                if (integerLessThanNode.getY().isConstant() && IntegerStamp.OPS.getAdd().isNeutral(integerLessThanNode.getY().asConstant())) {
                    return TriState.FALSE;
                }
            }
        }
        return super.implies(thisNegated, other);
    }

    public static class BelowOp
    extends IntegerLowerThanNode.LowerOp {
        @Override
        protected LogicNode duplicateModified(ValueNode newX, ValueNode newY, boolean unorderedIsTrue, NodeView view) {
            assert (newX.stamp(NodeView.DEFAULT) instanceof IntegerStamp) : Assertions.errorMessageContext("newX", newX);
            assert (newY.stamp(NodeView.DEFAULT) instanceof IntegerStamp) : Assertions.errorMessageContext("newY", newY);
            return IntegerBelowNode.create(newX, newY, view);
        }

        @Override
        protected LogicNode optimizeNormalizeCompare(ConstantReflectionProvider constantReflection, MetaAccessProvider metaAccess, OptionValues options, Integer smallestCompareWidth, Constant constant, AbstractNormalizeCompareNode normalizeNode, boolean mirrored, NodeView view) {
            PrimitiveConstant primitive = (PrimitiveConstant)constant;
            long c = primitive.asLong();
            if (mirrored) {
                if (c == -1L) {
                    return LogicConstantNode.contradiction();
                }
                if (c == 0L) {
                    LogicNode equal = normalizeNode.createEqualComparison(constantReflection, metaAccess, options, smallestCompareWidth, view);
                    return LogicNegationNode.create(equal);
                }
                return normalizeNode.createLowerComparison(constantReflection, metaAccess, options, smallestCompareWidth, view);
            }
            if (c == 0L) {
                return LogicConstantNode.contradiction();
            }
            if (c == 1L) {
                return normalizeNode.createEqualComparison(constantReflection, metaAccess, options, smallestCompareWidth, view);
            }
            LogicNode compare = normalizeNode.createLowerComparison(constantReflection, metaAccess, options, smallestCompareWidth, view);
            return LogicNegationNode.create(compare);
        }

        @Override
        protected LogicNode findSynonym(ValueNode forX, ValueNode forY, NodeView view) {
            LogicNode result = super.findSynonym(forX, forY, view);
            if (result != null) {
                return result;
            }
            if (forX.stamp(view) instanceof IntegerStamp) {
                assert (forY.stamp(view) instanceof IntegerStamp) : Assertions.errorMessageContext("this", this, "forX", forX, "forY", forY);
                IntegerStamp xStamp = (IntegerStamp)forX.stamp(view);
                IntegerStamp yStamp = (IntegerStamp)forY.stamp(view);
                int bits = xStamp.getBits();
                assert (yStamp.getBits() == bits) : Assertions.errorMessageContext("this", this, "yStamp", yStamp);
                LogicNode logic = BelowOp.canonicalizeRangeFlip(forX, forY, bits, false, view);
                if (logic != null) {
                    return logic;
                }
                if (xStamp.isPositive() && forY instanceof ConditionalNode && ((ConditionalNode)forY).condition() instanceof IntegerBelowNode && (logic = BelowOp.canonicalizeBelowCanonicalOfBelow(forX, (ConditionalNode)forY, view)) != null) {
                    return logic;
                }
            }
            return null;
        }

        private static LogicNode canonicalizeBelowCanonicalOfBelow(ValueNode forX, ConditionalNode forY, NodeView view) {
            AddNode add;
            IntegerBelowNode below = (IntegerBelowNode)forY.condition();
            ValueNode n = below.getX();
            if (((IntegerStamp)n.stamp(view)).isPositive() && forY.trueValue().isDefaultConstant() && below.getY().isJavaConstant() && forY.falseValue() instanceof AddNode && (add = (AddNode)forY.falseValue()).getX() == below.getX() && add.getY().isJavaConstant() && add.getY().asJavaConstant().asLong() < 0L && add.getY().asJavaConstant().asLong() == -below.getY().asJavaConstant().asLong()) {
                ValueNode c = below.getY();
                return IntegerLessThanNode.create(forX, SubNode.create(n, c, view), view);
            }
            return null;
        }

        @Override
        protected boolean isMatchingBitExtendNode(ValueNode node) {
            return node instanceof ZeroExtendNode;
        }

        @Override
        protected boolean addCanOverflow(IntegerStamp a, IntegerStamp b) {
            assert (a.getBits() == b.getBits()) : Assertions.errorMessageContext("a", a, "b", b);
            if (a.getBits() == 64) {
                return Long.compareUnsigned(this.upperBound(a) + this.upperBound(b), this.upperBound(a)) < 0;
            }
            if (a.getBits() == 32) {
                return Integer.compareUnsigned((int)this.upperBound(a) + (int)this.upperBound(b), (int)this.upperBound(a)) < 0;
            }
            return true;
        }

        @Override
        protected boolean leftShiftCanOverflow(IntegerStamp a, long shift) {
            int leadingZeroForBits = Long.numberOfLeadingZeros(a.mayBeSet()) - (64 - a.getBits());
            return (long)leadingZeroForBits < shift;
        }

        @Override
        protected long upperBound(IntegerStamp stamp) {
            return stamp.unsignedUpperBound();
        }

        @Override
        protected long lowerBound(IntegerStamp stamp) {
            return stamp.unsignedLowerBound();
        }

        @Override
        protected int compare(long a, long b) {
            return Long.compareUnsigned(a, b);
        }

        @Override
        protected long min(long a, long b) {
            return NumUtil.minUnsigned(a, b);
        }

        @Override
        protected long max(long a, long b) {
            return NumUtil.maxUnsigned(a, b);
        }

        @Override
        protected long cast(long a, int bits) {
            return CodeUtil.zeroExtend((long)a, (int)bits);
        }

        @Override
        protected long minValue(int bits) {
            return 0L;
        }

        @Override
        protected long maxValue(int bits) {
            return NumUtil.maxValueUnsigned(bits);
        }

        @Override
        protected IntegerStamp forInteger(int bits, long min, long max) {
            return StampFactory.forUnsignedInteger(bits, min, max);
        }

        @Override
        protected CanonicalCondition getCondition() {
            return CanonicalCondition.BT;
        }

        @Override
        protected IntegerLowerThanNode createNode(ValueNode x, ValueNode y) {
            return new IntegerBelowNode(x, y);
        }
    }
}

