/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.nodes.calc;

import jdk.graal.compiler.core.common.type.ArithmeticOpTable;
import jdk.graal.compiler.core.common.type.Stamp;
import jdk.graal.compiler.debug.Assertions;
import jdk.graal.compiler.graph.NodeClass;
import jdk.graal.compiler.lir.gen.ArithmeticLIRGeneratorTool;
import jdk.graal.compiler.nodeinfo.NodeCycles;
import jdk.graal.compiler.nodeinfo.NodeInfo;
import jdk.graal.compiler.nodeinfo.NodeSize;
import jdk.graal.compiler.nodes.ConstantNode;
import jdk.graal.compiler.nodes.NodeView;
import jdk.graal.compiler.nodes.ValueNode;
import jdk.graal.compiler.nodes.calc.BinaryArithmeticNode;
import jdk.graal.compiler.nodes.calc.TernaryArithmeticNode;
import jdk.graal.compiler.nodes.spi.CanonicalizerTool;
import jdk.graal.compiler.nodes.spi.NodeLIRBuilderTool;
import jdk.graal.compiler.serviceprovider.GraalServices;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.JavaKind;

@NodeInfo(cycles=NodeCycles.CYCLES_2, size=NodeSize.SIZE_1)
public final class FusedMultiplyAddNode
extends TernaryArithmeticNode<ArithmeticOpTable.TernaryOp.FMA> {
    public static final NodeClass<FusedMultiplyAddNode> TYPE = NodeClass.create(FusedMultiplyAddNode.class);

    public FusedMultiplyAddNode(ValueNode x, ValueNode y, ValueNode z) {
        super(TYPE, BinaryArithmeticNode.getArithmeticOpTable(x).getFMA(), x, y, z);
        assert (x.stamp(NodeView.DEFAULT).isFloatStamp());
        assert (y.stamp(NodeView.DEFAULT).isFloatStamp());
        assert (z.stamp(NodeView.DEFAULT).isFloatStamp());
    }

    public static ValueNode create(ValueNode x, ValueNode y, ValueNode z, NodeView view) {
        Stamp stamp;
        ArithmeticOpTable.TernaryOp<ArithmeticOpTable.TernaryOp.FMA> op = ArithmeticOpTable.forStamp(x.stamp(view)).getFMA();
        ConstantNode tryConstantFold = FusedMultiplyAddNode.tryConstantFold(op, x, y, z, stamp = op.foldStamp(x.stamp(view), y.stamp(view), z.stamp(view)));
        if (tryConstantFold != null) {
            return tryConstantFold;
        }
        return new FusedMultiplyAddNode(x, y, z);
    }

    @Override
    protected ArithmeticOpTable.TernaryOp<ArithmeticOpTable.TernaryOp.FMA> getOp(ArithmeticOpTable table) {
        return table.getFMA();
    }

    @Override
    public ValueNode canonical(CanonicalizerTool tool, ValueNode forX, ValueNode forY, ValueNode forZ) {
        if (forX.isConstant() && forY.isConstant() && forZ.isConstant()) {
            JavaConstant constantX = forX.asJavaConstant();
            JavaConstant constantY = forY.asJavaConstant();
            JavaConstant constantZ = forZ.asJavaConstant();
            if (forX.getStackKind() == JavaKind.Float) {
                return ConstantNode.forFloat(GraalServices.fma(constantX.asFloat(), constantY.asFloat(), constantZ.asFloat()));
            }
            assert (forX.getStackKind() == JavaKind.Double) : Assertions.errorMessage(forX, forY, forZ);
            return ConstantNode.forDouble(GraalServices.fma(constantX.asDouble(), constantY.asDouble(), constantZ.asDouble()));
        }
        return this;
    }

    @Override
    public void generate(NodeLIRBuilderTool builder, ArithmeticLIRGeneratorTool gen) {
        builder.setResult(this, gen.emitFusedMultiplyAdd(builder.operand(this.getX()), builder.operand(this.getY()), builder.operand(this.getZ())));
    }
}

