/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.nodes.calc;

import jdk.graal.compiler.core.common.type.ArithmeticOpTable;
import jdk.graal.compiler.core.common.type.IntegerStamp;
import jdk.graal.compiler.debug.GraalError;
import jdk.graal.compiler.graph.IterableNodeType;
import jdk.graal.compiler.graph.Node;
import jdk.graal.compiler.graph.NodeClass;
import jdk.graal.compiler.nodeinfo.InputType;
import jdk.graal.compiler.nodeinfo.NodeCycles;
import jdk.graal.compiler.nodeinfo.NodeInfo;
import jdk.graal.compiler.nodeinfo.NodeSize;
import jdk.graal.compiler.nodes.AbstractBeginNode;
import jdk.graal.compiler.nodes.FixedGuardNode;
import jdk.graal.compiler.nodes.GraphState;
import jdk.graal.compiler.nodes.GuardNode;
import jdk.graal.compiler.nodes.IfNode;
import jdk.graal.compiler.nodes.NodeView;
import jdk.graal.compiler.nodes.ValueNode;
import jdk.graal.compiler.nodes.calc.BinaryArithmeticNode;
import jdk.graal.compiler.nodes.calc.SignedDivNode;
import jdk.graal.compiler.nodes.extended.GuardedNode;
import jdk.graal.compiler.nodes.extended.GuardingNode;
import jdk.graal.compiler.nodes.spi.Lowerable;

@NodeInfo(cycles=NodeCycles.CYCLES_32, size=NodeSize.SIZE_1)
public abstract class FloatingIntegerDivRemNode<OP>
extends BinaryArithmeticNode<OP>
implements IterableNodeType,
GuardedNode,
Lowerable {
    public static final NodeClass<FloatingIntegerDivRemNode> TYPE = NodeClass.create(FloatingIntegerDivRemNode.class);
    @Node.OptionalInput(value=InputType.Guard)
    protected GuardingNode floatingGuard;
    private boolean divisionOverflowIsJVMSCompliant;

    protected FloatingIntegerDivRemNode(NodeClass<? extends FloatingIntegerDivRemNode<OP>> c, ArithmeticOpTable.BinaryOp<OP> op, ValueNode x, ValueNode y, GuardingNode floatingGuard) {
        super(c, op, x, y);
        this.floatingGuard = floatingGuard;
    }

    protected FloatingIntegerDivRemNode(NodeClass<? extends FloatingIntegerDivRemNode<OP>> c, ArithmeticOpTable.BinaryOp<OP> op, ValueNode x, ValueNode y, GuardingNode floatingGuard, boolean divisionOverflowIsJVMSCompliant) {
        super(c, op, x, y);
        this.floatingGuard = floatingGuard;
        this.divisionOverflowIsJVMSCompliant = divisionOverflowIsJVMSCompliant;
    }

    @Override
    public GuardingNode getGuard() {
        return this.floatingGuard;
    }

    public void setDivisionOverflowIsJVMSCompliant() {
        this.divisionOverflowIsJVMSCompliant = true;
    }

    public boolean divisionOverflowIsJVMSCompliant() {
        return this.divisionOverflowIsJVMSCompliant;
    }

    @Override
    public void setGuard(GuardingNode guard) {
        this.updateUsagesInterface(this.floatingGuard, guard);
        this.floatingGuard = guard;
    }

    protected boolean canDivideByZero() {
        IntegerStamp yStamp = (IntegerStamp)this.y.stamp(NodeView.DEFAULT);
        return yStamp.contains(0L);
    }

    private boolean overflowVisibleSideEffect() {
        return !SignedDivNode.divisionIsJVMSCompliant(this.x, this.y, this.divisionOverflowIsJVMSCompliant);
    }

    @Override
    public boolean verifyNode() {
        boolean guardWillAlwaysDeopt = false;
        if (this.getGuard() != null) {
            IfNode ifGuard;
            AbstractBeginNode abn;
            GuardingNode guard = this.getGuard();
            if (guard instanceof GuardNode && ((GuardNode)guard).willDeoptUnconditionally()) {
                guardWillAlwaysDeopt = true;
            } else if (guard instanceof FixedGuardNode && ((FixedGuardNode)guard).willDeoptUnconditionally()) {
                guardWillAlwaysDeopt = true;
            } else if (guard instanceof AbstractBeginNode && (abn = (AbstractBeginNode)guard).predecessor() instanceof IfNode && (ifGuard = (IfNode)abn.predecessor()).successorWillBeEliminated(abn)) {
                guardWillAlwaysDeopt = true;
            }
        }
        boolean cannotDeopt = !this.canDivideByZero() && !this.overflowVisibleSideEffect();
        boolean isAfterStage = this.graph().isAfterStage(GraphState.StageFlag.FIXED_READS);
        GraalError.guarantee(guardWillAlwaysDeopt || cannotDeopt || isAfterStage, "Floating irem must never create an exception or trap");
        return super.verifyNode();
    }
}

