/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.nodes.calc;

import jdk.graal.compiler.core.common.type.StampFactory;
import jdk.graal.compiler.debug.GraalError;
import jdk.graal.compiler.graph.Node;
import jdk.graal.compiler.graph.NodeClass;
import jdk.graal.compiler.lir.gen.ArithmeticLIRGeneratorTool;
import jdk.graal.compiler.nodeinfo.NodeCycles;
import jdk.graal.compiler.nodeinfo.NodeInfo;
import jdk.graal.compiler.nodeinfo.NodeSize;
import jdk.graal.compiler.nodes.ConstantNode;
import jdk.graal.compiler.nodes.ValueNode;
import jdk.graal.compiler.nodes.calc.UnaryNode;
import jdk.graal.compiler.nodes.spi.ArithmeticLIRLowerable;
import jdk.graal.compiler.nodes.spi.CanonicalizerTool;
import jdk.graal.compiler.nodes.spi.NodeLIRBuilderTool;
import jdk.vm.ci.meta.JavaKind;

@NodeInfo(cycles=NodeCycles.CYCLES_2, size=NodeSize.SIZE_1)
public final class FloatTypeTestNode
extends UnaryNode
implements ArithmeticLIRLowerable {
    public static final NodeClass<FloatTypeTestNode> TYPE = NodeClass.create(FloatTypeTestNode.class);
    private final FloatTypeTestOp op;

    public FloatTypeTestNode(ValueNode value, FloatTypeTestOp op) {
        super(TYPE, StampFactory.forKind(JavaKind.Boolean), value);
        GraalError.guarantee(value.getStackKind().isNumericFloat(), "float type test on incompatible value %s", (Object)value);
        this.op = op;
    }

    @Override
    public Node canonical(CanonicalizerTool tool, ValueNode forValue) {
        switch (forValue.getStackKind()) {
            case Float: {
                if (!forValue.isJavaConstant()) break;
                switch (this.op.ordinal()) {
                    case 1: {
                        return ConstantNode.forBoolean(Float.isFinite(forValue.asJavaConstant().asFloat()));
                    }
                    case 0: {
                        return ConstantNode.forBoolean(Float.isInfinite(forValue.asJavaConstant().asFloat()));
                    }
                }
                break;
            }
            case Double: {
                if (!forValue.isJavaConstant()) break;
                switch (this.op.ordinal()) {
                    case 1: {
                        return ConstantNode.forBoolean(Double.isFinite(forValue.asJavaConstant().asDouble()));
                    }
                    case 0: {
                        return ConstantNode.forBoolean(Double.isInfinite(forValue.asJavaConstant().asDouble()));
                    }
                }
                break;
            }
            default: {
                throw GraalError.shouldNotReachHere("incompatible value " + String.valueOf(forValue));
            }
        }
        return this;
    }

    @Override
    public void generate(NodeLIRBuilderTool nodeValueMap, ArithmeticLIRGeneratorTool gen) {
        switch (this.op.ordinal()) {
            case 0: {
                nodeValueMap.setResult(this, gen.emitFloatIsInfinite(nodeValueMap.operand(this.getValue())));
                break;
            }
            default: {
                throw GraalError.shouldNotReachHere("unimplemented float type test op " + String.valueOf((Object)this.op));
            }
        }
    }

    public static enum FloatTypeTestOp {
        IS_INFINITE,
        IS_FINITE;

    }
}

