/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.nodes.calc;

import jdk.graal.compiler.core.common.type.ArithmeticOpTable;
import jdk.graal.compiler.core.common.type.Stamp;
import jdk.graal.compiler.graph.NodeClass;
import jdk.graal.compiler.lir.gen.ArithmeticLIRGeneratorTool;
import jdk.graal.compiler.nodeinfo.NodeCycles;
import jdk.graal.compiler.nodeinfo.NodeInfo;
import jdk.graal.compiler.nodes.ConstantNode;
import jdk.graal.compiler.nodes.NodeView;
import jdk.graal.compiler.nodes.ValueNode;
import jdk.graal.compiler.nodes.calc.BinaryArithmeticNode;
import jdk.graal.compiler.nodes.spi.CanonicalizerTool;
import jdk.graal.compiler.nodes.spi.NodeLIRBuilderTool;
import jdk.vm.ci.meta.Constant;

@NodeInfo(shortName="/", cycles=NodeCycles.CYCLES_32)
public class FloatDivNode
extends BinaryArithmeticNode<ArithmeticOpTable.BinaryOp.Div> {
    public static final NodeClass<FloatDivNode> TYPE = NodeClass.create(FloatDivNode.class);

    public FloatDivNode(ValueNode x, ValueNode y) {
        this(TYPE, x, y);
    }

    protected FloatDivNode(NodeClass<? extends FloatDivNode> c, ValueNode x, ValueNode y) {
        super(c, FloatDivNode.getArithmeticOpTable(x).getDiv(), x, y);
    }

    public static ValueNode create(ValueNode x, ValueNode y, NodeView view) {
        Stamp stamp;
        ArithmeticOpTable.BinaryOp<ArithmeticOpTable.BinaryOp.Div> op = ArithmeticOpTable.forStamp(x.stamp(view)).getDiv();
        ConstantNode tryConstantFold = FloatDivNode.tryConstantFold(op, x, y, stamp = op.foldStamp(x.stamp(view), y.stamp(view)), view);
        if (tryConstantFold != null) {
            return tryConstantFold;
        }
        return FloatDivNode.canonical(null, op, x, y);
    }

    @Override
    protected ArithmeticOpTable.BinaryOp<ArithmeticOpTable.BinaryOp.Div> getOp(ArithmeticOpTable table) {
        return table.getDiv();
    }

    @Override
    public ValueNode canonical(CanonicalizerTool tool, ValueNode forX, ValueNode forY) {
        ValueNode ret = super.canonical(tool, forX, forY);
        if (ret != this) {
            return ret;
        }
        return FloatDivNode.canonical(this, this.getOp(forX, forY), forX, forY);
    }

    private static ValueNode canonical(FloatDivNode self, ArithmeticOpTable.BinaryOp<ArithmeticOpTable.BinaryOp.Div> op, ValueNode forX, ValueNode forY) {
        Constant c;
        if (forY.isConstant() && op.isNeutral(c = forY.asConstant())) {
            return forX;
        }
        return self != null ? self : new FloatDivNode(forX, forY);
    }

    @Override
    public void generate(NodeLIRBuilderTool nodeValueMap, ArithmeticLIRGeneratorTool gen) {
        nodeValueMap.setResult(this, gen.emitDiv(nodeValueMap.operand(this.getX()), nodeValueMap.operand(this.getY()), null));
    }
}

