/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.nodes.calc;

import jdk.graal.compiler.core.common.calc.FloatConvert;
import jdk.graal.compiler.core.common.type.ArithmeticOpTable;
import jdk.graal.compiler.core.common.type.FloatStamp;
import jdk.graal.compiler.core.common.type.IntegerStamp;
import jdk.graal.compiler.core.common.type.Stamp;
import jdk.graal.compiler.debug.GraalError;
import jdk.graal.compiler.graph.NodeClass;
import jdk.graal.compiler.lir.gen.ArithmeticLIRGeneratorTool;
import jdk.graal.compiler.nodeinfo.NodeCycles;
import jdk.graal.compiler.nodeinfo.NodeInfo;
import jdk.graal.compiler.nodes.NodeView;
import jdk.graal.compiler.nodes.ValueNode;
import jdk.graal.compiler.nodes.calc.BinaryArithmeticNode;
import jdk.graal.compiler.nodes.calc.ConvertNode;
import jdk.graal.compiler.nodes.calc.UnaryArithmeticNode;
import jdk.graal.compiler.nodes.spi.ArithmeticLIRLowerable;
import jdk.graal.compiler.nodes.spi.CanonicalizerTool;
import jdk.graal.compiler.nodes.spi.Lowerable;
import jdk.graal.compiler.nodes.spi.NodeLIRBuilderTool;
import jdk.vm.ci.meta.Constant;
import jdk.vm.ci.meta.ConstantReflectionProvider;

@NodeInfo(cycles=NodeCycles.CYCLES_8)
public final class FloatConvertNode
extends UnaryArithmeticNode<ArithmeticOpTable.FloatConvertOp>
implements ConvertNode,
Lowerable,
ArithmeticLIRLowerable {
    public static final NodeClass<FloatConvertNode> TYPE = NodeClass.create(FloatConvertNode.class);
    protected final FloatConvert op;

    public FloatConvertNode(FloatConvert op, ValueNode input) {
        super(TYPE, BinaryArithmeticNode.getArithmeticOpTable(input).getFloatConvert(op), input);
        this.op = op;
    }

    public static ValueNode create(FloatConvert op, ValueNode input, NodeView view) {
        ValueNode synonym = FloatConvertNode.findSynonym(input, ArithmeticOpTable.forStamp(input.stamp(view)).getFloatConvert(op));
        if (synonym != null) {
            return synonym;
        }
        return new FloatConvertNode(op, input);
    }

    @Override
    protected ArithmeticOpTable.UnaryOp<ArithmeticOpTable.FloatConvertOp> getOp(ArithmeticOpTable table) {
        return table.getFloatConvert(this.op);
    }

    public FloatConvert getFloatConvert() {
        return this.op;
    }

    @Override
    public Constant convert(Constant c, ConstantReflectionProvider constantReflection) {
        return ((ArithmeticOpTable.UnaryOp)this.getArithmeticOp()).foldConstant(c);
    }

    @Override
    public Constant reverse(Constant c, ConstantReflectionProvider constantReflection) {
        ArithmeticOpTable.FloatConvertOp reverse = ArithmeticOpTable.forStamp(this.stamp(NodeView.DEFAULT)).getFloatConvert(this.op.reverse());
        return reverse.foldConstant(c);
    }

    @Override
    public boolean isLossless() {
        switch (this.getFloatConvert()) {
            case F2D: 
            case I2D: {
                return true;
            }
            case I2F: 
            case L2D: 
            case L2F: {
                if (this.value.stamp(NodeView.DEFAULT) instanceof IntegerStamp) {
                    return FloatConvertNode.isLosslessIntegerToFloatingPoint((IntegerStamp)this.value.stamp(NodeView.DEFAULT), (FloatStamp)this.stamp(NodeView.DEFAULT));
                }
                return false;
            }
        }
        return false;
    }

    public boolean inputCanBeNaN() {
        Stamp inputStamp = this.getValue().stamp(NodeView.DEFAULT);
        return ArithmeticOpTable.forStamp(inputStamp).getFloatConvert(this.op).inputCanBeNaN(inputStamp);
    }

    public boolean canOverflow() {
        Stamp inputStamp = this.getValue().stamp(NodeView.DEFAULT);
        return ArithmeticOpTable.forStamp(inputStamp).getFloatConvert(this.op).canOverflowInteger(inputStamp);
    }

    private static boolean isLosslessIntegerToFloatingPoint(IntegerStamp inputStamp, FloatStamp resultStamp) {
        int mantissaBits = switch (resultStamp.getBits()) {
            case 32 -> 24;
            case 64 -> 53;
            default -> throw GraalError.shouldNotReachHereUnexpectedValue(resultStamp.getBits());
        };
        long max = 1L << mantissaBits;
        long min = -(1L << mantissaBits);
        return min <= inputStamp.lowerBound() && inputStamp.upperBound() <= max;
    }

    @Override
    public ValueNode canonical(CanonicalizerTool tool, ValueNode forValue) {
        FloatConvertNode other;
        ValueNode ret = super.canonical(tool, forValue);
        if (ret != this) {
            return ret;
        }
        if (forValue instanceof FloatConvertNode && (other = (FloatConvertNode)forValue).isLossless() && other.op == this.op.reverse()) {
            return other.getValue();
        }
        return this;
    }

    @Override
    public void generate(NodeLIRBuilderTool nodeValueMap, ArithmeticLIRGeneratorTool gen) {
        nodeValueMap.setResult(this, gen.emitFloatConvert(this.getFloatConvert(), nodeValueMap.operand(this.getValue()), this.inputCanBeNaN(), this.canOverflow()));
    }

    @Override
    public boolean mayNullCheckSkipConversion() {
        return false;
    }
}

