/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.nodes.calc;

import jdk.graal.compiler.core.common.type.FloatStamp;
import jdk.graal.compiler.core.common.type.Stamp;
import jdk.graal.compiler.debug.GraalError;
import jdk.graal.compiler.graph.Node;
import jdk.graal.compiler.graph.NodeClass;
import jdk.graal.compiler.lir.gen.ArithmeticLIRGeneratorTool;
import jdk.graal.compiler.nodeinfo.NodeCycles;
import jdk.graal.compiler.nodeinfo.NodeInfo;
import jdk.graal.compiler.nodeinfo.NodeSize;
import jdk.graal.compiler.nodes.ConstantNode;
import jdk.graal.compiler.nodes.NodeView;
import jdk.graal.compiler.nodes.ValueNode;
import jdk.graal.compiler.nodes.calc.AndNode;
import jdk.graal.compiler.nodes.calc.BinaryNode;
import jdk.graal.compiler.nodes.calc.OrNode;
import jdk.graal.compiler.nodes.calc.ReinterpretNode;
import jdk.graal.compiler.nodes.spi.ArithmeticLIRLowerable;
import jdk.graal.compiler.nodes.spi.CanonicalizerTool;
import jdk.graal.compiler.nodes.spi.NodeLIRBuilderTool;
import jdk.vm.ci.meta.JavaKind;

@NodeInfo(cycles=NodeCycles.CYCLES_2, size=NodeSize.SIZE_1)
public final class CopySignNode
extends BinaryNode
implements ArithmeticLIRLowerable {
    public static final NodeClass<CopySignNode> TYPE = NodeClass.create(CopySignNode.class);

    public CopySignNode(ValueNode magnitude, ValueNode sign) {
        super(TYPE, CopySignNode.computeStamp(magnitude.stamp(NodeView.DEFAULT), sign.stamp(NodeView.DEFAULT)), magnitude, sign);
    }

    public static Stamp computeStamp(Stamp magnitude, Stamp sign) {
        if (magnitude.isEmpty()) {
            return magnitude;
        }
        if (sign.isEmpty()) {
            return sign;
        }
        FloatStamp magnitudeStamp = (FloatStamp)magnitude;
        FloatStamp signStamp = (FloatStamp)sign;
        if (magnitudeStamp.isNaN()) {
            return magnitude;
        }
        if (signStamp.isNonNaN()) {
            if (signStamp.lowerBound() > 0.0) {
                if (magnitudeStamp.lowerBound() > 0.0) {
                    return magnitudeStamp;
                }
                if (magnitudeStamp.upperBound() < 0.0) {
                    return FloatStamp.create(magnitudeStamp.getBits(), -magnitudeStamp.upperBound(), -magnitudeStamp.lowerBound(), magnitudeStamp.isNonNaN());
                }
                return FloatStamp.create(magnitudeStamp.getBits(), 0.0, Math.max(-magnitudeStamp.lowerBound(), magnitudeStamp.upperBound()), magnitudeStamp.isNonNaN());
            }
            if (signStamp.upperBound() < 0.0) {
                if (magnitudeStamp.upperBound() < 0.0) {
                    return magnitudeStamp;
                }
                if (magnitudeStamp.lowerBound() > 0.0) {
                    return FloatStamp.create(magnitudeStamp.getBits(), -magnitudeStamp.upperBound(), -magnitudeStamp.lowerBound(), magnitudeStamp.isNonNaN());
                }
                return FloatStamp.create(magnitudeStamp.getBits(), Math.min(magnitudeStamp.lowerBound(), -magnitudeStamp.upperBound()), 0.0, magnitudeStamp.isNonNaN());
            }
        }
        return FloatStamp.create(magnitudeStamp.getBits(), Math.min(magnitudeStamp.lowerBound(), -magnitudeStamp.upperBound()), Math.max(-magnitudeStamp.lowerBound(), magnitudeStamp.upperBound()), magnitudeStamp.isNonNaN());
    }

    @Override
    public Stamp foldStamp(Stamp stampX, Stamp stampY) {
        return CopySignNode.computeStamp(stampX, stampY);
    }

    private static Node canonicalHelper(ValueNode forX, float yValue) {
        if (forX.isJavaConstant()) {
            return ConstantNode.forFloat(Math.copySign(forX.asJavaConstant().asFloat(), yValue));
        }
        ValueNode result = OrNode.create(AndNode.create(ReinterpretNode.create(JavaKind.Int, forX, NodeView.DEFAULT), ConstantNode.forInt(Integer.MAX_VALUE), NodeView.DEFAULT), ConstantNode.forInt(Float.floatToIntBits(yValue) & Integer.MIN_VALUE), NodeView.DEFAULT);
        return ReinterpretNode.create(JavaKind.Float, result, NodeView.DEFAULT);
    }

    private static Node canonicalHelper(ValueNode forX, double yValue) {
        if (forX.isJavaConstant()) {
            return ConstantNode.forDouble(Math.copySign(forX.asJavaConstant().asDouble(), yValue));
        }
        ValueNode result = OrNode.create(AndNode.create(ReinterpretNode.create(JavaKind.Long, forX, NodeView.DEFAULT), ConstantNode.forLong(Long.MAX_VALUE), NodeView.DEFAULT), ConstantNode.forLong(Double.doubleToLongBits(yValue) & Long.MIN_VALUE), NodeView.DEFAULT);
        return ReinterpretNode.create(JavaKind.Double, result, NodeView.DEFAULT);
    }

    @Override
    public Node canonical(CanonicalizerTool tool, ValueNode forX, ValueNode forY) {
        FloatStamp floatStampY = (FloatStamp)forY.stamp(NodeView.DEFAULT);
        switch (forX.getStackKind()) {
            case Float: {
                if (forY.isJavaConstant()) {
                    return CopySignNode.canonicalHelper(forX, forY.asJavaConstant().asFloat());
                }
                if (!floatStampY.isNonNaN()) break;
                if (floatStampY.lowerBound() > 0.0) {
                    return CopySignNode.canonicalHelper(forX, 1.0f);
                }
                if (!(floatStampY.upperBound() < 0.0)) break;
                return CopySignNode.canonicalHelper(forX, -1.0f);
            }
            case Double: {
                if (forY.isJavaConstant()) {
                    return CopySignNode.canonicalHelper(forX, forY.asJavaConstant().asDouble());
                }
                if (!floatStampY.isNonNaN()) break;
                if (floatStampY.lowerBound() > 0.0) {
                    return CopySignNode.canonicalHelper(forX, 1.0);
                }
                if (!(floatStampY.upperBound() < 0.0)) break;
                return CopySignNode.canonicalHelper(forX, -1.0);
            }
            default: {
                throw GraalError.shouldNotReachHereUnexpectedValue(forX.getStackKind());
            }
        }
        return this;
    }

    @Override
    public void generate(NodeLIRBuilderTool nodeValueMap, ArithmeticLIRGeneratorTool gen) {
        nodeValueMap.setResult(this, gen.emitMathCopySign(nodeValueMap.operand(this.getX()), nodeValueMap.operand(this.getY())));
    }
}

