/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.nodes;

import jdk.graal.compiler.core.common.type.Stamp;
import jdk.graal.compiler.graph.Node;
import jdk.graal.compiler.graph.NodeClass;
import jdk.graal.compiler.nodeinfo.NodeInfo;
import jdk.graal.compiler.nodes.AbstractBeginNode;
import jdk.graal.compiler.nodes.ControlSplitNode;
import jdk.graal.compiler.nodes.FixedNode;
import jdk.graal.compiler.nodes.ProfileData;
import jdk.graal.compiler.nodes.UnreachableBeginNode;
import jdk.graal.compiler.nodes.UnreachableControlSinkNode;
import jdk.graal.compiler.nodes.util.GraphUtil;

@NodeInfo
public abstract class WithExceptionNode
extends ControlSplitNode {
    public static final NodeClass<WithExceptionNode> TYPE = NodeClass.create(WithExceptionNode.class);
    private static final double EXCEPTION_PROBABILITY = 1.0E-5;
    private static final ProfileData.BranchProbabilityData NORMAL_EXECUTION_PROFILE = ProfileData.BranchProbabilityData.injected(0.99999);
    @Node.Successor
    protected AbstractBeginNode next;
    @Node.Successor
    protected AbstractBeginNode exceptionEdge;

    protected WithExceptionNode(NodeClass<? extends WithExceptionNode> c, Stamp stamp) {
        super((NodeClass<? extends ControlSplitNode>)c, stamp);
    }

    public AbstractBeginNode next() {
        return this.next;
    }

    public void setNext(AbstractBeginNode x) {
        this.updatePredecessor(this.next, x);
        this.next = x;
    }

    @Override
    public AbstractBeginNode getPrimarySuccessor() {
        return this.next();
    }

    public AbstractBeginNode exceptionEdge() {
        return this.exceptionEdge;
    }

    public void setExceptionEdge(AbstractBeginNode x) {
        this.updatePredecessor(this.exceptionEdge, x);
        this.exceptionEdge = x;
    }

    public void killExceptionEdge() {
        AbstractBeginNode edge = this.exceptionEdge();
        if (edge != null) {
            this.setExceptionEdge(null);
            GraphUtil.killCFG(edge);
        }
    }

    @Override
    public double probability(AbstractBeginNode successor) {
        return successor == this.next ? this.getProfileData().getDesignatedSuccessorProbability() : this.getProfileData().getNegatedProbability();
    }

    @Override
    public boolean setProbability(AbstractBeginNode successor, ProfileData.BranchProbabilityData profileData) {
        return false;
    }

    @Override
    public ProfileData.BranchProbabilityData getProfileData() {
        return NORMAL_EXECUTION_PROFILE;
    }

    @Override
    public int getSuccessorCount() {
        return 2;
    }

    public FixedNode replaceWithNonThrowing() {
        this.killExceptionEdge();
        AbstractBeginNode newExceptionEdge = this.graph().add(new UnreachableBeginNode());
        newExceptionEdge.setNext(this.graph().add(new UnreachableControlSinkNode()));
        this.setExceptionEdge(newExceptionEdge);
        return this;
    }
}

