/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.nodes;

import jdk.graal.compiler.core.common.type.Stamp;
import jdk.graal.compiler.graph.Node;
import jdk.graal.compiler.graph.NodeClass;
import jdk.graal.compiler.nodeinfo.NodeInfo;
import jdk.graal.compiler.nodes.LIRLowerableLogicNode;
import jdk.graal.compiler.nodes.LogicConstantNode;
import jdk.graal.compiler.nodes.LogicNode;
import jdk.graal.compiler.nodes.NodeView;
import jdk.graal.compiler.nodes.PiNode;
import jdk.graal.compiler.nodes.ValueNode;
import jdk.graal.compiler.nodes.spi.Canonicalizable;
import jdk.graal.compiler.nodes.spi.ValueProxy;
import jdk.graal.compiler.nodes.spi.Virtualizable;
import jdk.graal.compiler.nodes.spi.VirtualizerTool;
import jdk.vm.ci.meta.TriState;

@NodeInfo
public abstract class UnaryOpLogicNode
extends LIRLowerableLogicNode
implements Canonicalizable.Unary<ValueNode>,
Virtualizable {
    public static final NodeClass<UnaryOpLogicNode> TYPE = NodeClass.create(UnaryOpLogicNode.class);
    @Node.Input
    protected ValueNode value;

    @Override
    public ValueNode getValue() {
        return this.value;
    }

    public UnaryOpLogicNode(NodeClass<? extends UnaryOpLogicNode> c, ValueNode value) {
        super((NodeClass<? extends LIRLowerableLogicNode>)c);
        assert (value != null);
        this.value = value;
    }

    @Override
    public void virtualize(VirtualizerTool tool) {
        ValueNode alias = tool.getAlias(this.getValue());
        TriState fold = this.tryFold(alias.stamp(NodeView.DEFAULT));
        if (fold != TriState.UNKNOWN) {
            tool.replaceWithValue(LogicConstantNode.forBoolean(fold.isTrue(), this.graph()));
        }
    }

    public abstract Stamp getSucceedingStampForValue(boolean var1);

    public abstract TriState tryFold(Stamp var1);

    @Override
    public TriState implies(boolean thisNegated, LogicNode other) {
        if (other instanceof UnaryOpLogicNode) {
            Stamp succStamp;
            TriState fold;
            UnaryOpLogicNode unaryY = (UnaryOpLogicNode)other;
            if ((this.getValue() == unaryY.getValue() || UnaryOpLogicNode.skipThroughPisAndProxies(this.getValue()) == UnaryOpLogicNode.skipThroughPisAndProxies(unaryY.getValue())) && (fold = unaryY.tryFold(succStamp = this.getSucceedingStampForValue(thisNegated))).isKnown()) {
                return fold;
            }
        }
        return super.implies(thisNegated, other);
    }

    private static ValueNode skipThroughPisAndProxies(ValueNode node) {
        ValueNode n = node;
        while (n != null) {
            if (n instanceof PiNode) {
                n = ((PiNode)n).getOriginalNode();
                continue;
            }
            if (!(n instanceof ValueProxy)) break;
            n = ((ValueProxy)((Object)n)).getOriginalNode();
        }
        return n;
    }
}

