/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.nodes;

import jdk.graal.compiler.core.common.type.Stamp;
import jdk.graal.compiler.debug.Assertions;
import jdk.graal.compiler.debug.DebugCloseable;
import jdk.graal.compiler.debug.DebugContext;
import jdk.graal.compiler.debug.TimerKey;
import jdk.graal.compiler.graph.Node;
import jdk.graal.compiler.graph.NodeClass;
import jdk.graal.compiler.graph.SuccessorEdges;
import jdk.graal.compiler.nodeinfo.InputType;
import jdk.graal.compiler.nodeinfo.NodeCycles;
import jdk.graal.compiler.nodeinfo.NodeInfo;
import jdk.graal.compiler.nodeinfo.NodeSize;
import jdk.graal.compiler.nodes.AbstractBeginNode;
import jdk.graal.compiler.nodes.BeginNode;
import jdk.graal.compiler.nodes.ControlSinkNode;
import jdk.graal.compiler.nodes.ControlSplitNode;
import jdk.graal.compiler.nodes.DeoptimizeNode;
import jdk.graal.compiler.nodes.FixedGuardNode;
import jdk.graal.compiler.nodes.FixedNode;
import jdk.graal.compiler.nodes.FixedWithNextNode;
import jdk.graal.compiler.nodes.GraphDecoder;
import jdk.graal.compiler.nodes.IfNode;
import jdk.graal.compiler.nodes.LogicConstantNode;
import jdk.graal.compiler.nodes.LogicNegationNode;
import jdk.graal.compiler.nodes.MergeNode;
import jdk.graal.compiler.nodes.StructuredGraph;
import jdk.graal.compiler.nodes.ValueNode;
import jdk.graal.compiler.nodes.ValuePhiNode;
import jdk.graal.compiler.nodes.WithExceptionNode;
import jdk.graal.compiler.nodes.calc.FloatingNode;
import jdk.graal.compiler.nodes.extended.AnchoringNode;
import jdk.graal.compiler.nodes.extended.GuardingNode;
import jdk.graal.compiler.nodes.extended.IntegerSwitchNode;
import jdk.graal.compiler.nodes.extended.UnsafeAccessNode;
import jdk.graal.compiler.nodes.java.ArrayLengthNode;
import jdk.graal.compiler.nodes.java.LoadFieldNode;
import jdk.graal.compiler.nodes.java.LoadIndexedNode;
import jdk.graal.compiler.nodes.spi.Canonicalizable;
import jdk.graal.compiler.nodes.spi.CanonicalizerTool;
import jdk.graal.compiler.nodes.spi.CoreProviders;
import jdk.graal.compiler.nodes.spi.CoreProvidersDelegate;
import jdk.graal.compiler.nodes.util.GraphUtil;
import jdk.graal.compiler.options.OptionValues;
import jdk.vm.ci.code.Architecture;
import jdk.vm.ci.meta.Assumptions;

public class SimplifyingGraphDecoder
extends GraphDecoder {
    private static final TimerKey CanonicalizeFixedNode = DebugContext.timer("PartialEvaluation-CanonicalizeFixedNode").doc("Time spent in simplifying fixed nodes.");
    protected final CoreProviders providers;
    protected final boolean canonicalizeReads;
    protected final CanonicalizerTool canonicalizerTool;

    public SimplifyingGraphDecoder(Architecture architecture, StructuredGraph graph, CoreProviders providers, boolean canonicalizeReads) {
        super(architecture, graph);
        this.providers = providers;
        this.canonicalizeReads = canonicalizeReads;
        this.canonicalizerTool = new PECanonicalizerTool(graph.getAssumptions(), graph.getOptions());
    }

    @Override
    protected void cleanupGraph(GraphDecoder.MethodScope methodScope) {
        GraphUtil.normalizeLoops(this.graph);
        super.cleanupGraph(methodScope);
        for (Node node : this.graph.getNewNodes(methodScope.methodStartMark)) {
            if (node instanceof MergeNode) {
                MergeNode mergeNode = (MergeNode)node;
                if (mergeNode.forwardEndCount() != 1) continue;
                this.graph.reduceTrivialMerge(mergeNode);
                continue;
            }
            if (!(node instanceof BeginNode) || node.predecessor() instanceof ControlSplitNode || !node.hasNoUsages()) continue;
            GraphUtil.unlinkFixedNode((AbstractBeginNode)node);
            node.safeDelete();
        }
        for (Node node : this.graph.getNewNodes(methodScope.methodStartMark)) {
            GraphUtil.tryKillUnused(node);
        }
    }

    @Override
    protected boolean allowLazyPhis() {
        return true;
    }

    @Override
    protected void handleMergeNode(MergeNode merge) {
        for (ValuePhiNode phi : merge.valuePhis()) {
            phi.inferStamp();
        }
    }

    @Override
    protected void handleFixedNode(GraphDecoder.MethodScope methodScope, GraphDecoder.LoopScope loopScope, int nodeOrderId, FixedNode node) {
        try (DebugCloseable a = CanonicalizeFixedNode.start(this.debug);){
            Node canonical = this.canonicalizeFixedNode(methodScope, loopScope, node);
            if (canonical != node) {
                this.handleCanonicalization(loopScope, nodeOrderId, node, canonical);
            }
        }
    }

    protected Node canonicalizeFixedNode(GraphDecoder.MethodScope methodScope, GraphDecoder.LoopScope loopScope, Node originalNode) {
        Node node = originalNode;
        if (originalNode instanceof UnsafeAccessNode) {
            node = ((UnsafeAccessNode)node).canonical(this.canonicalizerTool);
        }
        if (node instanceof LoadFieldNode) {
            LoadFieldNode loadFieldNode = (LoadFieldNode)node;
            return loadFieldNode.canonical(this.canonicalizerTool);
        }
        if (node instanceof FixedGuardNode) {
            FixedGuardNode guard = (FixedGuardNode)node;
            if (guard.getCondition() instanceof LogicConstantNode) {
                LogicConstantNode condition = (LogicConstantNode)guard.getCondition();
                if (condition.getValue() == guard.isNegated()) {
                    DeoptimizeNode deopt = new DeoptimizeNode(guard.getAction(), guard.getReason(), guard.getSpeculation());
                    if (guard.stateBefore() != null) {
                        deopt.setStateBefore(guard.stateBefore());
                    }
                    return deopt;
                }
                return null;
            }
            return node;
        }
        if (node instanceof IfNode) {
            IfNode ifNode = (IfNode)node;
            if (ifNode.condition() instanceof LogicNegationNode) {
                ifNode.eliminateNegation();
            }
            return ifNode;
        }
        if (node instanceof LoadIndexedNode) {
            LoadIndexedNode loadIndexedNode = (LoadIndexedNode)node;
            return loadIndexedNode.canonical(this.canonicalizerTool);
        }
        if (node instanceof ArrayLengthNode) {
            ArrayLengthNode arrayLengthNode = (ArrayLengthNode)node;
            return arrayLengthNode.canonical(this.canonicalizerTool);
        }
        if (node instanceof Canonicalizable) {
            return ((Canonicalizable)((Object)node)).canonical(this.canonicalizerTool);
        }
        return node;
    }

    @Override
    protected boolean earlyCanonicalization(GraphDecoder.MethodScope methodScope, GraphDecoder.LoopScope loopScope, int nodeOrderId, FixedNode node) {
        if (node instanceof IfNode && ((IfNode)node).condition() instanceof LogicConstantNode) {
            int survivingIndex;
            IfNode ifNode = (IfNode)node;
            assert (!(ifNode.condition() instanceof LogicNegationNode)) : "Negation of a constant must have been canonicalized before";
            int n = survivingIndex = ((LogicConstantNode)ifNode.condition()).getValue() ? 0 : 1;
            if (Assertions.assertionsEnabled()) {
                SuccessorEdges edges = ifNode.getNodeClass().getSuccessorEdges();
                assert (edges.getDirectCount() == 2) : "IfNode expected to have 2 direct successors";
                assert (edges.getName(0).equals("trueSuccessor")) : "Unexpected IfNode encoding";
                assert (edges.getName(1).equals("falseSuccessor")) : "Unexpected IfNode encoding";
                assert (edges.getCount() == 2) : "IntegerSwitchNode expected to have 0 indirect successor";
            }
            long successorsByteIndex = methodScope.reader.getByteIndex();
            methodScope.reader.setByteIndex(successorsByteIndex + (long)(survivingIndex * methodScope.orderIdWidth));
            int survivingOrderId = this.readOrderId(methodScope);
            methodScope.reader.setByteIndex(successorsByteIndex + (long)(2 * methodScope.orderIdWidth));
            this.removeSplit(methodScope, loopScope, ifNode, survivingOrderId);
            return true;
        }
        if (node instanceof IntegerSwitchNode && ((IntegerSwitchNode)node).value().isConstant()) {
            IntegerSwitchNode switchNode = (IntegerSwitchNode)node;
            int value = switchNode.value().asJavaConstant().asInt();
            int survivingIndex = switchNode.successorIndexAtKey(value);
            if (Assertions.assertionsEnabled()) {
                SuccessorEdges edges = switchNode.getNodeClass().getSuccessorEdges();
                assert (edges.getDirectCount() == 0) : "IntegerSwitchNode expected to have 0 direct successor";
                assert (edges.getCount() == 1) : "IntegerSwitchNode expected to have 1 indirect successor";
                assert (edges.getName(0).equals("successors")) : "Unexpected IntegerSwitchNode encoding";
            }
            int size = methodScope.reader.getSVInt();
            long successorsByteIndex = methodScope.reader.getByteIndex();
            methodScope.reader.setByteIndex(successorsByteIndex + (long)(survivingIndex * methodScope.orderIdWidth));
            int survivingOrderId = this.readOrderId(methodScope);
            methodScope.reader.setByteIndex(successorsByteIndex + (long)(size * methodScope.orderIdWidth));
            this.removeSplit(methodScope, loopScope, switchNode, survivingOrderId);
            return true;
        }
        return false;
    }

    private void removeSplit(GraphDecoder.MethodScope methodScope, GraphDecoder.LoopScope loopScope, ControlSplitNode controlSplit, int survivingOrderId) {
        if (controlSplit.predecessor() instanceof BeginNode && this.getNodeClass(methodScope, loopScope, survivingOrderId) == controlSplit.predecessor().getNodeClass()) {
            loopScope.nodesToProcess.set(survivingOrderId);
            this.registerNode(loopScope, survivingOrderId, controlSplit.predecessor(), false, false);
            assert (controlSplit.hasNoUsages());
            controlSplit.clearSuccessors();
            controlSplit.replaceAtPredecessor(null);
            controlSplit.safeDelete();
        } else {
            AbstractBeginNode survivingSuccessor = (AbstractBeginNode)this.makeStubNode(methodScope, loopScope, survivingOrderId);
            this.graph.removeSplit(controlSplit, survivingSuccessor);
        }
    }

    private static Node canonicalizeFixedNodeToNull(FixedNode node) {
        return new CanonicalizeToNullNode(node.stamp);
    }

    /*
     * Unable to fully structure code
     */
    private void handleCanonicalization(GraphDecoder.LoopScope loopScope, int nodeOrderId, FixedNode node, Node c) {
        if (!SimplifyingGraphDecoder.$assertionsDisabled && c == node) {
            throw new AssertionError((Object)"unnecessary call");
        }
        position = this.graph.withNodeSourcePosition(node);
        try {
            block24: {
                v0 = canonical = c == null ? SimplifyingGraphDecoder.canonicalizeFixedNodeToNull(node) : c;
                if (!canonical.isAlive()) {
                    if (!SimplifyingGraphDecoder.$assertionsDisabled && canonical.isDeleted()) {
                        throw new AssertionError();
                    }
                    if ((canonical = this.graph.addOrUniqueWithInputs(canonical)) instanceof FixedWithNextNode) {
                        this.graph.addBeforeFixed(node, (FixedWithNextNode)canonical);
                    } else if (canonical instanceof ControlSinkNode) {
                        predecessor = (FixedWithNextNode)node.predecessor();
                        predecessor.setNext((ControlSinkNode)canonical);
                        successorSnapshot = node.successors().snapshot();
                        node.safeDelete();
                        for (Node successor : successorSnapshot) {
                            successor.safeDelete();
                        }
                    } else if (canonical instanceof WithExceptionNode) {
                        if (!SimplifyingGraphDecoder.$assertionsDisabled && !(node instanceof WithExceptionNode)) {
                            throw new AssertionError((Object)Assertions.errorMessage(new Object[]{"Only WithExceptionNodes can canonicalize to WithException nodes", node, canonical}));
                        }
                    } else if (!SimplifyingGraphDecoder.$assertionsDisabled && canonical instanceof FixedNode) {
                        throw new AssertionError((Object)Assertions.errorMessageContext("canonical", canonical));
                    }
                }
                if (node.isDeleted()) break block24;
                if (!(node instanceof WithExceptionNode)) ** GOTO lbl-1000
                we = (WithExceptionNode)node;
                if (canonical instanceof WithExceptionNode) {
                    weCanon = (WithExceptionNode)canonical;
                    this.graph.replaceWithExceptionSplit(we, weCanon);
                } else lbl-1000:
                // 2 sources

                {
                    if (node instanceof WithExceptionNode) {
                        GraphUtil.unlinkAndKillExceptionEdge((WithExceptionNode)node);
                    } else {
                        GraphUtil.unlinkFixedNode((FixedWithNextNode)node);
                    }
                    node.replaceAtUsagesAndDelete(canonical);
                }
            }
            if (!SimplifyingGraphDecoder.$assertionsDisabled && this.lookupNode(loopScope, nodeOrderId) != node) {
                throw new AssertionError((Object)Assertions.errorMessage(new Object[]{node, loopScope, nodeOrderId}));
            }
            this.registerNode(loopScope, nodeOrderId, canonical, true, false);
        }
        finally {
            if (position != null) {
                position.close();
            }
        }
    }

    @Override
    protected Node handleFloatingNodeBeforeAdd(GraphDecoder.MethodScope methodScope, GraphDecoder.LoopScope loopScope, Node node) {
        if (node instanceof ValueNode) {
            ((ValueNode)node).inferStamp();
        }
        if (node instanceof Canonicalizable) {
            try (DebugCloseable context = this.graph.withNodeSourcePosition(node);){
                Node canonical = ((Canonicalizable)((Object)node)).canonical(this.canonicalizerTool);
                if (canonical == null) {
                } else if (canonical != node) {
                    if (!canonical.isAlive()) {
                        assert (!canonical.isDeleted());
                        canonical = this.graph.addOrUniqueWithInputs(canonical);
                    }
                    assert (node.hasNoUsages());
                    Node node2 = canonical;
                    return node2;
                }
            }
        }
        return node;
    }

    @Override
    protected Node addFloatingNode(GraphDecoder.MethodScope methodScope, GraphDecoder.LoopScope loopScope, Node node) {
        return this.graph.addOrUnique(node);
    }

    protected class PECanonicalizerTool
    extends CoreProvidersDelegate
    implements CanonicalizerTool {
        private final Assumptions assumptions;
        private final OptionValues options;

        public PECanonicalizerTool(Assumptions assumptions, OptionValues options) {
            super(SimplifyingGraphDecoder.this.providers);
            this.assumptions = assumptions;
            this.options = options;
        }

        @Override
        public OptionValues getOptions() {
            return this.options;
        }

        @Override
        public boolean canonicalizeReads() {
            return SimplifyingGraphDecoder.this.canonicalizeReads;
        }

        @Override
        public boolean allUsagesAvailable() {
            return false;
        }

        @Override
        public Assumptions getAssumptions() {
            return this.assumptions;
        }

        @Override
        public Integer smallestCompareWidth() {
            return null;
        }

        @Override
        public boolean supportsRounding() {
            return this.getLowerer().supportsRounding();
        }

        @Override
        public boolean divisionOverflowIsJVMSCompliant() {
            return this.getLowerer().divisionOverflowIsJVMSCompliant();
        }
    }

    @NodeInfo(cycles=NodeCycles.CYCLES_IGNORED, size=NodeSize.SIZE_IGNORED, allowedUsageTypes={InputType.Guard, InputType.Anchor})
    static class CanonicalizeToNullNode
    extends FloatingNode
    implements Canonicalizable,
    GuardingNode,
    AnchoringNode {
        public static final NodeClass<CanonicalizeToNullNode> TYPE = NodeClass.create(CanonicalizeToNullNode.class);

        protected CanonicalizeToNullNode(Stamp stamp) {
            super((NodeClass<? extends FloatingNode>)TYPE, stamp);
        }

        @Override
        public Node canonical(CanonicalizerTool tool) {
            return null;
        }
    }
}

