/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.nodes;

import jdk.graal.compiler.graph.Node;
import jdk.graal.compiler.graph.NodeClass;
import jdk.graal.compiler.nodeinfo.NodeCycles;
import jdk.graal.compiler.nodeinfo.NodeInfo;
import jdk.graal.compiler.nodeinfo.NodeSize;
import jdk.graal.compiler.nodes.MemoryMapControlSinkNode;
import jdk.graal.compiler.nodes.ValueNode;
import jdk.graal.compiler.nodes.memory.MemoryMapNode;
import jdk.graal.compiler.nodes.spi.LIRLowerable;
import jdk.graal.compiler.nodes.spi.NodeLIRBuilderTool;
import jdk.vm.ci.code.TargetDescription;
import jdk.vm.ci.meta.JavaKind;

@NodeInfo(cycles=NodeCycles.CYCLES_2, size=NodeSize.SIZE_4, cyclesRationale="Restore frame + ret", sizeRationale="Restore frame + ret")
public final class ReturnNode
extends MemoryMapControlSinkNode
implements LIRLowerable {
    public static final NodeClass<ReturnNode> TYPE = NodeClass.create(ReturnNode.class);
    @Node.OptionalInput
    ValueNode result;

    public ValueNode result() {
        return this.result;
    }

    public ReturnNode(ValueNode result) {
        this(result, null);
    }

    public ReturnNode(ValueNode result, MemoryMapNode memoryMap) {
        super(TYPE, memoryMap);
        this.result = result;
    }

    @Override
    public void generate(NodeLIRBuilderTool gen) {
        assert (this.verifyReturn(gen.getLIRGeneratorTool().target()));
        if (this.result == null) {
            gen.getLIRGeneratorTool().emitReturn(JavaKind.Void, null);
        } else {
            gen.getLIRGeneratorTool().emitReturn(this.result.getStackKind(), gen.operand(this.result));
        }
    }

    private boolean verifyReturn(TargetDescription target) {
        if (this.graph().method() != null) {
            JavaKind actual = this.result == null ? JavaKind.Void : this.result.getStackKind();
            JavaKind expected = this.graph().method().getSignature().getReturnKind().getStackKind();
            if (actual == target.wordJavaKind && expected == JavaKind.Object) {
                return true;
            }
            assert (actual == expected) : "return kind doesn't match: actual " + String.valueOf(actual) + ", expected: " + String.valueOf(expected);
        }
        return true;
    }
}

