/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.nodes;

import jdk.graal.compiler.core.common.GraalOptions;
import jdk.graal.compiler.core.common.type.StampFactory;
import jdk.graal.compiler.graph.Node;
import jdk.graal.compiler.graph.NodeClass;
import jdk.graal.compiler.nodeinfo.InputType;
import jdk.graal.compiler.nodeinfo.NodeCycles;
import jdk.graal.compiler.nodeinfo.NodeInfo;
import jdk.graal.compiler.nodeinfo.NodeSize;
import jdk.graal.compiler.nodes.FixedWithNextNode;
import jdk.graal.compiler.nodes.ValueNode;
import jdk.graal.compiler.nodes.memory.address.AddressNode;
import jdk.graal.compiler.nodes.spi.LIRLowerable;
import jdk.graal.compiler.nodes.spi.NodeLIRBuilderTool;

@NodeInfo(cycles=NodeCycles.CYCLES_2, size=NodeSize.SIZE_2)
public final class PrefetchAllocateNode
extends FixedWithNextNode
implements LIRLowerable {
    public static final NodeClass<PrefetchAllocateNode> TYPE = NodeClass.create(PrefetchAllocateNode.class);
    @Node.Input(value=InputType.Association)
    AddressNode address;

    public PrefetchAllocateNode(ValueNode address) {
        super((NodeClass<? extends FixedWithNextNode>)TYPE, StampFactory.forVoid());
        this.address = (AddressNode)address;
    }

    @Override
    public void generate(NodeLIRBuilderTool gen) {
        if (!GraalOptions.ReduceCodeSize.getValue(this.getOptions()).booleanValue()) {
            gen.getLIRGeneratorTool().emitPrefetchAllocate(gen.operand(this.address));
        }
    }

    @Node.NodeIntrinsic
    public static native void prefetch(AddressNode.Address var0);
}

