/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.nodes;

import java.util.Map;
import jdk.graal.compiler.core.common.type.Stamp;
import jdk.graal.compiler.graph.Node;
import jdk.graal.compiler.graph.NodeClass;
import jdk.graal.compiler.graph.NodeInputList;
import jdk.graal.compiler.nodeinfo.NodeCycles;
import jdk.graal.compiler.nodeinfo.NodeInfo;
import jdk.graal.compiler.nodeinfo.NodeSize;
import jdk.graal.compiler.nodeinfo.Verbosity;
import jdk.graal.compiler.nodes.FixedWithNextNode;
import jdk.graal.compiler.nodes.PluginReplacementInterface;
import jdk.graal.compiler.nodes.ValueNode;
import jdk.graal.compiler.nodes.graphbuilderconf.GraphBuilderContext;
import jdk.graal.compiler.nodes.spi.Replacements;

@NodeInfo(nameTemplate="PluginReplacement/{p#pluginName}", cycles=NodeCycles.CYCLES_IGNORED, size=NodeSize.SIZE_IGNORED)
public final class PluginReplacementNode
extends FixedWithNextNode
implements PluginReplacementInterface {
    public static final NodeClass<PluginReplacementNode> TYPE = NodeClass.create(PluginReplacementNode.class);
    @Node.Input
    protected NodeInputList<ValueNode> args;
    private final ReplacementFunction function;
    private final String pluginName;

    public PluginReplacementNode(Stamp stamp, ValueNode[] args, ReplacementFunction function, String pluginName) {
        super((NodeClass<? extends FixedWithNextNode>)TYPE, stamp);
        this.args = new NodeInputList((Node)this, (Node[])args);
        this.function = function;
        this.pluginName = pluginName;
    }

    @Override
    public boolean replace(GraphBuilderContext b, Replacements injection) {
        return this.function.replace(b, injection, this.stamp, this.args);
    }

    @Override
    public String toString(Verbosity verbosity) {
        if (verbosity == Verbosity.Short) {
            return super.toString(verbosity) + "/" + this.pluginName;
        }
        return super.toString(verbosity);
    }

    @Override
    public Map<Object, Object> getDebugProperties(Map<Object, Object> map) {
        map.put("name", this.pluginName);
        return super.getDebugProperties(map);
    }

    public static interface ReplacementFunction {
        public boolean replace(GraphBuilderContext var1, Replacements var2, Stamp var3, NodeInputList<ValueNode> var4);
    }
}

