/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.nodes;

import jdk.graal.compiler.core.common.type.Stamp;
import jdk.graal.compiler.debug.Assertions;
import jdk.graal.compiler.debug.GraalError;
import jdk.graal.compiler.graph.Node;
import jdk.graal.compiler.graph.NodeClass;
import jdk.graal.compiler.graph.NodeInputList;
import jdk.graal.compiler.graph.iterators.NodeIterable;
import jdk.graal.compiler.nodeinfo.InputType;
import jdk.graal.compiler.nodeinfo.NodeCycles;
import jdk.graal.compiler.nodeinfo.NodeInfo;
import jdk.graal.compiler.nodeinfo.NodeSize;
import jdk.graal.compiler.nodeinfo.Verbosity;
import jdk.graal.compiler.nodes.AbstractEndNode;
import jdk.graal.compiler.nodes.AbstractMergeNode;
import jdk.graal.compiler.nodes.LoopBeginNode;
import jdk.graal.compiler.nodes.LoopExitNode;
import jdk.graal.compiler.nodes.NodeView;
import jdk.graal.compiler.nodes.ProxyNode;
import jdk.graal.compiler.nodes.ValueNode;
import jdk.graal.compiler.nodes.ValuePhiNode;
import jdk.graal.compiler.nodes.calc.FloatingNode;
import jdk.graal.compiler.nodes.spi.Canonicalizable;
import jdk.graal.compiler.nodes.spi.CanonicalizerTool;

@NodeInfo(cycles=NodeCycles.CYCLES_0, size=NodeSize.SIZE_1)
public abstract class PhiNode
extends FloatingNode
implements Canonicalizable {
    public static final NodeClass<PhiNode> TYPE = NodeClass.create(PhiNode.class);
    @Node.Input(value=InputType.Association)
    protected AbstractMergeNode merge;

    protected PhiNode(NodeClass<? extends PhiNode> c, Stamp stamp, AbstractMergeNode merge) {
        super((NodeClass<? extends FloatingNode>)c, stamp);
        this.merge = merge;
    }

    public abstract InputType valueInputType();

    public abstract NodeInputList<ValueNode> values();

    public AbstractMergeNode merge() {
        return this.merge;
    }

    public void setMerge(AbstractMergeNode x) {
        this.updateUsages(this.merge, x);
        this.merge = x;
    }

    @Override
    public boolean verifyNode() {
        this.assertTrue(this.merge() != null, "missing merge", new Object[0]);
        this.assertTrue(this.merge().phiPredecessorCount() == this.valueCount(), "mismatch between merge predecessor count and phi value count: %d != %d", this.merge().phiPredecessorCount(), this.valueCount());
        this.verifyNoIllegalSelfLoops();
        return super.verifyNode();
    }

    private void verifyNoIllegalSelfLoops() {
        if (!(this.merge instanceof LoopBeginNode)) {
            for (int i = 0; i < this.valueCount(); ++i) {
                GraalError.guarantee(this.valueAt(i) != this, "non-loop phi at merge %s must not have a cycle, but value at index %s is itself: %s", (Object)this.merge(), (Object)i, (Object)this.valueAt(i));
            }
        }
    }

    private void verifyNoIllegalSelfLoop(ValueNode value) {
        if (!(this.merge instanceof LoopBeginNode)) {
            GraalError.guarantee(value != this, "non-loop phi at merge %s must not have a cycle, but value to be added is itself: %s", (Object)this.merge(), (Object)value);
        }
    }

    public ValueNode valueAt(int i) {
        return (ValueNode)this.values().get(i);
    }

    public void initializeValueAt(int i, ValueNode x) {
        this.verifyNoIllegalSelfLoop(x);
        while (this.values().size() <= i) {
            this.values().add((Object)null);
        }
        this.values().set(i, (Object)x);
    }

    public void setValueAt(int i, ValueNode x) {
        this.verifyNoIllegalSelfLoop(x);
        this.values().set(i, (Object)x);
    }

    public void setValueAt(AbstractEndNode end, ValueNode x) {
        this.setValueAt(this.merge().phiPredecessorIndex(end), x);
    }

    public ValueNode valueAt(AbstractEndNode pred) {
        return this.valueAt(this.merge().phiPredecessorIndex(pred));
    }

    public int valueCount() {
        return this.values().size();
    }

    @Override
    public String toString(Verbosity verbosity) {
        if (verbosity == Verbosity.Name) {
            StringBuilder str = new StringBuilder();
            for (int i = 0; i < this.valueCount(); ++i) {
                if (i != 0) {
                    str.append(' ');
                }
                str.append(this.valueAt(i) == null ? "-" : this.valueAt(i).toString(Verbosity.Id));
            }
            String description = this.valueDescription();
            if (description.length() > 0) {
                str.append(", ").append(description);
            }
            return super.toString(Verbosity.Name) + "(" + String.valueOf(str) + ")";
        }
        return super.toString(verbosity);
    }

    protected String valueDescription() {
        return "";
    }

    public void addInput(ValueNode x) {
        assert (!(x instanceof ValuePhiNode) || ((ValuePhiNode)x).merge() instanceof LoopBeginNode || ((ValuePhiNode)x).merge() != this.merge()) : Assertions.errorMessageContext("this", this, "x", x);
        assert (!(this instanceof ValuePhiNode) || x.stamp(NodeView.DEFAULT).isCompatible(this.stamp(NodeView.DEFAULT))) : Assertions.errorMessageContext("this", this, "x", x);
        this.verifyNoIllegalSelfLoop(x);
        this.values().add((Object)x);
    }

    public void removeInput(int index) {
        this.values().remove(index);
    }

    public NodeIterable<ValueNode> backValues() {
        return this.values().subList(this.merge().forwardEndCount());
    }

    public ValueNode singleValueOrThis() {
        ValueNode singleValue = this.valueAt(0);
        int count = this.valueCount();
        for (int i = 1; i < count; ++i) {
            ValueNode value = this.valueAt(i);
            if (value == this || value == singleValue) continue;
            return this;
        }
        return singleValue;
    }

    public ValueNode singleBackValueOrThis() {
        int valueCount = this.valueCount();
        assert (this.merge() instanceof LoopBeginNode && valueCount >= 2) : Assertions.errorMessageContext("this", this, "merge", this.merge(), "valCount", valueCount);
        ValueNode singleValue = this.valueAt(1);
        for (int i = 2; i < valueCount; ++i) {
            ValueNode value = this.valueAt(i);
            if (value == singleValue) continue;
            return this;
        }
        return singleValue;
    }

    @Override
    public ValueNode canonical(CanonicalizerTool tool) {
        if (this.isLoopPhi()) {
            ValueNode value;
            int i;
            int valueCount = this.valueCount();
            assert (valueCount >= 2) : Assertions.errorMessageContext("valueCount", valueCount, "this", this);
            for (i = 1; i < valueCount && (value = this.valueAt(i)) == this; ++i) {
            }
            if (i == valueCount) {
                return this.firstValue();
            }
            boolean onlySelfUsage = true;
            for (Node n : this.usages()) {
                if (n == this) continue;
                onlySelfUsage = false;
                break;
            }
            if (onlySelfUsage) {
                return null;
            }
        }
        PhiNode canonical = this;
        if (!this.isLoopPhi()) {
            boolean canForwardInputs = false;
            for (int i = 0; i < this.valueCount(); ++i) {
                if (!this.merge.isPhiAtMerge(this.valueAt(i))) continue;
                canForwardInputs = true;
                break;
            }
            if (canForwardInputs) {
                ValueNode[] canonicalInputs = new ValueNode[this.valueCount()];
                for (int i = 0; i < this.valueCount(); ++i) {
                    ValueNode input = this.valueAt(i);
                    while (this.merge.isPhiAtMerge(input)) {
                        input = ((PhiNode)input).valueAt(i);
                    }
                    canonicalInputs[i] = input;
                }
                canonical = this.duplicateWithValues(this.merge(), canonicalInputs);
            }
        }
        return canonical.singleValueOrThis();
    }

    public ValueNode firstValue() {
        return this.valueAt(0);
    }

    public boolean isLoopPhi() {
        return this.merge() instanceof LoopBeginNode;
    }

    public boolean isDegenerated() {
        for (Node use : this.usages()) {
            if (use == this) continue;
            return false;
        }
        GraalError.guarantee(this.isLoopPhi(), "Only loop phis may be degenerated %s", (Object)this);
        assert (this.isLoopPhi());
        return true;
    }

    public abstract ProxyNode createProxyFor(LoopExitNode var1);

    public abstract PhiNode duplicateOn(AbstractMergeNode var1);

    public abstract PhiNode duplicateWithValues(AbstractMergeNode var1, ValueNode ... var2);
}

