/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.nodes;

import java.util.EnumMap;
import jdk.vm.ci.meta.JavaKind;
import org.graalvm.collections.EconomicSet;
import org.graalvm.collections.Equivalence;
import org.graalvm.word.LocationIdentity;

public class NamedLocationIdentity
extends LocationIdentity
implements JavaKind.FormatWithToString {
    public static final LocationIdentity FINAL_LOCATION = NamedLocationIdentity.immutable("FINAL_LOCATION");
    public static final LocationIdentity ARRAY_LENGTH_LOCATION = NamedLocationIdentity.immutable("[].length");
    public static final LocationIdentity OFF_HEAP_LOCATION = NamedLocationIdentity.mutable("OFF_HEAP_LOCATION");
    private final String name;
    private final boolean immutable;
    private static final EnumMap<JavaKind, LocationIdentity> ARRAY_LOCATIONS = new EnumMap(JavaKind.class);
    public static final LocationIdentity BOOLEAN_ARRAY_LOCATION = NamedLocationIdentity.initArrayLocation(JavaKind.Boolean);
    public static final LocationIdentity BYTE_ARRAY_LOCATION = NamedLocationIdentity.initArrayLocation(JavaKind.Byte);
    public static final LocationIdentity CHAR_ARRAY_LOCATION = NamedLocationIdentity.initArrayLocation(JavaKind.Char);
    public static final LocationIdentity SHORT_ARRAY_LOCATION = NamedLocationIdentity.initArrayLocation(JavaKind.Short);
    public static final LocationIdentity INT_ARRAY_LOCATION = NamedLocationIdentity.initArrayLocation(JavaKind.Int);
    public static final LocationIdentity FLOAT_ARRAY_LOCATION = NamedLocationIdentity.initArrayLocation(JavaKind.Float);
    public static final LocationIdentity LONG_ARRAY_LOCATION = NamedLocationIdentity.initArrayLocation(JavaKind.Long);
    public static final LocationIdentity DOUBLE_ARRAY_LOCATION = NamedLocationIdentity.initArrayLocation(JavaKind.Double);
    public static final LocationIdentity OBJECT_ARRAY_LOCATION = NamedLocationIdentity.initArrayLocation(JavaKind.Object);

    protected NamedLocationIdentity(String name, boolean immutable) {
        this.name = name;
        this.immutable = immutable;
        assert (DB.checkUnique(name));
    }

    public static NamedLocationIdentity mutable(String name) {
        return NamedLocationIdentity.create(name, false);
    }

    public static NamedLocationIdentity immutable(String name) {
        return NamedLocationIdentity.create(name, true);
    }

    private static NamedLocationIdentity create(String name, boolean immutable) {
        return new NamedLocationIdentity(name, immutable);
    }

    public boolean isImmutable() {
        return this.immutable;
    }

    public String toString() {
        return this.name + (this.isImmutable() ? ":final" : "");
    }

    public static LocationIdentity getArrayLocation(JavaKind elementKind) {
        return ARRAY_LOCATIONS.get(elementKind);
    }

    private static NamedLocationIdentity initArrayLocation(JavaKind kind) {
        NamedLocationIdentity loc = NamedLocationIdentity.mutable("Array: " + kind.getJavaName());
        ARRAY_LOCATIONS.put(kind, loc);
        return loc;
    }

    public static boolean isArrayLocation(LocationIdentity l) {
        return ARRAY_LOCATIONS.containsValue(l);
    }

    static class DB {
        private static final EconomicSet<String> map = EconomicSet.create((Equivalence)Equivalence.DEFAULT);

        DB() {
        }

        static boolean checkUnique(String name) {
            if (!map.add((Object)name)) {
                throw new AssertionError((Object)("identity " + name + " already exists"));
            }
            return true;
        }
    }
}

